//Source & info: www.HomoFaciens.de

// include the library code:
#include <LiquidCrystal.h>
#include <util/delay.h>

int sensorStatus = 0;
int sensorStatusOld = 0;
int count = 0;
unsigned long millisStart = 0;

#define LCD_RS   2
#define LCD_EN   3
#define LCD_D4   4
#define LCD_D5   5
#define LCD_D6   6
#define LCD_D7   7

#define SENSOR  A0

#define BOUNCE_TIME    50


// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(LCD_RS, LCD_EN, LCD_D4, LCD_D5, LCD_D6, LCD_D7);

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('X');   // send a capital X
    delay(300);
  }
}


void setup() {
  // set up the LCD's number of columns and rows:
  lcd.begin(16, 2);
  lcd.setCursor(0, 0);
  lcd.print("Turn sensor     ");
  lcd.setCursor(0, 1);
  lcd.print("to start...     ");

  pinMode(SENSOR, INPUT);

  count = 0;
  sensorStatus = 0;
  sensorStatusOld = 0;
}

void loop() {

  sensorStatus = digitalRead(SENSOR);

  if(millisStart == 0 && sensorStatus != sensorStatusOld){
    millisStart = millis();
  }


  if(sensorStatus != sensorStatusOld){
    if(millis() - millisStart > BOUNCE_TIME){
      if(sensorStatusOld == 1){
        count++;
      }
      sensorStatusOld = sensorStatus;
      millisStart = 0;

      lcd.setCursor(0, 0);
      lcd.print("Count  = ");
      if(abs(count) < 100){
        lcd.print(" ");
      }
      if(abs(count) < 10 && count > 0){
        lcd.print(" ");
      }
      if(abs(count)==0){
        lcd.print(" ");
      }
      lcd.print(count);
      lcd.print(" ");

      lcd.setCursor(0, 1);

      if(sensorStatus == 0){
        lcd.print("Switch =   0    ");
      }
      else{
        lcd.print("Switch =   1    ");
      }
    }
  }

}


