//Source & info: www.HomoFaciens.de

// include the library code:
#include <LiquidCrystal.h>
#include <util/delay.h>

int sensorStatus = 0;
int sensorStatusOld = 0;
int count = 0;
int stepTemp = 0;
int stepTempOld = 0;
int step = 0;
int stepOld = 0;
unsigned long millisStart = 0;
unsigned long millisNow = 0;
unsigned long sensorStatusVolt = 0;
unsigned long sensorStatusVoltOld = 0;

#define LCD_RS   2
#define LCD_EN   3
#define LCD_D4   4
#define LCD_D5   5
#define LCD_D6   6
#define LCD_D7   7

#define SENSOR  A0

#define BOUNCE_TIME     5
#define VOLTAGE_ERROR  61

// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(LCD_RS, LCD_EN, LCD_D4, LCD_D5, LCD_D6, LCD_D7);

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('X');   // send a capital X
    delay(300);
  }
}


void setup() {
  // set up the LCD's number of columns and rows:
  lcd.begin(16, 2);
  lcd.setCursor(0, 0);
  lcd.print("Turn sensor     ");
  lcd.setCursor(0, 1);
  lcd.print("to start...     ");

  pinMode(SENSOR, INPUT);

  count = 0;
  sensorStatus = 0;
  sensorStatusOld = 0;
  step = 0;
  stepOld = 0;
  stepTemp = 0;
  stepTempOld = 0;
}

void loop() {

  sensorStatus = analogRead(SENSOR);


  millisNow = millis();
  if(millisNow < millisStart){
   millisStart = millisNow;
  }

  stepTemp = -1;

  if(sensorStatus < 367 + VOLTAGE_ERROR && sensorStatus > 367 - VOLTAGE_ERROR){
    stepTemp = 1;
    if(millisNow - millisStart > BOUNCE_TIME){
      step = 1;
      millisNow = millis();
    }
  }

  if(sensorStatus < 512 + VOLTAGE_ERROR && sensorStatus > 512 - VOLTAGE_ERROR){
    stepTemp = 2;
    if(millisNow - millisStart > BOUNCE_TIME){
      step = 2;
      millisNow = millis();
    }
  }

  if(sensorStatus < 703 + VOLTAGE_ERROR && sensorStatus > 703 - VOLTAGE_ERROR){
    stepTemp = 3;
    if(millisNow - millisStart > BOUNCE_TIME){
      step = 3;
      millisNow = millis();
    }
  }
  if(stepTemp != stepTempOld){
    millisStart = millis();
    stepTempOld = stepTemp;
  }

  if(sensorStatus > 1023 - VOLTAGE_ERROR){
    stepTemp = 0;
    millisStart = millis();
  }

  if(step != stepOld){
    if(step == 1 && stepOld == 3){
      count++;
    }
    if(step == 2 && stepOld == 1){
      count++;
    }
    if(step == 3 && stepOld == 2){
      count++;
    }

    if(step == 1 && stepOld == 2){
      count--;
    }
    if(step == 2 && stepOld == 3){
      count--;
    }
    if(step == 3 && stepOld == 1){
      count--;
    }
    stepOld = step;
    lcd.setCursor(0, 0);
    lcd.print("R=");
    lcd.print(step);
    lcd.print(", count=");
    lcd.print(count);
    lcd.print("   ");
  }

  sensorStatusVolt = (double)(5.0 * (double)(sensorStatus))/1.023;


  if(abs(sensorStatusVoltOld - sensorStatusVolt) > 100){
    lcd.setCursor(0, 1);

    lcd.print("A0 = ");
    if(sensorStatusVolt < 1000){
      lcd.print(" ");
    }
    if(sensorStatusVolt < 100){
      lcd.print(" ");
    }
    if(sensorStatusVolt < 10 && sensorStatusVolt > 0){
      lcd.print(" ");
    }
    lcd.print(sensorStatusVolt);
    lcd.print("mV ");
    sensorStatusVoltOld = sensorStatusVolt;
  }


}


