#include "esp_camera.h"
#include <WiFi.h>

//
// WARNING!!! Make sure that you have either selected ESP32 Wrover Module,
//            or another board which has PSRAM enabled
//

// Select camera model
//#define CAMERA_MODEL_WROVER_KIT
//#define CAMERA_MODEL_ESP_EYE
//#define CAMERA_MODEL_M5STACK_PSRAM
//#define CAMERA_MODEL_M5STACK_WIDE
#define CAMERA_MODEL_AI_THINKER
//#define CAMERA_MODEL_TTGO_TCAMERA_PLUS
//#define CAMERA_MODEL_TY_OV2
//#define CAMERA_MODEL_TTGO_T
//#define CAMERA_MODEL_M5_A
//#define CAMERA_MODEL_M5_B


// Make sure definitions meet those in app_httpd.cpp !!!!
// channel 1 and 2 interfere with camera usage!
// channel 4 did not work with headlight or camera (don't know why, yet)
//---------------------------------------------------------
#define HEADLIGHT   4
#define CAMERA     15
#define MOTOR_L    13
#define MOTOR_R    12

int motorRunL;
int motorRunR;

#define HEADLIGHT_CHANNEL  5
#define CAMERA_CHANNEL     3

//---------------------------------------------------------


// Set your Static IP address
IPAddress local_IP(192, 168, 2, 184);
// Set your Gateway IP address
IPAddress gateway(192, 168, 2, 1);
IPAddress subnet(255, 255, 255, 0);
IPAddress primaryDNS(8, 8, 8, 8); //optional
IPAddress secondaryDNS(8, 8, 4, 4); //optional


#include "camera_pins.h"

const char* ssid = "Type-Your-SSID-Here";
const char* password = "Type-Your-Password-Here";

void startCameraServer();

void setup() {
  Serial.begin(115200);
  Serial.setDebugOutput(true);
  Serial.println();

  camera_config_t config;
  config.ledc_channel = LEDC_CHANNEL_0;
  config.ledc_timer = LEDC_TIMER_0;
  config.pin_d0 = Y2_GPIO_NUM;
  config.pin_d1 = Y3_GPIO_NUM;
  config.pin_d2 = Y4_GPIO_NUM;
  config.pin_d3 = Y5_GPIO_NUM;
  config.pin_d4 = Y6_GPIO_NUM;
  config.pin_d5 = Y7_GPIO_NUM;
  config.pin_d6 = Y8_GPIO_NUM;
  config.pin_d7 = Y9_GPIO_NUM;
  config.pin_xclk = XCLK_GPIO_NUM;
  config.pin_pclk = PCLK_GPIO_NUM;
  config.pin_vsync = VSYNC_GPIO_NUM;
  config.pin_href = HREF_GPIO_NUM;
  config.pin_sscb_sda = SIOD_GPIO_NUM;
  config.pin_sscb_scl = SIOC_GPIO_NUM;
  config.pin_pwdn = PWDN_GPIO_NUM;
  config.pin_reset = RESET_GPIO_NUM;
  config.xclk_freq_hz = 20000000;
  config.pixel_format = PIXFORMAT_JPEG;
  //init with high specs to pre-allocate larger buffers
  if(psramFound()){
    config.frame_size = FRAMESIZE_UXGA;
    config.jpeg_quality = 10;
    config.fb_count = 2;
  } else {
    config.frame_size = FRAMESIZE_SVGA;
    config.jpeg_quality = 12;
    config.fb_count = 1;
  }

#if defined(CAMERA_MODEL_ESP_EYE)
  pinMode(13, INPUT_PULLUP);
  pinMode(14, INPUT_PULLUP);
#endif

  // camera init
  esp_err_t err = esp_camera_init(&config);
  if (err != ESP_OK) {
    Serial.printf("Camera init failed with error 0x%x", err);
    return;
  }

  sensor_t * s = esp_camera_sensor_get();
  //initial sensors are flipped vertically and colors are a bit saturated
  if (s->id.PID == OV3660_PID) {
    s->set_vflip(s, 1);//flip it back
    s->set_brightness(s, 1);//up the blightness just a bit
    s->set_saturation(s, -2);//lower the saturation
  }
  //drop down frame size for higher initial frame rate
  s->set_framesize(s, FRAMESIZE_QVGA);

#if defined(CAMERA_MODEL_M5STACK_WIDE)
  s->set_vflip(s, 1);
  s->set_hmirror(s, 1);
#endif

// Set hmirror and vflip to "1", because I have mounted the camera board
// with the flashlight LED on top
#if defined(CAMERA_MODEL_AI_THINKER)
  s->set_vflip(s, 1);
  s->set_hmirror(s, 1);
#endif

  if(!WiFi.config(local_IP, gateway, subnet, primaryDNS, secondaryDNS)) {
    Serial.println("STA Failed to configure");
  }
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connected");

  startCameraServer();

  Serial.print("Camera Ready! Use 'http://");
  Serial.print(WiFi.localIP());
  Serial.println("' to connect");

  pinMode(33, OUTPUT);

  digitalWrite(33, LOW);
  delay(1000);
  digitalWrite(33, HIGH);

  motorRunL = 0;
  motorRunR = 0;

  pinMode(MOTOR_L, OUTPUT);
  pinMode(MOTOR_R, OUTPUT);

  ledcAttachPin(CAMERA, CAMERA_CHANNEL);
  ledcAttachPin(HEADLIGHT, HEADLIGHT_CHANNEL);
  //ledcAttachPin(MOTOR_L, MOTOR_L_CHANNEL);
  //ledcAttachPin(MOTOR_R, MOTOR_R_CHANNEL);

  // Initialize channels 
  // channels 0-15, resolution 1-16 bits, freq limits depend on resolution
  // ledcSetup(uint8_t channel, uint32_t freq, uint8_t resolution_bits);
  //ledcSetup(MOTOR_L_CHANNEL, 50, 16);   // 50Hz, 16 bit resolution
  //ledcSetup(MOTOR_R_CHANNEL, 50, 16);   // 50Hz, 16 bit resolution
  ledcSetup(HEADLIGHT_CHANNEL, 12000, 8); // 12 kHz PWM, 8-bit resolution
  ledcSetup(CAMERA_CHANNEL, 50, 16);      // 50Hz, 16 bit resolution

}

void loop() {
  // put your main code here, to run repeatedly:

/*
  ServoL.write(70);
  delay(500);
  ServoL.write(90);
  delay(1000);
  ServoL.write(110);
  delay(500);
  ServoL.write(90);
  delay(1000);
*/

  // Function ledcWrite(MOTOR_L_CHANNEL, 6000); is updated asynchronously and takes lots of CPU cycles
  // that causes unpredictable behaviour of drive motors
  // digitalWrite is updated (nearly) instantaneously, so controlling the drive servomotors by bitbanging is the better choice!
  for(long i = 0; i < 1000; i++){
    if(motorRunL > 0){
      digitalWrite(MOTOR_L, 1);
      delay(1);
      digitalWrite(MOTOR_L, 0);        
      motorRunL--;
    }
    if(motorRunL < 0){
      digitalWrite(MOTOR_L, 1);
      delay(2);
      digitalWrite(MOTOR_L, 0);        
      motorRunL++;
    }
    
    if(motorRunR > 0){
      digitalWrite(MOTOR_R, 1);
      delay(2);
      digitalWrite(MOTOR_R, 0);        
      motorRunR--;
    }
    if(motorRunR < 0){
      digitalWrite(MOTOR_R, 1);
      delay(1);
      digitalWrite(MOTOR_R, 0);        
      motorRunR++;
    }

    delay(20);
  }

}
