// ESP32-CAM based robot
// Details on:
// https://homofaciens.de/technics-robots-R18-construction_en.htm

$fn = 100;

hole_M3 = 3.5;
M3_hole = 3.4;
M3_nut_e = 6.4;
M4_hole = 4.4;
M4_nut_e = 7.66+0.5;
M5_nut_e = 8.79+0.5;
M6_nut_e = 11.05+0.5;
M10_nut_e = 18.9 + 0.8;
t = true;

R18_w = 70;
R18_l = 100;
motor_l = 26.5;
motor_w = 10.2;
motor_h = 13.5;
motor_shaft = 3;

ESP32_w = 40;
ESP32_l = 27;



translate([0, 0, 0]){
  chassis();
}

translate([0, 55, 0]){
//  ESP32_mount();
}

translate([20, -55, 0]){
  rotate([0, 0, 90]){
//    servo_mount();
  }
}
translate([-56, 0, 0]){
  rotate([0, 0, 90]){
//    buck_converter_mount();
  }
}

translate([-36, -60, 0]){
  rotate([0, 0, 0]){
//    battery_mount();
  }
}

translate([60, -70, 0]){
  rotate([0, 0, 0]){
//    power_pole();
  }
}

translate([0, -52, 0]){
  rotate([0, 0, 0]){
//    motor_cover();
  }
}

translate([40, 50, 0]){
  rotate([90*0, 180*0, 0]){
//    wheel();
  }
}

// Pinon
translate([33.5, 0, 0]){
//  gear(teeth = 12, h = 5, shaft = 3);
}

translate([60, -70, 0]){
  rotate([0, 0, 0]){
//    tyre();
  }
}

translate([60, -70, 0]){
  rotate([0, 0, 0]){
//    bottom_terminal();
  }
}

translate([60, -70, 0]){
  rotate([0, 0, 0]){
//    top_terminal();
  }
}

translate([2.5, 0, 0]){
  rotate([0, 0, 0]){
//    bumper();
  }
}


module bumper(){
  b_l = 135;
  b_w = 110;
  b_h = 10;
  b_r = 5;
  b_r2 = 90;
  b_wall = 2;
  
  mount_w = 50;
  mount_h = 30;
  
  side_m_x = -17.5;
  side_m_x2 = 37.5;
  
  hole_l = 20;
  
  
  // Front spacers
  s_l = 18;
  for(i=[0:1:1])mirror([0,i,0])
  translate([56.5, 20, s_l/2]){
    rotate([0, 90*0, 0]){
      difference(){
        cylinder(d=15, h=s_l, center=true);
        cylinder(d=M3_hole, h=s_l*1.1, center=true);
      }
    }
  }
  
  // Side bumper mounts
  for(i=[0:1:1])mirror([0,i,0])
  translate([side_m_x, 19*0 + 20, 0]){
    difference(){
      roundedRect([9,28,10], 3, [1,1,0,0]);
      translate([0, 0, 5]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=31, center=true);
          translate([0, 0, 4.5]){
            rotate([0, 0, 30]){
              cylinder(d=M3_nut_e, h=31, center=true, $fn=6);
            }
          }
        }
      }
      translate([0, -9, 5]){
        cylinder(d=M3_hole, h=11, center=true);
        translate([0, 0, 2]){
          rotate([0, 0, 30]){
            cylinder(d=M3_nut_e, h=11, center=true, $fn=6);
          }
        }
      }
    }
  }
  
  // Bumper
  difference(){
    union(){
      hull(){
        translate([(b_l-b_r)/2, (b_w-b_r)/2, b_h/2]){
          cylinder(d=b_r, h=b_h, center=true);
        }
        translate([(b_l-b_r)/2, -(b_w-b_r)/2, b_h/2]){
          cylinder(d=b_r, h=b_h, center=true);
        }
        translate([-(b_l-b_r2)/2, (b_w-b_r2)/2, b_h/2]){
          cylinder(d=b_r2, h=b_h, center=true);
        }
        translate([-(b_l-b_r2)/2, -(b_w-b_r2)/2, b_h/2]){
          cylinder(d=b_r2, h=b_h, center=true);
        }
      }
      // Front mount
      translate([b_l/2-b_wall, 0, mount_h/2]){
        rotate([0, 90, 0]){
          roundedRect([mount_h, mount_w, b_wall], 5);
        }
      }
      // Side mounts
      for(i=[0:1:1])mirror([0,i,0]){
        translate([side_m_x, b_w/2-b_wall*0, mount_h/2]){
          rotate([90, 0, 0]){
            roundedRect([20, mount_h, b_wall], 5);
          }
        }
        translate([side_m_x2, b_w/2-b_wall*0, mount_h/2]){
          rotate([90, 0, 0]){
            roundedRect([20, mount_h, b_wall], 5);
          }
        }
      }
      
    }
    // Long holes front cut
    for(i=[0:1:1])mirror([0,i,0])
    hull(){
      translate([b_l/2, 20, (mount_h+hole_l)/2]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=b_wall*4, center=true);
        }
      }
      translate([b_l/2, 20, (mount_h-hole_l)/2]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=b_wall*4, center=true);
        }
      }
    }
    // Long holes side2 cut
    hull(){
      translate([side_m_x, 0, (mount_h+hole_l)/2]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=b_w*1.1, center=true);
        }
      }
      translate([side_m_x, 0, (mount_h-hole_l)/2]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=b_w*1.1, center=true);
        }
      }
    }
    hull(){
      translate([side_m_x2, 0, (mount_h+hole_l)/2]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=b_w*1.1, center=true);
        }
      }
      translate([side_m_x2, 0, (mount_h-hole_l)/2]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=b_w*1.1, center=true);
        }
      }
    }
    // Center cut
    scale([0.97, 0.97, 1.1])translate([0, 0, -0.1])hull(){
      translate([(b_l-b_r)/2, (b_w-b_r)/2, b_h/2]){
        cylinder(d=b_r, h=b_h, center=true);
      }
      translate([(b_l-b_r)/2, -(b_w-b_r)/2, b_h/2]){
        cylinder(d=b_r, h=b_h, center=true);
      }
      translate([-(b_l-b_r2)/2, (b_w-b_r2)/2, b_h/2]){
        cylinder(d=b_r2, h=b_h, center=true);
      }
      translate([-(b_l-b_r2)/2, -(b_w-b_r2)/2, b_h/2]){
        cylinder(d=b_r2, h=b_h, center=true);
      }
    }
  }
  
}

module top_terminal(){
  tt_w = 45;
  tt_l = 60;
  tt_h = 6;
  
  d_d = 22;
  d_h = 6;
  d_hole = 7;
  
  translate([-42, 0, d_h/2]){
    difference(){
      cylinder(d=d_d, h=d_h, center=true);
      cylinder(d=4.5, h=d_h*1.1, center=true);
      hull(){
        translate([0, 0, 1.5-d_h/2-0.2]){
          cylinder(d=d_hole, h=3, center=true);
        }
        translate([0, 0, 2.5-d_h/2-0.2]){
          cylinder(d=4.5, h=5, center=true);
        }
      }
    }
  }

  difference(){
    hull(){
      translate([tt_l/2, 0, tt_h/2]){
        cylinder(d=10, h=tt_h, center=true);
      }
      translate([-tt_l*1/6, 0, 0]){
        roundedRect([tt_l*2/3, tt_w, tt_h],5);
      }
    }
    hull(){
      translate([1,13,tt_h/2]){
        cylinder(d=10, h=tt_h*1.1, center=true);
      }
      translate([1,-13,tt_h/2]){
        cylinder(d=10, h=tt_h*1.1, center=true);
      }
      translate([22,0,tt_h/2]){
        cylinder(d=5, h=tt_h*1.1, center=true);
      }
    }
    translate([0, 0, tt_h/2]){
      rotate([90,0,0]){
        cylinder(d=M3_hole, h=tt_w*1.1, center=true);
      }
    }
    translate([tt_l/2-2, 0, tt_h/2]){
      rotate([0,20,0]){
        cylinder(d=M3_hole, h=tt_w*1.1, center=true);
      }
    }
    // Counter weight M10 nuts
    for(i=[0:1:1])mirror([0,i,0])
    translate([12-tt_l/2, 10, tt_h/2+1]){
      rotate([0,0,0]){
        cylinder(d=M10_nut_e, h=tt_h, center=true, $fn=6);
        cylinder(d=M3_hole, h=tt_h*2, center=true);
      }
    }
  }
}

module bottom_terminal(){
  bt_h = 5;
  bt_w = R18_w-10;
  bt_l = 20;
  bt_wall = 10;
  bt_flap_1 = 28;
  bt_flap_2 = 28;
  
  x1=0;
  y1=0;
  x2=bt_flap_1;
  y2=0;
  x3=bt_flap_2;
  y3=bt_h - bt_wall;
  x4=bt_l;
  y4=y3;
  
  d_d = 22;
  d_h = 6;
  d_hole = 7;


  // Bottom disc
  translate([0, -3, d_h/2]){
    difference(){
      cylinder(d=d_d, h=d_h, center=true);
      cylinder(d=4.5, h=d_h*1.1, center=true);
      hull(){
        translate([0, 0, 1.5-d_h/2-0.2]){
          cylinder(d=d_hole, h=3, center=true);
        }
        translate([0, 0, 2.5-d_h/2-0.2]){
          cylinder(d=4.5, h=5, center=true);
        }
      }
    }
  }

  // Mount
  translate([0, 0, bt_h/2]){
    difference(){
      for(i=[0:1:1])mirror([i,0,0])
      union(){
          translate([bt_w/2,0,bt_h/2]){
            cylinder(d=bt_wall, h=bt_h*2, center=true);
          }
        hull(){
          translate([bt_w/2,0,0]){
            cylinder(d=bt_wall, h=bt_h, center=true);
          }
          translate([0,bt_l,0]){
            cylinder(d=10, h=bt_h, center=true);
          }
        }
      }
      // Chassis mount screws
      for(i=[0:1:1])mirror([i,0,0])
      translate([bt_w/2,0,0]){
        hull(){
          cylinder(d=M3_hole, h=bt_h*3.1, center=true);
          translate([0, 0, -3]){
            cylinder(d=M3_nut_e, h=bt_h*2, center=true, $fn=6);
          }
        }
      }
      // Bottom terminal mount screw      
      translate([0,bt_l,0]){
        cylinder(d=M3_hole, h=bt_h*1.1, center=true);
        translate([0, 0, bt_h/2-1.5]){
          cylinder(d=M3_nut_e, h=bt_h, center=true, $fn=6);
        }
      }
      
    }
  }


}

module wheel(){
  w_d = 50;
  w_w = 6;
  shaft_d = 3;
  
  translate([33.5, 0, 0]){
    gear(teeth = 12, h = 5, shaft = 3);
  }
  translate([0, 0, w_w]){
    gear(teeth = 60, h = 5, shaft = M3_hole, edge=0);
  }

  
  translate([0, 0, w_w/2]){
    difference(){
      union(){
        rotate_extrude(){
          translate([(w_d-w_w)/2, 0, 0]){
            circle(d=w_w);
          }
        }
        cylinder(d=w_d-w_w, h=w_w, center=true);
      }
      intersection(){
        cylinder(d=M3_hole, h=w_w*1.1, center=true);
        translate([0.3,0,0]){
//          cube(size=[shaft_d, shaft_d+1, w_w+1], center=true);
        }
      }
    }
  }

}

module tyre(){
  w_d = 55;
  w_w = 7;
  shaft_d = 3;
  difference(){
    translate([0, 0, w_w/2]){
      difference(){
        union(){
          rotate_extrude(){
            translate([(w_d-w_w)/2, 0, 0]){
              circle(d=w_w);
            }
          }
          cylinder(d=w_d-w_w, h=w_w, center=true);
        }
        intersection(){
          cylinder(d=shaft_d, h=w_w*1.1, center=true);
          translate([0.3,0,0]){
            cube(size=[shaft_d, shaft_d+1, w_w+1], center=true);
          }
        }
      }
    }
    translate([0, 0, 1.1]){
      wheel();
    }
    translate([0, 0, w_w*1.5-0.4]){
      cylinder(d=w_d*1.1, h=w_w, center=true);
    }
    translate([0, 0, w_w/2]){
      cylinder(d=w_d*0.75, h=w_w*1.1, center=true);
    }
  }
  
}

module motor_cover(){
  mc_w = 30;
  mc_wall = 1.5;
  mc_wall_2 = 3.2;
  
  difference(){
    union(){
      roundedRect([R18_w, mc_w, mc_wall], 5);
      for(i=[0:1:1])mirror([i,0,0])
      translate([R18_w/2-2-motor_l/2, 0, (mc_wall_2)/2]){
        cube(size=[motor_l-0.5, motor_w-0.5, mc_wall_2], center=true);
      }
    }
    for(i=[0:1:1])mirror([i,0,0]){
      translate([20, 10, mc_wall/2]){
        cylinder(d=M3_hole, h=mc_wall*1.1, center=true);
      }
      translate([20, -10, mc_wall/2]){
        cylinder(d=M3_hole, h=mc_wall*1.1, center=true);
      }
    }
  }
}

module power_pole(){
  pp_h = 150;
  pp_w_1 = 35;
  pp_w_2 = 10;
  pp_wall = 2;
  pp_flap = 10;
  
  // Camera hinge
  ch_x = 0;
  ch_z = 10;
  
  mount_shift = 0;
  
  difference(){
    hull(){
      translate([0, 0, pp_flap/2]){
        cube(size=[pp_w_1, pp_wall, pp_flap], center=true);
      }
      translate([0, pp_h, pp_wall/2]){
        cylinder(d=pp_w_2, h=pp_wall, center=true);
      }
    }
    // Inner cut
    hull(){
      translate([0, pp_wall, pp_flap/2+pp_wall]){
        cube(size=[pp_w_1-2*pp_wall, pp_wall, pp_flap], center=true);
      }
      translate([0, pp_h, pp_wall*1.5]){
        cylinder(d=pp_w_2-2*pp_wall, h=pp_wall, center=true);
      }
    }
    // ESP32 camera hinge
    for(i=[1:1:14])
    translate([ch_x, i*ch_z, pp_wall/2]){
      cylinder(d=M3_hole, h=pp_wall*1.1, center=true);
    }    
    
    // Top screw  hole
    translate([0, pp_h, pp_wall/2]){
      cylinder(d=M3_hole, h=pp_wall*1.1, center=true);
    }    
    // Chassis mount screws
    for(i=[0:1:1])mirror([i,0,0])
    translate([10,0,pp_flap/2+mount_shift]){
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=pp_wall*2.1, center=true);
      }
    }
  }
  
}

module battery_mount(){
  bm_l = 60;
  bm_w = 20;
  bm_h = 14;
  bm_wall = 2;

  // Battery dimensions
  b_l = 51;
  b_d = 15.5;
  
  for(i=[0:1:1])mirror([0,i,0])
    translate([0,15,0]){
      difference(){
        union(){
          roundedRect([bm_l, bm_w, bm_h], 3);
          for(i=[0:1:1])mirror([i,0,0])
          translate([20, -10, 2.5]){
            cube(size=[10, bm_w+5, 5], center=true);
          }
        }
        // Battery cut
        translate([0, 0, bm_h/2+1]){
          rotate([0, 90, 0]){
            cylinder(d=b_d, h = b_l, center=true);
            cylinder(d=M3_hole, h = bm_l*1.1, center=true);
            cylinder(d=M3_nut_e, h = b_l+6, center=true, $fn=6);
          }
        }
        // Mount screw cuts
        for(i=[0:1:1])mirror([i,0,0]){
          translate([20, -(bm_w/2+5), 2.5]){
            cylinder(d=M3_hole, h = 10, center=true);
            translate([0, 0, 1]){
              cylinder(d=M3_nut_e, h = 5, center=true, $fn=6);
            }
          }
          translate([20, bm_w/2+5, 2.5]){
            cylinder(d=M3_hole, h = 10, center=true);
            translate([0, 0, 1]){
              cylinder(d=M3_nut_e, h = 5, center=true, $fn=6);
            }
          }
        }
        // Gap cut
        translate([0, 0, bm_h/2]){
          cube(size=[1, bm_w*2.1, bm_h*1.1], center=true);
        }
      }
    
    
  }
}

module buck_converter_mount(){
  bcm_l = 45;
  bcm_w = 35;
  bcm_wall = 2;
  bcm_mount_dis = 60;
  bcm_mount_w = 10;
  
  bcm_s_dis_1 = 35;
  bcm_s_dis_2 = 25;

  mount_shift = 27.5;
  mount_2_x = mount_shift-50;
  
  spacer_d = 10;
  spacer_h = 5;

  // Spacers
  for(i=[0:1:1])mirror([0,i,0]){
    translate([7, 25, spacer_h/2]){
      difference(){
        cylinder(d=spacer_d, h = spacer_h, center=true);
        cylinder(d=M3_hole, h = spacer_h*1.1, center=true);
      }
    }
    translate([-7, 25, spacer_h/2]){
      difference(){
        cylinder(d=spacer_d, h = spacer_h, center=true);
        cylinder(d=M3_hole, h = spacer_h*1.1, center=true);
      }
    }
  }
  
    difference(){
      union(){
        roundedRect([bcm_l,bcm_w,bcm_wall],5);
        hull(){
          translate([mount_shift-10, bcm_mount_dis/2, bcm_wall/2]){
            cylinder(d=bcm_mount_w, h = bcm_wall, center=true);
          }
          translate([mount_shift-10, -bcm_mount_dis/2, bcm_wall/2]){
            cylinder(d=bcm_mount_w, h = bcm_wall, center=true);
          }
        }
        for(i=[0:1:1])mirror([0,i,0])
        hull(){
          translate([mount_shift, bcm_mount_dis/2, bcm_wall/2]){
            cylinder(d=bcm_mount_w, h = bcm_wall, center=true);
          }
          translate([mount_shift-10, bcm_mount_dis/2, bcm_wall/2]){
            cylinder(d=bcm_mount_w, h = bcm_wall, center=true);
          }
        }
        hull(){
          translate([mount_2_x, 0, bcm_wall/2]){
            cylinder(d=bcm_mount_w, h = bcm_wall, center=true);
          }
          translate([0, 0, bcm_wall/2]){
            cube(size=[0.1, bcm_mount_w, bcm_wall], center=true);
          }
        }
      }
      // screw cuts
      translate([bcm_s_dis_1/2,bcm_s_dis_2/2,bcm_wall/2]){
        cylinder(d=M3_hole, h=bcm_wall*1.1, center=true);
      }
      translate([-bcm_s_dis_1/2,bcm_s_dis_2/2,bcm_wall/2]){
        cylinder(d=M3_hole, h=bcm_wall*1.1, center=true);
      }
      translate([-bcm_s_dis_1/2,-bcm_s_dis_2/2,bcm_wall/2]){
        cylinder(d=M3_hole, h=bcm_wall*1.1, center=true);
      }
      translate([bcm_s_dis_1/2,-bcm_s_dis_2/2,bcm_wall/2]){
        cylinder(d=M3_hole, h=bcm_wall*1.1, center=true);
      }
      // Chassis mount screw cuts
      translate([mount_shift, bcm_mount_dis/2, bcm_wall/2]){
        cylinder(d=M3_hole, h = bcm_wall*1.1, center=true);
      }
      translate([mount_shift, -bcm_mount_dis/2, bcm_wall/2]){
        cylinder(d=M3_hole, h = bcm_wall*1.1, center=true);
      }
      translate([mount_2_x, 0, bcm_wall/2]){
        cylinder(d=M3_hole, h = bcm_wall*1.1, center=true);
      }
    }
  
}

module servo_mount(){
  sm_h = 40;
  sm_w = 20;
  sm_w2 = 50;
  sm_l = 25;
  sm_wall = 2;
  sm_wall_2 = 5;
  sm_wall_3 = 60;
  screw_dis = 28;
  screw_shift_z = -2;
  //clamp dimensions
  c_cut_l = 23;
  c_cut_w = 12;
  c_l = 37;
  c_w = 17;
  c_h = 10;

  
  // Servo clamp
  translate([-18, 0, 0]){
    difference(){
      roundedRect([c_w,c_l,c_h],3,[1,0,1,0]);
      // Servo cut
      translate([(c_w-c_cut_w)/2+0.1, 0, c_h/2]){
        cube(size=[c_cut_w, c_cut_l, c_h * 1.1], center=true);
      }
      // Screw cuts
      for(i=[0:1:1])mirror([0,i,0])
      translate([0, screw_dis/2, c_h/2]){
        rotate([0,90,0]){
          cylinder(d=M3_hole, h=c_w*1.1, center=true);
        }
      }
    }
  }

  difference(){
    union(){
      roundedRect([sm_h,sm_w,sm_wall_2],5,[1,0,1,0]);
      translate([sm_h/2, 0, sm_l/2]){
        rotate([0, 90, 0]){
          roundedRect([sm_l,sm_w2,sm_wall_3],3);
        }
      }
      // Enforcement
      for(i=[0:1:1])mirror([0,i,0])      
      hull(){
        translate([0, (sm_wall-sm_w)/2, sm_wall/2]){
          cube(size=[sm_h-8, sm_wall, sm_wall], center=true);
        }
        translate([(sm_h+sm_wall)/2, (sm_wall-sm_w)/2, sm_l/2]){
          cube(size=[sm_wall, sm_wall, sm_l-5], center=true);
        }
      }
    }
    // Mount plate screw cuts
    for(i=[0:1:1])mirror([0,i,0]){
      translate([sm_h/2, 20, sm_l/2-5]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=sm_wall_3*2.1, center=true);
        }
      }
      translate([sm_h/2, 20, sm_l/2+5]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=sm_wall_3*2.1, center=true);
        }
      }
    }
    // Servo screw cuts
    translate([screw_shift_z - screw_dis/2, 0, sm_wall_2/2]){
      cylinder(d=M3_hole, h=sm_wall_2*1.1, center=true);
      translate([0, 0, 1]){
        cylinder(d=M3_nut_e, h=sm_wall_2, center=true, $fn=6);
      }
    }
    translate([screw_shift_z + screw_dis/2, 0, sm_wall_2/2]){
      cylinder(d=M3_hole, h=sm_wall_2*1.1, center=true);
      translate([0, 0, 1]){
        cylinder(d=M3_nut_e, h=sm_wall_2, center=true, $fn=6);
      }
    }
    // Battery cut
    translate([(sm_h+sm_wall_3)/2+sm_wall, 0, sm_l/2]){
      cube(size=[sm_wall_3,22.5,sm_l*1.1], center=true);
    }
    for(i=[0:1:1])mirror([0,i,0])
    translate([(sm_h+sm_wall_3)/2-sm_wall, 26, sm_l/2]){
      cube(size=[sm_wall_3,25.5,sm_l*1.1], center=true);
    }
    
  }
}

module ESP32_mount(){
  m_l = 38;
  m_w = 49;
  m_w_2 = 50;
  m_h = 3;
  hinge_x = 5 - m_l/2;
  hinge_z = 4;
  lever_x = m_l/2-10;
  lever_z = 10;
  lever_wall = 2;
  
  difference(){
    union(){
      roundedRect([m_l, m_w, m_h], 3);
      translate([5-m_l/2, 0, 0]){
        roundedRect([10, m_w_2, 7], 3);
      }
      hull(){
        translate([lever_x, (ESP32_w+lever_wall-2)/2, lever_z]){
          rotate([90, 0, 0]){
            cylinder(d=10, h=lever_wall, center=true);
          }
        }
        translate([lever_x, (ESP32_w+lever_wall)/2, 0.05]){
          cube(size=[15,lever_wall,0.1], center=true);
        }
      }
    }
    
    // Cut servo lever
    translate([lever_x, (m_w-lever_wall)/2, lever_z]){
      rotate([90, 0, 0]){
        cylinder(d=1.5, h=30.1, center=true);
      }
    }
    
    // Cut hinge
    translate([hinge_x, 0, hinge_z]){
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=m_w_2*1.1, center=true);
      }
    }
    
    // Cut ESP32 board
    translate([10, 0, m_h/2]){
      hull(){
        cube(size=[m_l+2, ESP32_w, 1], center=true);
        cube(size=[m_l, ESP32_w-2, 3.5], center=true);
      }
    }

    // Cut SD-card notch
    translate([-1, -10, -1]){
      intersection(){
        cylinder(d=25, h=5, center=true);
        translate([5,1,0]){
          cube(size=[20,22,5], center=true);
        }
      }

    }
  }
  

}

module chassis(){
  motor_x = 15;
  wheel_x = motor_x + 25;
  screw_x = 18.0;
  screw_y = 20;
  grid_no_x = 9;
  grid_x = 10;
  grid_no_y = 6;
  grid_y = 10;
  c_wall = 4;
  c_h = motor_h + c_wall;
  
  difference(){
    roundedRect([R18_l, R18_w, c_h], 5);
    // Motor cable cut
    translate([-33, 0, c_wall+c_h/2]){
      cube(size=[R18_l, 20, c_h], center=true);
    }
    // Screw grid
    for(j=[0:1:grid_no_y]){
      y_pos = 5 + j*grid_y - R18_w/2;
      translate([R18_l/2, y_pos, c_h/2+1]){
        rotate([0, 90, 0]){
          if(j != 0 && j != 6){
            cylinder(d=M3_hole, h=c_h*1.1, center=true);
            translate([0, 0, -4.5]){
              cylinder(d=M3_nut_e, h=7, center=true, $fn=6);
            }
          }
        }
      }
      for(i=[0:1:grid_no_x]){
        x_pos = grid_x/2 + i*grid_x - R18_l/2;
        if(!((i==5 || i == 7) && ((j == 5) || (j == 1)))){
          translate([x_pos, y_pos, c_h/2]){
            cylinder(d=M3_hole, h=c_h*1.1, center=true);
            translate([0, 0, 1]){
              cylinder(d=M3_nut_e, h=c_h, center=true, $fn=6);
            }
          }
        }
        else{// Motor screws
          translate([x_pos, y_pos, c_h/2-2.9])
          hull(){
            cylinder(d=M3_nut_e, h=c_h-5, center=true, $fn=6);
            cylinder(d=M3_hole, h=c_h+6, center=true);
          }
        }
      }
    }
    // Motor cut
    for(i=[0:1:1])mirror([0,i,0]){
      translate([motor_x, 20, c_wall+c_h/2]){
        cube(size=[motor_w, motor_l, c_h], center=true);
        translate([0, 0, 3]){
          cube(size=[motor_shaft*1.1, R18_w*1.1, c_h], center=true);
        }
      }
    }
    // Front axle cut
    translate([wheel_x, 0, c_wall+c_h/2]){
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=R18_w*1.1, center=true);
      }
    }
    
    // Rear cut
    translate([0-R18_l/2, 0, c_wall+c_h/2]){
      cube(size=[R18_l, R18_w*1.1, c_h], center=true);
    }
    translate([R18_l/2-10.8, 0, c_wall]){
      roundedRect([18, R18_w-4.4, c_h], 2);
    }
    
  }
}

module roundedRect(size, radius, edges=[1, 1, 1, 1]){
  x = size[0];
  y = size[1];
  z = size[2];

  linear_extrude(height=z){
    hull(){
        // place 4 circles in the corners, with the given radius
        if(edges[0]){
          translate([(-x/2)+(radius), (-y/2)+(radius), 0])
          circle(r=radius);
        }
        else{
          translate([(-x/2)+(radius/2), (-y/2)+(radius/2), 0])
          square(size=[radius, radius], center=true);
        }
        if(edges[1]){
          translate([(x/2)-(radius), (-y/2)+(radius), 0])
          circle(r=radius);
        }
        else{
          translate([(x/2)-(radius/2), (-y/2)+(radius/2), 0])
          square(size=[radius, radius], center=true);
        }

        if(edges[2]){
          translate([(-x/2)+(radius), (y/2)-(radius), 0])
          circle(r=radius);
        }
        else{
          translate([(-x/2)+(radius/2), (y/2)-(radius/2), 0])
          square(size=[radius, radius], center=true);
        }

        if(edges[3]){
          translate([(x/2)-(radius), (y/2)-(radius), 0])
          circle(r=radius);
        }
        else{
          translate([(x/2)-(radius/2), (y/2)-(radius/2), 0])
          square(size=[radius, radius], center=true);
        }
    }
  }
}

module gear(teeth = 10, h = 5, shaft = M3_hole, edge = 1){
  mod = 2; 
  alpha = 180/teeth;
  r1 = mod*teeth/(2*3.14159);
  r=(mod/2)/tan(alpha);
  
  difference(){
    union(){
      x1=r;
      y1=mod/2;
      x2=r+mod;
      y2=0;
      x3=r;
      y3=-mod/2;
      x4=0;
      y4=0;
      translate([0, 0, edge]){
        linear_extrude(height=h-edge){
          for(i=[0:1:teeth]){
            rotate([0, 0, i*360/teeth]){
              polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4]]);
            }
          }
        }
      }
      translate([0, 0, edge]){
        mirror([0, 0, 1]){
          linear_extrude(height=edge, scale=[0.985, 0.985]){
            for(i=[0:1:teeth]){
              rotate([0, 0, i*360/teeth]){
                polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4]]);
              }
            }
          }
        }
      }
    }
    translate([0, 0, h/2]){
      cylinder(d=shaft, h=h*1.1, center=true);
    }
    if(shaft==-1){
      translate([0, 0, h/2]){
        difference(){
          cylinder(d=motor_shaft, h=h*1.1, center=true);
          translate([0, motor_shaft_shift, 0]){
            cube(size=[motor_shaft, motor_shaft, 16], center=true);
          }
        }
      }
    }
  }
  
}

