// Rover R11 v0.1
// Build instruction on:
// https://homofaciens.de/technics-robots-R10-construction_en.htm

$fn=100;
raspberry_mount_l = 58;
raspberry_mount_w = 49;
raspberry_mount_edge_x = 46;
raspberry_mount_edge_y = 15;
raspberry_mount_d = 5;
raspberry_mount_screw_d = 2;
raspberry_mount_d_tolerance = 0.3;
raspberry_mount_h = 6;
raspberry_mount_socket = 1;

body_wall = 1.8;
body_wall_2 = 4;
body_l = 122;
body_w = 109;
body_h = 70;
mount_halfes_h1 = 27;

bumper_mount_x1 = 50;
bumper_mount_y = body_w/2 - 10;

rear_axle_d = 4.5;

battery_cut_l = 50;
battery_cut_w = 65;
battery_cut_x = -35;


rear_cut_l = body_l/2;
rear_cut_h = 23;

center_mount_w = body_w-2*body_wall;
center_mount_l = 15;
center_mount_h = rear_cut_h-body_wall;
center_mount_holes = 65;
center_mount_holes_2 = 25;
center_mount_holes_d = 2;


clamp_cut_l = 10;
clamp_cut_h = 3;
clamp_cut_x = 45;
clamp_cut_z = body_h - 3;

servo_w = 21;
servo_l = 41.3;
servo_h = 40.7;
servo_m_d = 10;
servo_m_h = 28;
servo_m_l = 7;
servo_cable_cut_l = 4;
servo_cable_cut_w = 5;
servo_m_s_1 = 16.6;
servo_m_s_2 = 0;
servo_m_s_3 = -10;

carriage_hinge_d = 10;
carriage_hinge_l = 5;
carriage_hinge_z = servo_w/2 + body_wall;


bat_no = 3;
bat_l = 50.3;
bat_d = 14.5;
bat_anode_d = 7;
bat_cathode_h = 1;
bat_cathode_d = 8;
bat_wall = 1.2;
bat_wall_base = 2;
bat_wall_2 = 3;
bat_cut_w = 2.0;
bat_cut_l = bat_l*0.4;
bat_slit=1.5;
bat_b_plate = 1;
bat_b_edge = 10;
bat_width=bat_no*(bat_d+bat_wall)+3*bat_wall;
bat_length=bat_l+bat_wall+bat_wall_2;
bat_clamp_pos_x = 10;
bat_clamp_pos_z = 2;
bat_clamp_cut_l = 6;
bat_clamp_cut_h = 3;

track_l = 37.5;
track_h = 16;
track_w = 25;
track_wall = 2;
track_tolerance_w = 0.6;

M3_hole = 3.2;

//translate([45, 55, 10]){
//  rotate([90, 0, 0]){
    //mechanum_wheel(0);
//  }
//}


//body_half(0);

body();

//cable_chain();

//translate([-50, 85, 12]){
//  rotate([90, 0, 0]){
    //rear_wheel();
//  }
//}

//translate([0, 10, 35+track_h/2]){
//  rotate([90, 0, 0]){
    //rear_wheel_mount();
//  }
//}

//translate([50, 85 , 12]){
//  rotate([90, 0, 0]){
    //drive_wheel();
//  }
//}

translate([-38, 0, 0]){
  //carriage();
}

translate([50, 37, 35]){
  rotate([90, 0, 0]){
    //servo();
  }
}


translate([0, 0, 72]){
  rotate([0, 180, 0]){
    //top_lid();
  }
}

//translate([-45, 0, 23]){
//  rotate([0, 180, 180]){
    //battery_holder();
//  }
//}

//translate([-29, 0, 23.2]){
//  rotate([0, 0, 180]){
    //pi_mount();
//  }
//}

//translate([-41, 40, 37]){
  rotate([180, 0, 0]){
    //servo_holder();
  }
//}

//translate([-30, 0, 27.2]){
  //camera_mount();
//}


//translate([72, 0, 75]){
//  rotate([0, 90, 180]){
    //light_mount();
//  }
//}

//translate([15, 0, 73]){
//  rotate([0, 270, 0]){
    //power_pole();
//  }
//}

translate([105, 0, 0]){
  rotate([0, 180, 0]){
    //bumper();
  }
}
translate([-105, 0, 0]){
  rotate([180, 0, 0]){
    //bumper();
  }
}

module bumper(){
  bumper_w = 170;
  bumper_l=90;
  bumper_h = 10;
  enforcement_edge = 40;
  linkage=30;
  M3_d = 3.5;
  
  translate([0, 0, bumper_h/2]){
    rotate([90, 0, 0]){
      difference(){
        union(){
          cylinder(d=bumper_h*1.5, h=bumper_w, center=true);
          translate([0, 0, bumper_w/2]){
            sphere(d=bumper_h*1.5, center=true);
          }
          translate([0, 0, -bumper_w/2]){
            sphere(d=bumper_h*1.5, center=true);
          }
        }
        //cutTop/bottom of bumper cylinder
        translate([0, bumper_h, 0]){
          cube(size=[bumper_h*2, bumper_h, bumper_w*1.1], center=true);
        }
        translate([0, -bumper_h, 0]){
          cube(size=[bumper_h*2, bumper_h, bumper_w*1.1], center=true);
        }
      }
    }
  }

  translate([0, bumper_mount_y, bumper_h/2]){
    difference(){
      translate([bumper_l/2, 0, 0]){
        cube(size=[bumper_l, bumper_h, bumper_h], center=true);
      }
      //cut mount holes
      translate([bumper_l-bumper_mount_x1, 0, 0]){
        cylinder(d=M3_d, h=bumper_h*2, center=true);
      }
    }
      
    translate([bumper_l+linkage/2, bumper_h/4, 0]){
      difference(){
        cube(size=[linkage, bumper_h/2, bumper_h], center=true);
        translate([linkage/3, 0, 0]){
          rotate([90, 0, 0]){
            cylinder(d=M3_d, h=bumper_h*2, center=true);
          }
        }
        translate([-linkage/3, 0, 0]){
          rotate([90, 0, 0]){
            cylinder(d=M3_d, h=bumper_h*2, center=true);
          }
        }
      }
    }
  }
  translate([0, -bumper_mount_y, bumper_h/2]){
    difference(){
      translate([bumper_l/2, 0, 0]){
        cube(size=[bumper_l, bumper_h, bumper_h], center=true);
      }
      //cut mount holes
      translate([bumper_l-bumper_mount_x1, 0, 0]){
        cylinder(d=M3_d, h=bumper_h*2, center=true);
      }
    }
      
    translate([bumper_l+linkage/2, bumper_h/4, 0]){
      difference(){
        cube(size=[linkage, bumper_h/2, bumper_h], center=true);
        translate([linkage/3, 0, 0]){
          rotate([90, 0, 0]){
            cylinder(d=M3_d, h=bumper_h*2, center=true);
          }
        }
        translate([-linkage/3, 0, 0]){
          rotate([90, 0, 0]){
            cylinder(d=M3_d, h=bumper_h*2, center=true);
          }
        }
      }
    }
  }


  
  
}
  

module servo_holder(){
  plate_h = 5;
  hole_distance = 57;
  hole_d = 3.5;
  hole_pos_x = 0;
  hole_pos_y = -7;
  servo_pos_x = hole_distance+8;
  m_length = hole_distance + 30;
  m_width = 15;
  clamp_h = 9;
  clamp_w = 20;
  spacer_h = 15-plate_h;
  spacer_d = 11;
  
  translate([0, 0, -plate_h]){
    difference(){
      union(){
        x1=0;
        y1=0;
        x2=servo_pos_x+servo_l;
        y2=0;
        x3=servo_pos_x+servo_l;
        y3=-clamp_w;
        x4=servo_pos_x+servo_l-(servo_l-clamp_w);
        y4=-servo_h+5;
        x5=servo_pos_x;
        y5=-servo_h+5;
        x6=servo_pos_x;
        y6=-m_width;
        x7=0;
        y7=-m_width;
        
        linear_extrude(height=plate_h){
          polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4],[x5,y5],[x6,y6],[x7,y7]]);
        }
        
        translate([servo_pos_x+clamp_w/2, 
                  (-body_wall)/2-servo_h+5,
                  plate_h-clamp_h/2]){
          cube(size=[clamp_w, body_wall, clamp_h], center=true);
        }
        translate([servo_pos_x+servo_l+body_wall/2, 
                  -clamp_w/2,
                  plate_h-clamp_h/2]){
          cube(size=[body_wall, clamp_w, clamp_h], center=true);
        }
        translate([0, -m_width/2, plate_h/2]){
          cylinder(d=m_width, h=plate_h, center=true);
        }
        //Spacers
        translate([hole_pos_x, hole_pos_y, -(spacer_h/2)]){
          cylinder(d=spacer_d, h=spacer_h, center=true);
        }
        translate([hole_pos_x+hole_distance, hole_pos_y, -(spacer_h/2)]){
          cylinder(d=spacer_d, h=spacer_h, center=true);
        }
        
      }
      translate([hole_pos_x, hole_pos_y, 0]){
        cylinder(d=hole_d, h=plate_h*5, center=true);
      }
      translate([hole_pos_x+hole_distance, hole_pos_y, 0]){
        cylinder(d=hole_d, h=plate_h*5, center=true);
      }
    }
  }
  
  
}

module drive_wheel(){
  horn_d = 41;
  horn_w1 = 12;
  horn_w2 = 6;
  horn_thickness = 3;
  horn_mount = 13.7;
  
  chain_l = track_l-track_h;
  echo(chain_l);
  echo(sin(90));
  chain_no = 10;
  radius = (chain_l/2)/sin(180/chain_no)+track_h/2;
  echo(radius);
  wheel_w = track_w-2*track_wall-track_tolerance_w-1;
  hub_d = 20;
  hub_h = wheel_w+5;
  hub_hole = 3.5;
  hub_hole_2 = 10;
  hub_hole_3 = 5.5;
  servo_hub_h = 4;
  servo_hub_h2 = 3;
  
  translate([0, 0, wheel_w/2]){
    difference(){
      edge1=7;
      edge2=5;
      wx1=0;
      wy1=wheel_w/2;
      wx2=radius-edge1;
      wy2=wheel_w/2;
      wx3=radius;
      wy3=wheel_w/2-edge2;
      wx4=wx3;
      wy4=-wy3;
      wx5=wx2;
      wy5=-wy2;
      wx6=0;
      wy6=-wy1;
      rotate_extrude($fn=chain_no){
        polygon(points=[[wx1,wy1],[wx2,wy2],[wx3,wy3],[wx4,wy4],[wx5,wy5],[wx6,wy6]]);
      }
      
      //cylinder($fn=chain_no, r=radius, h=wheel_w, center=true);
      x1=0;
      y1=horn_w1/2;
      x2=horn_d/2-horn_w2/2;
      y2=horn_w2/2;
      x3=horn_d/2-horn_w2/2;
      y3=-horn_w2/2;
      x4=0;
      y4=-horn_w1/2;
      
      translate([0, 0, wheel_w/2-horn_thickness/2+0.1]){
        cylinder(d=15, h=horn_thickness, center=true);
      }
      for(i=[0:90:360]){
        rotate([0, 0, i]){
          translate([horn_mount, 0, 0]){
            cylinder(d=3, h=wheel_w*1.1, center=true);
          }
          translate([(horn_d-horn_w2)/2, 0, wheel_w/2-horn_thickness/2+0.1]){
            cylinder(d=horn_w2, h=horn_thickness, center=true);
          }
          translate([0, 0, wheel_w/2-horn_thickness+0.1]){
            linear_extrude(height=horn_thickness){
              polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4]]);
            }
          }
        }
      }
      for(i=[0:1:chain_no-1]){
        rotate([0, 0, 180/chain_no + 360/chain_no*i]){
          translate([radius*cos(180/chain_no)+0.1, 0, 0]){
            rotate([90, 0, 270]){
              linear_extrude(height=track_wall+0.1, scale=0.8){
                square(size=[15.5, hub_h*2], center=true);
              }
            }
          }
        }
      }
      cylinder(d=hub_hole, h=hub_h*1.5, center=true);
      cylinder(d=hub_hole_2, h=hub_h, center=true);
    }
  }
}

module rear_wheel_mount(){
  mount_h = 16;
  mount_h2 = 3;
  mount_d = 30;
  mount_d2=18;
  axis_d = 4;
  M4_nut_d = 8;
  M4_nut_h = 5;
  
  translate([0, 0, mount_h/2]){
    difference(){
      cylinder(d=mount_d, h=mount_h, center=true);
      cylinder(d=axis_d, h=mount_h*1.1, center=true);
      translate([0, 0, (mount_h-M4_nut_h)/2+0.1]){
        cylinder($fn=6, d=M4_nut_d, h=M4_nut_h, center=true);
      }
    }
  }
  translate([mount_d+5, 0, mount_h2/2]){
    difference(){
      cylinder(d=mount_d, h=mount_h2, center=true);
      cylinder(d=axis_d, h=mount_h*1.1, center=true);
      translate([0, mount_d/2, 0]){
        cube(size=[mount_d, mount_d-mount_d2, mount_h2*1.1], center=true);
      }
      translate([0, -mount_d/2, 0]){
        cube(size=[mount_d, mount_d-mount_d2, mount_h2*1.1], center=true);
      }
    }
  }
}

module rear_wheel(){
  chain_l = track_l-track_h;
  echo(chain_l);
  echo(sin(90));
  chain_no = 10;
  radius = (chain_l/2)/sin(180/chain_no)+track_h/2-track_wall;
  echo(radius);
  wheel_w = track_w-2*track_wall-track_tolerance_w-1;
  hub_hole = 4.4;
  
  translate([0, 0, wheel_w/2]){
    difference(){
      edge1=7;
      edge2=5;
      wx1=0;
      wy1=wheel_w/2;
      wx2=radius-edge1;
      wy2=wheel_w/2;
      wx3=radius;
      wy3=wheel_w/2-edge2;
      wx4=wx3;
      wy4=-wy3;
      wx5=wx2;
      wy5=-wy2;
      wx6=0;
      wy6=-wy1;
      rotate_extrude($fn=200){
        polygon(points=[[wx1,wy1],[wx2,wy2],[wx3,wy3],[wx4,wy4],[wx5,wy5],[wx6,wy6]]);
      }
      //cylinder($fn=200, r=radius, h=wheel_w, center=true);
      cylinder(d=hub_hole, h=wheel_w*1.5, center=true);
    }
  }
}

module wheel_old(){
  chain_l = track_l-track_h;
  echo(chain_l);
  echo(sin(90));
  chain_no = 10;
  radius = (chain_l/2)/sin(180/chain_no)+track_h/2;
  echo(radius);
  wheel_w = track_w-2*track_wall-track_tolerance_w-1;
  hub_d = 20;
  hub_h = wheel_w+5;
  hub_hole = 3.5;
  hub_hole_2 = 10;
  hub_hole_3 = 5.5;
  servo_hub_h = 4;
  servo_hub_h2 = 3;
  
  translate([0, 0, wheel_w/2]){
    difference(){
      union(){
        cylinder($fn=chain_no, r=radius, h=wheel_w, center=true);
        translate([0, 0, (hub_h-wheel_w)/2]){
          cylinder(d=hub_d, h=hub_h, center=true);
        }
      }
      for(i=[0:1:chain_no-1]){
        rotate([0, 0, 180/chain_no + 360/chain_no*i]){
          translate([radius*cos(180/chain_no), 0, 0]){
            cube(size=[track_wall*2, 14, hub_h*2], center=true);
          }
        }
      }
      cylinder(d=hub_hole, h=hub_h*1.5, center=true);
      translate([0, 0,  wheel_w/2+(hub_h-wheel_w)-servo_hub_h-(hub_hole_2-hub_hole)/2-0.01]){
        cylinder(d1=hub_hole_2, d2=hub_hole, h=hub_hole_2-hub_hole, center=true);
      }
      translate([0, 0,  wheel_w/2+(hub_h-wheel_w)+servo_hub_h2]){
        cylinder(d=hub_hole_3, h=servo_hub_h2*4, center=true);
      }
      translate([0, 0,  (hub_h-wheel_w)/2-servo_hub_h-(hub_hole_2-hub_hole)]){
        cylinder(d=hub_hole_2, h=hub_h, center=true);
      }
    }
  }
}


module cable_chain(){
  width=track_w;
  height=track_h;
  length=track_l;
  wall=track_wall;
  tolerance=0.6;
  tolerance_w=track_tolerance_w;
  tolerance_stop = 0.4;
  overlap=0.5;
  link_w=10;
  l_stop=length/2-(link_w/2-(length/2-height))-tolerance_stop;
  
  
  l=length-height;
  
  scale_a = height/(cos(180/8)*height);
  
  x1=l/2;
  y1=0;
  x2=l/2;
  y2=height/2;
  x3=l_stop;
  y3=height/2;
  x4=l_stop;
  y4=height/3;
  
  for(i=[0:1:1]){
    mirror([0, i, 0]){
      translate([0, -(width-wall)/2, height/2]){
        rotate([90, 0, 0]){
          difference(){
            union(){
              translate([(l/2-overlap)/2, 0, 0]){
                cube(size=[l/2+overlap, height, wall], center=true);
              }
              //stopper
              translate([l_stop/2, -(height)/4, 0]){
                //cube(size=[l_stop, height/2, wall], center=true);
              }
              translate([-(l/2-overlap)/2, 0, wall+tolerance_w]){
                cube(size=[l/2+overlap, height, wall], center=true);
              }            
              translate([0, -height/2, -wall/2]){
                linear_extrude(height=wall){
                  polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4]]);
                }
              }
              mirror([0,1,0]){
                translate([0, -height/2, -wall/2]){
                  linear_extrude(height=wall){
                    polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4]]);
                  }
                }
              }              
              translate([-l/2, 0, wall+tolerance_w]){
                scale([1, scale_a]){
                  rotate([0, 0, 360/8/2]){
                    cylinder($fn=8, d=height, h=wall, center=true);
                  }
                }
              }
              translate([l/2, 0, wall]){
                cylinder(d1=height/2, d2=height/2-wall, h=wall, center=true);
              }
            }
            translate([-l/2, 0, wall+tolerance_w]){
              cylinder(d1=height/2, d2=height/2-wall, h=wall+0.025, center=true);
            }
          }
        }
      }
    }
  }

    
    translate([0, 0, wall/2]){
      cube(size=[link_w, width, wall], center=true);
    }
    difference(){
      translate([-link_w/4+overlap/2, (width-wall+tolerance_w)/2, height/2]){
        cube(size=[link_w/2+overlap, wall+tolerance_w, height], center=true);      
      }
      translate([-l/2, (width-wall)/2, height/2]){
        rotate([90, 0, 0]){
          cylinder(d=height+tolerance, h=wall*2.1, center=true);
        }
      }
    }
    difference(){
      translate([-link_w/4+overlap/2, -(width-wall+tolerance_w)/2, height/2]){
        cube(size=[link_w/2+overlap, wall+tolerance_w, height], center=true);      
      }
      translate([-l/2, -(width-wall)/2, height/2]){
        rotate([90, 0, 0]){
          cylinder(d=height+tolerance, h=wall*2.1, center=true);
        }
      }
    }
//  }
  
}

  
module power_pole(){
  wire_d = 2;
  hole_d = 5.2;
  hole_h = 20;
  socket_h = 120;
  socket_edge=20;
  hole_l = 20;
  pole_l = 70;
  pole_w = body_w-1;
  
  translate([0, 0, pole_l/2]){
    cube(size=[body_wall*4, pole_w, pole_l], center=true);
  }
  translate([-15, (pole_w-body_wall*2)/2-body_wall_2, pole_l/2]){
    difference(){
      cube(size=[30, body_wall*2, pole_l], center=true);
      translate([-10, 0, -20]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=body_wall*4, center=true);
        }
      }
      translate([-10, 0, -20+45]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=body_wall*4, center=true);
        }
      }
    }
  }
  
  translate([-15, -(pole_w-body_wall*2)/2+body_wall_2, pole_l/2]){
    difference(){
      cube(size=[30, body_wall*2, pole_l], center=true);
      translate([-10, 0, -20]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=body_wall*4, center=true);
        }
      }
      translate([-10, 0, -20+45]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=body_wall*4, center=true);
        }
      }
    }
  }
  //tower
  translate([socket_h/2, 0, socket_edge/2]){
    difference(){
      cube(size=[socket_h, socket_edge, socket_edge], center=true);
      translate([socket_h/2, 0, 0]){
        rotate([0, 90, 0]){
          cylinder(d=hole_d, h=hole_h*2, center=true);
        }
      }
      for(i=[1:1:4]){
        translate([socket_h/2-i*7, 0, 7]){
          rotate([90, 0, 0]){
            cylinder(d=wire_d, h=hole_h*2, center=true);
          }
        }
      }
    }
  }
  
  
  
}

module light_mount(){
  light_h = 15;
  light_thickness = 15;
  rear_cut_l = body_w;
  rear_cut_h = 8;
  rear_cut_d = 5;
  LED_no = 10;
  LED_d1 = 5;
  LED_d2 = 8;
  mount_l = 25;
  mount_w = 7; 
  mount_x = 12;
  mount_y = 7;
  receiver_w = 6.5;
  receiver_h = 9.5;
  receiver_d = 11;
  
  cable_d = 15;
  cable_wall = 2;
  cable_x = -5;
  cable_x2 = -9.5;
  cable_y = 3;
  
  
  x1=0;
  y1=0;
  x2=mount_l;
  y2=0;
  x3=mount_l;
  y3=mount_w;
  x4=0;
  y4=light_h*2;
  
  //Side mounts
  translate([light_h, body_w/2+body_wall, light_thickness]){
    rotate([90, 270, 0]){
      difference(){
        linear_extrude(height=body_wall){
          polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4]]);
        }
        translate([mount_x, mount_y, 0]){
          cylinder(d=M3_hole, h=20, center=true);
        }
      }
    }
  }
  translate([light_h, -(body_w/2), light_thickness]){
    rotate([90, 270, 0]){
      difference(){
        linear_extrude(height=body_wall){
          polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4]]);
        }
        translate([mount_x, mount_y, 0]){
          cylinder(d=M3_hole, h=20, center=true);
        }
      }
    }
  }
  //cable channel
  translate([1, body_w/2+body_wall, light_thickness/2+cable_y]){
    rotate([0, 90, 0]){
      difference(){
        union(){
          cylinder($fn=6, d=cable_d, h=light_h*2-cable_d, center=true);
          translate([0, 0, light_h-cable_d/2]){
            difference(){
              sphere($fn=6, d=cable_d, center=true);
              sphere($fn=6, d=cable_d-2*cable_wall, center=true);
            }
          }
          translate([0, 0, -(light_h-cable_d/2)]){
            difference(){
              sphere($fn=6, d=cable_d, center=true);
              sphere($fn=6, d=cable_d-2*cable_wall, center=true);
            }
          }
        }
        translate([0, 0, 0]){
          cylinder($fn=6, d=cable_d-2*cable_wall, h=light_h*2-cable_d+0.1, center=true);
        }
        translate([0, -cable_d/2, 0]){
          cube(size=[cable_d*1.1, cable_d, light_h*2.1], center=true);
        }
      }
    }
  }
  
  //Light bar
  translate([0, 0, light_thickness/2]){
    difference(){
      cube(size=[light_h*2, body_w+2*body_wall, light_thickness], center=true);
      translate([light_h, 0, 0]){
        cube(size=[light_h*2, body_w, light_thickness*1.1], center=true);
      }
      for(i=[0:1:LED_no-1]){
        translate([-light_h/2, -body_w/2+(i+0.5)*body_w/LED_no, 0]){
          cylinder(d=LED_d1, h=light_thickness*1.1, center=true);
        }
      }
      for(i=[0:1:LED_no-1]){
        translate([-light_h/2, -body_w/2+(i+0.5)*body_w/LED_no, light_thickness/2]){
          cylinder(d=LED_d2, h=light_thickness, center=true);
        }
      }
      //Cut IR receiver module
      translate([-light_h/2, -body_w/2+(5+0.5)*body_w/LED_no, (light_thickness-receiver_d)/2]){
        cube(size=[receiver_h, receiver_w, receiver_d+0.1], center=true);
      }
      //Cut IR receiver module
      translate([-light_h/2, 0, (light_thickness-rear_cut_d)/2]){
        cube(size=[rear_cut_h, rear_cut_l, rear_cut_d+0.1], center=true);
      }
      //Cut cable channel
      translate([cable_x, body_w/2+body_wall/2, cable_y]){
        rotate([90, 0, 0]){
          cylinder(d=cable_d*0.5, h=body_wall+0.1, center=true);
        }
      }
      translate([-cable_x2, body_w/2+body_wall/2, cable_y]){
        rotate([90, 0, 0]){
          cylinder(d=5, h=body_wall+0.1, center=true);
        }
      }

    }
  }
}

module servo(tolerance=0){
  translate([0, 0, servo_h/2]){
    cube(size=[servo_l, servo_w+tolerance, servo_h+tolerance], center=true);
  }
  translate([0, 0, servo_m_h+1]){
    cube(size=[servo_l+2*servo_m_l, servo_w+tolerance, 3], center=true);
  }
  
}

module servo_horn(leverangle = 90, cylinder_d=15){
  horn_d = 41;
  horn_w1 = 12;
  horn_w2 = 6;
  horn_thickness = 3;
  horn_mount = 13.7;

  xh1=0;
  yh1=horn_w1/2;
  xh2=horn_d/2-horn_w2/2;
  yh2=horn_w2/2;
  xh3=horn_d/2-horn_w2/2;
  yh3=-horn_w2/2;
  xh4=0;
  yh4=-horn_w1/2;
  
  translate([0, 0, horn_thickness/2]){
    cylinder(d=cylinder_d, h=horn_thickness, center=true);
  }
  for(i=[0:leverangle:360]){
    rotate([0, 0, i]){
      translate([horn_mount, 0, 0]){
        cylinder(d=3, h=20.1, center=true);
      }
      translate([(horn_d-horn_w2)/2, 0, horn_thickness/2]){
        cylinder(d=horn_w2, h=horn_thickness, center=true);
      }
      translate([0, 0, 0]){
        linear_extrude(height=horn_thickness){
          polygon(points=[[xh1,yh1],[xh2,yh2],[xh3,yh3],[xh4,yh4]]);
        }
      }
    }
  }
}

module camera_mount(){


  camera_w = 27;
  camera_h = 25;
  camera_pos = 5;
  camera_slot = 1;
  camera_thickness = 7;
  camera_wall = 1;
  camera_lever_x = 6;
  camera_lever_y = 16;
  camera_lever_z = 17;
  camera_lever_edge = 7;
  lever_h = camera_lever_z + camera_lever_edge;
  lever_l = camera_lever_y + camera_lever_edge;
  
  
  x1=camera_w/2-camera_wall;
  y1=camera_wall;
  x2=camera_w/2-camera_wall;
  y2=camera_pos-camera_slot/2;
  x3=camera_w/2;
  y3=camera_pos-camera_slot/2;
  x4=camera_w/2;
  y4=camera_pos+camera_slot/2;
  x5=camera_w/2-camera_wall;
  y5=camera_pos+camera_slot/2;
  x6=camera_w/2-camera_wall;
  y6=camera_thickness;
  x7=camera_w/2+camera_wall;
  y7=camera_thickness;
  x8=camera_w/2+camera_wall;
  y8=0;

  x9=-x8;
  y9=y8;
  x10=-x7;
  y10=y7;
  x11=-x6;
  y11=y6;
  x12=-x5;
  y12=y5;
  x13=-x4;
  y13=y4;
  x14=-x3;
  y14=y3;
  x15=-x2;
  y15=y2;
  x16=-x1;
  y16=y1;

  translate([0, 0, camera_wall]){
    linear_extrude(height=camera_h){
      polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4],[x5,y5],[x6,y6],[x7,y7],[x8,y8],
                      [x9,y9],[x10,y10],[x11,y11],[x12,y12],[x13,y13],[x14,y14],[x15,y15],[x16,y16]]);
    }
  }
  translate([0, camera_thickness/2, camera_wall/2]){
    cube(size=[camera_w+2*camera_wall, camera_thickness, camera_wall], center=true);
  }
    difference(){
      union(){
        x1l=0;
        y1l=0;
        x2l=-lever_l*1/3;
        y2l=0;
        x3l=-lever_l+2.1;
        y3l=camera_lever_z-5.0;
        x4l=-lever_l+7;
        y4l=lever_h;
        x5l=-lever_l/2;
        y5l=lever_h;
        x6l=0;
        y6l=lever_h;
        translate([camera_lever_x-camera_wall*2, 0, 0]){
          rotate([90, 0, 90]){
            linear_extrude(height=camera_wall*4){
              polygon(points=[[x1l,y1l],[x2l,y2l],[x3l,y3l],[x4l,y4l],[x5l,y5l],[x6l,y6l]]);
            }
          }
          //cube(size=[camera_wall, camera_lever_y, lever_h], center=true);
        }
        translate([camera_lever_x, -camera_lever_y, camera_lever_z]){
          rotate([0, 90, 0]){
            cylinder(r=camera_lever_edge, h=camera_wall*4, center=true);
          }
        }        
      }
      translate([camera_lever_x, -camera_lever_y, camera_lever_z]){
        rotate([0, 90, 0]){
          cylinder(d=3, h=camera_wall*4.1, center=true);
        }
      }
      translate([camera_lever_x-camera_wall*2, -camera_lever_y, camera_lever_z]){
        rotate([0, 90, 0]){
          cylinder(d=6.1, h=camera_wall*16.1, center=true);
        }
      }
      translate([camera_lever_x-1.5, -camera_lever_y, camera_lever_z]){
        rotate([90, 0, 270]){
          servo_horn(180, 12);
        }
      }
    }
  }



module pi_mount(){
  holder_l = body_l;
  tolerance = 1;
  wall_h = 10;
  mount_holes_x = 29;
  width = body_w-2*body_wall_2-tolerance;
  cable_hole_d1 = 20;
  cable_hole_d2 = 12;
  
  sensor_w = 20;
  sensor_h = 25;
  sensor_thick = 5;

/*  
  //Gyroscope sensor mount
  translate([(sensor_thick+2*body_wall-body_l)/2, (width-sensor_w-2*body_wall)/2, sensor_h/2+body_wall]){
    difference(){
      cube(size=[sensor_thick+2*body_wall, sensor_w+2*body_wall, sensor_h], center=true);
      cube(size=[sensor_thick, sensor_w, sensor_h*1.1], center=true);
      translate([0, sensor_w/2-3, sensor_h/2-3]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=sensor_w+2*body_wall+0.1, center=true);
        }
      }
      translate([0, -sensor_w/2+3, sensor_h/2-3]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=sensor_w+2*body_wall+0.1, center=true);
        }
      }
    }
  }
*/  
  
  translate([0, 0, body_wall/2]){
    block_l = 4;
    block_w = 35;
    block_h = servo_w+5;
    block_edge = 8;
    
/*
    //Servo mount
    translate([-(holder_l-block_l)/2+block_edge,
              -(width-block_w)/2,
              (block_h-body_wall)/2]){
      difference(){
        cube(size=[block_l, block_w, block_h], center=true);
        translate([0, block_w/3, 0]){
          cylinder(d=2, h=block_h+0.1, center=true);
        }
        translate([0, 0, 0]){
          cylinder(d=2, h=block_h+0.1, center=true);
        }
        translate([0, -block_w/3, 0]){
          cylinder(d=2, h=block_h+0.1, center=true);
        }

        translate([0, servo_m_h/2, servo_m_d/2]){
          rotate([90, 0, 0]){
            cylinder(d=3, h=servo_m_h*1.5, center=true);
          }
        }
        translate([0, servo_m_h/2, -servo_m_d/2]){
          rotate([90, 0, 0]){
            cylinder(d=3, h=servo_m_h*1.5, center=true);
          }
        }            
      }
    }
*/    
    difference(){
      union(){
        cube(size=[holder_l, width, body_wall], center=true);
        //Walls
        translate([(holder_l-body_wall)/2, 0, raspberry_mount_h/2]){
          cube(size=[body_wall, width, raspberry_mount_h], center=true);
        }
        translate([(holder_l-body_wall)/2, 0, wall_h/2]){
          difference(){
          cube(size=[body_wall, width, wall_h], center=true);
            translate([0, 0, body_w*0.66]){
              rotate([0, 90, 0]){
                cylinder(d=body_w*1.5, h=body_wall*1.1, center=true);
              }
            }
          }
        }
/*        
        translate([-(holder_l-body_wall)/2, 0, wall_h/2]){
          difference(){
            cube(size=[body_wall, width, wall_h], center=true);
            translate([0, 0, body_w*0.66]){
              rotate([0, 90, 0]){
                cylinder(d=body_w*1.5, h=body_wall*1.1, center=true);
              }
            }
          }
        }
*/        
        translate([0, (width-body_wall)/2, wall_h/2]){
          cube(size=[holder_l, body_wall, wall_h], center=true);
        }
        translate([0, -(width-body_wall)/2, wall_h/2]){
          cube(size=[holder_l, body_wall, wall_h], center=true);
        }
/*
        //Servo mount enforcement
        bx1=0;
        by1=0;
        bx2=-block_h;
        by2=0;
        bx3=-block_h;
        by3=block_h;
        translate([-holder_l/2+block_h+block_l+block_edge, body_wall-width/2, -body_wall/2]){
          rotate([90, 0, 0]){
            linear_extrude(height=body_wall){
              polygon(points=[[bx1,by1],[bx2,by2],[bx3,by3]]);
            }
          }
        }
*/
      }

      //Side mount hole
      side_mount_x=-29;
      side_mount_z=3;
      translate([side_mount_x, 0, side_mount_z]){
        rotate([90, 0, 0]){
          cylinder(d=3, h=100, center=true);
        }
      }

      //Battery box mount screw holes
      bat_edge=15;
      translate([-bat_edge+(holder_l-bat_l)/2, (bat_width+bat_b_edge)/2, 0]){
        //cylinder(d=M3_hole, h=body_wall*100.1, center=true);
      }
      translate([-bat_edge+(holder_l-bat_l)/2+bat_length/4, (bat_width+bat_b_edge)/2, 0]){
        cylinder(d=M3_hole, h=body_wall*100.1, center=true);
      }
      translate([-bat_edge+(holder_l-bat_l)/2-bat_length/4, (bat_width+bat_b_edge)/2, 0]){
        cylinder(d=M3_hole, h=body_wall*100.1, center=true);
      }
      translate([-bat_edge+(holder_l-bat_l)/2, -(bat_width+bat_b_edge)/2, 0]){
        //cylinder(d=M3_hole, h=body_wall*100.1, center=true);
      }
      translate([-bat_edge+(holder_l-bat_l)/2+bat_length/4, -(bat_width+bat_b_edge)/2, 0]){
        cylinder(d=M3_hole, h=body_wall*100.1, center=true);
      }
      translate([-bat_edge+(holder_l-bat_l)/2-bat_length/4, -(bat_width+bat_b_edge)/2, 0]){
        cylinder(d=M3_hole, h=body_wall*100.1, center=true);
      }



      //Pi mount holes
      translate([0, raspberry_mount_edge_y, 0]){
        translate([body_l/2-raspberry_mount_edge_x, raspberry_mount_w/2, 0]){
            cylinder(d=raspberry_mount_screw_d, h=raspberry_mount_h*1.1, center=true);
        }
        translate([body_l/2-raspberry_mount_edge_x, -raspberry_mount_w/2, 0]){
            cylinder(d=raspberry_mount_screw_d, h=raspberry_mount_h*1.1, center=true);
        }
        translate([body_l/2-raspberry_mount_edge_x-raspberry_mount_l, raspberry_mount_w/2, 0]){
            cylinder(d=raspberry_mount_screw_d, h=raspberry_mount_h*1.1, center=true);
        }
        translate([body_l/2-raspberry_mount_edge_x-raspberry_mount_l, -raspberry_mount_w/2, 0]){
            cylinder(d=raspberry_mount_screw_d, h=raspberry_mount_h*1.1, center=true);
        }
      }


      //Servo  cut
      translate([-(holder_l+block_l-block_edge)/2, -15*0, 0]){
        cube(size=[block_l+block_edge, width, block_h*2], center=true);
      }
      
      //Cable cuts
      translate([15, 27, 0]){
        //cylinder(d=cable_hole_d2, h=body_wall * 1.1, center=true);
      }
      translate([15, -27, 0]){
        //cylinder(d=cable_hole_d2, h=body_wall * 1.1, center=true);
      }
      translate([5, 0, 0]){
        cylinder(d=cable_hole_d1, h=body_wall * 1.1, center=true);
      }
      translate([50, 0, 0]){
        cylinder(d=cable_hole_d2, h=body_wall * 1.1, center=true);
      }
      translate([-38, 0, 0]){
        cylinder(d=cable_hole_d2, h=body_wall * 1.1, center=true);
      }
/*      
      //Servo cut
      translate([-(body_l+servo_l)/2+body_wall+0.1, -(body_w-2*body_wall)/2+1, (servo_w-body_wall)/2-0.1]){
        rotate([270, 0, 0]){
          servo(3);
        }
      }
*/
      
      translate([-mount_holes_x, center_mount_holes/2, 0]){
        cylinder(d=M3_hole, h=body_wall*1.1, center=true);
      }
      translate([-mount_holes_x, -center_mount_holes/2, 0]){
        cylinder(d=M3_hole, h=body_wall*1.1, center=true);
      }
      translate([-mount_holes_x, center_mount_holes_2/2, 0]){
        cylinder(d=M3_hole, h=body_wall*1.1, center=true);
      }
      translate([-mount_holes_x, -center_mount_holes_2/2, 0]){
        cylinder(d=M3_hole, h=body_wall*1.1, center=true);
      }
    }

    //board_holder
    board_mount_d = 11;
    board_hole_d = 3;
    board_hole_x1 = 17;
    board_hole_x2 = -47.5;
    board_hole_x3 = -55.5;
    board_hole_y1 = -39;
    board_hole_y2 = 33;
    board_hole_h = 10;
 
    translate([board_hole_x1, board_hole_y1, board_hole_h/2]){
      difference(){
        cylinder(d=board_mount_d, h=board_hole_h, center=true);
        cylinder(d=board_hole_d, h=board_hole_h*1.1, center=true);
      }
    }
    
    translate([board_hole_x2, board_hole_y1, board_hole_h/2]){
      difference(){
        cylinder(d=board_mount_d, h=board_hole_h, center=true);
        cylinder(d=board_hole_d, h=board_hole_h*1.1, center=true);
      }
    }
/*  
    translate([board_hole_x3, board_hole_y2, board_hole_h/2]){
      difference(){
        cylinder(d=board_mount_d, h=board_hole_h, center=true);
        cylinder(d=board_hole_d, h=board_hole_h*1.1, center=true);
      }
    }
*/  
    
    //Pi mount points
    translate([0, raspberry_mount_edge_y, 0]){
      translate([body_l/2-raspberry_mount_edge_x, raspberry_mount_w/2, raspberry_mount_h/2]){
        difference(){
          cylinder(d=raspberry_mount_d, h=raspberry_mount_h, center=true);
          cylinder(d=raspberry_mount_screw_d, h=raspberry_mount_h*1.1, center=true);
        }
      }
      translate([body_l/2-raspberry_mount_edge_x, -raspberry_mount_w/2, raspberry_mount_h/2]){
        difference(){
          cylinder(d=raspberry_mount_d, h=raspberry_mount_h, center=true);
          cylinder(d=raspberry_mount_screw_d, h=raspberry_mount_h*1.1, center=true);
        }
      }
      translate([body_l/2-raspberry_mount_edge_x-raspberry_mount_l, raspberry_mount_w/2, raspberry_mount_h/2]){
        difference(){
          cylinder(d=raspberry_mount_d, h=raspberry_mount_h, center=true);
          cylinder(d=raspberry_mount_screw_d, h=raspberry_mount_h*1.1, center=true);
        }
      }
      translate([body_l/2-raspberry_mount_edge_x-raspberry_mount_l, -raspberry_mount_w/2, raspberry_mount_h/2]){
        difference(){
          cylinder(d=raspberry_mount_d, h=raspberry_mount_h, center=true);
          cylinder(d=raspberry_mount_screw_d, h=raspberry_mount_h*1.1, center=true);
        }
      }
    }
  }
}

module top_lid(){
  wall_h = 7;
  tolerance = 0.2;
  bat_space = 1;
  bat_pos = 12;
  mount_holes_z = 4;
  
  translate([0, 0, body_wall/2]){
    difference(){
      union(){
        cube(size=[body_l+2*body_wall, body_w, body_wall], center=true);
        translate([(body_l-body_wall)/2-tolerance, 0, (wall_h+body_wall)/2]){
          cube(size=[body_wall, body_w-2*(body_wall+tolerance), wall_h], center=true);
        }
        translate([-(body_l-body_wall)/2+tolerance, 0, (wall_h+body_wall)/2]){
          cube(size=[body_wall, body_w-2*(body_wall+tolerance), wall_h], center=true);
        }
        translate([0, (body_w-3*body_wall)/2-tolerance, (wall_h+body_wall)/2]){
          cube(size=[body_l-2*(body_wall+tolerance), body_wall, wall_h], center=true);
        }
        translate([0, -(body_w-3*body_wall)/2+tolerance, (wall_h+body_wall)/2]){
          cube(size=[body_l-2*(body_wall+tolerance), body_wall, wall_h], center=true);
        }
      }

      //mount screw holes
      translate([clamp_cut_x, 0, mount_holes_z]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=body_w*1.1, center=true);
        }
      }
      translate([0, 0, mount_holes_z]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=body_w*1.1, center=true);
        }
      }
      translate([-clamp_cut_x, 0, mount_holes_z]){
        rotate([90, 0, 0]){
          cylinder(d=M3_hole, h=body_w*1.1, center=true);
        }
      }
      
      
    }
  }
  
}

module battery_holder(){
  cable_hole=2;
  wall_height = bat_d-2;  
  wall_l = bat_length-bat_cut_l-bat_wall/2;
  
  clamp_l = bat_width+2.5;
  clamp_w = bat_clamp_cut_l - 1;
  clamp_edge = 9;
  clamp_wall = 2;
  
  
//rotate([0, 90, 0])
//translate([-54.5, 0, 0])
  
  //clamp
  translate([30, 0, clamp_w/2]){
    cube(size=[clamp_wall, clamp_l, clamp_w], center=true);
    translate([(clamp_edge-clamp_wall)/2, (clamp_l+clamp_wall)/2, 0]){
      cube(size=[clamp_edge, clamp_wall, clamp_w], center=true);
    }
    translate([clamp_edge-clamp_wall, clamp_l/2, 0]){
      cube(size=[bat_clamp_cut_h-1, clamp_wall*2, clamp_w], center=true);
    }
    translate([(clamp_edge-clamp_wall)/2, -(clamp_l+clamp_wall)/2, 0]){
      cube(size=[clamp_edge, clamp_wall, clamp_w], center=true);
    }
    translate([clamp_edge-clamp_wall, -clamp_l/2, 0]){
      cube(size=[bat_clamp_cut_h-1, clamp_wall*2, clamp_w], center=true);
    }
  }
  
  
  translate([0, 0, bat_b_plate]){
    difference(){
      union(){
        translate([0, 0, bat_wall_base/2]){
          cube(size=[bat_length, bat_width, bat_wall_base], center=true);
        }
        translate([0, 0, -bat_b_plate/2]){
          cube(size=[bat_length, bat_width+2*bat_b_edge, bat_b_plate], center=true);
        }
      }
      //mount screw holes
      translate([0, (bat_width+bat_b_edge)/2, -bat_b_plate/2]){
        //cylinder(d=M3_hole, h=wall_height, center=true);
      }
      translate([bat_length/4, (bat_width+bat_b_edge)/2, -bat_b_plate/2]){
        cylinder(d=M3_hole, h=wall_height, center=true);
      }
      translate([-bat_length/4, (bat_width+bat_b_edge)/2, -bat_b_plate/2]){
        cylinder(d=M3_hole, h=wall_height, center=true);
      }
      translate([0, -(bat_width+bat_b_edge)/2, -bat_b_plate/2]){
        //cylinder(d=M3_hole, h=wall_height, center=true);
      }
      translate([bat_length/4, -(bat_width+bat_b_edge)/2, -bat_b_plate/2]){
        cylinder(d=M3_hole, h=wall_height, center=true);
      }
      translate([-bat_length/4, -(bat_width+bat_b_edge)/2, -bat_b_plate/2]){
        cylinder(d=M3_hole, h=wall_height, center=true);
      }
      
      for(i=[0:1:bat_no]){
        translate([(bat_length-bat_cut_l)/2+0.1, bat_width/2-i*(bat_d+bat_wall)-(bat_width-bat_no*(bat_d+bat_wall))/2, 0]){
          cube(size=[bat_cut_l+0.2, bat_cut_w+0.1, bat_wall_base*2.5], center=true);
        }
      }
      for(i=[1:1:bat_no]){
        translate([-(bat_wall_2-bat_wall)/2, bat_width/2-i*(bat_d+bat_wall)-(-bat_d)/2-(bat_width-bat_no*(bat_d+bat_wall))/2+bat_wall/2, bat_d/2]){
          rotate([0, 90, 0]){
            cylinder(d=bat_d+0.5, h=bat_l, center=true);
          }
        }
      }
    }
    
    for(i=[1:1:bat_no-1]){
      //walls
      translate([(bat_wall-bat_length+wall_l)/2, bat_width/2-i*(bat_d+bat_wall)-(bat_width-bat_no*(bat_d+bat_wall))/2, wall_height/2]){
        cube(size=[wall_l, bat_wall, wall_height], center=true);
      }
    }
    //Outer walls are thicker
      translate([(bat_wall-bat_length+wall_l)/2, bat_width/2-bat_wall, wall_height/2]){
        difference(){
          cube(size=[wall_l, bat_wall*2, wall_height], center=true);
          translate([bat_clamp_pos_x, 0, bat_clamp_pos_z]){
            cube(size=[bat_clamp_cut_l, bat_wall*2.1, bat_clamp_cut_h], center=true);
          }
        }
      }    
      translate([(bat_wall-bat_length+wall_l)/2, bat_wall-bat_width/2, wall_height/2]){
        difference(){
          cube(size=[wall_l, bat_wall*2, wall_height], center=true);
          translate([bat_clamp_pos_x, 0, bat_clamp_pos_z]){
            cube(size=[bat_clamp_cut_l, bat_wall*2.1, bat_clamp_cut_h], center=true);
          }
        }
      }
    
    
    for(i=[1:1:bat_no]){
      //positive terminals
      translate([(bat_length-bat_wall_2)/2, bat_width/2-i*(bat_d+bat_wall)-(-bat_d)/2-(bat_width-bat_no*(bat_d+bat_wall))/2+bat_wall/2, bat_d/2]){
        difference(){
          union(){
            rotate([0, 90, 0]){
              cylinder(d=bat_d-(bat_cut_w-bat_wall), h=bat_wall_2, center=true);
            }
            translate([0, 0, -bat_d/4]){
              cube(size=[bat_wall_2, bat_d-(bat_cut_w-bat_wall), bat_d/2], center=true);
            }
          }
          translate([-bat_wall_2/2, 0, 0]){
            //rotate([0, 90, 0]){
              cube(size=[bat_wall_2, bat_anode_d, bat_anode_d], center=true);
            //}
          }
          translate([0, 0, (bat_anode_d-bat_slit)/2]){
            cube(size=[bat_wall_2*2, bat_anode_d, bat_slit], center=true);
          }
          translate([0, 0, -(bat_anode_d-bat_slit)/2]){
            cube(size=[bat_wall_2*2, bat_anode_d, bat_slit], center=true);
          }
          translate([0, 0, bat_d/2]){
            cube(size=[bat_wall_2*2, bat_width, 5], center=true);
          }
        }
      }
    }
    translate([(bat_wall-bat_length)/2, 0, 0]){
      difference(){
        translate([0, 0, wall_height/2]){
          cube(size=[bat_wall, bat_width, wall_height], center=true);
        }
        //negative terminals
        for(i=[1:1:bat_no]){
          translate([0, bat_width/2-i*(bat_d+bat_wall)-(-bat_d)/2-(bat_width-bat_no*(bat_d+bat_wall))/2+bat_wall/2, (bat_d+bat_anode_d-bat_slit)/2]){
            cube(size=[bat_wall*2, bat_anode_d, bat_slit], center=true);
          }
          translate([0, bat_width/2-i*(bat_d+bat_wall)-(-bat_d)/2-(bat_width-bat_no*(bat_d+bat_wall))/2+bat_wall/2, (bat_d-bat_anode_d+bat_slit)/2]){
            cube(size=[bat_wall*2, bat_anode_d, bat_slit], center=true);
          }
          translate([0, bat_width/2-(i-1)*(bat_d+bat_wall)-(cable_hole)/2-2*bat_wall, cable_hole/2+bat_wall_base]){
            rotate([0, 90, 0]){
              cylinder(d=cable_hole, h=bat_wall*2, center=true);
            }
          }
        }
        
      }
    }
  }
  
}

module body_half(front_half = 0){
  //Body in two halfes
  shift_1 = 5;
  half_tolerance = 0.4;
  brim_h = 0.35;
  brim_d = 10;
  if(front_half == 0){
    //Rear half
    translate([shift_1, (body_w-body_wall)/2, brim_h/2]){
      cylinder(d=brim_d, h=brim_h, center=true);
    }
    translate([shift_1, -(body_w-body_wall)/2, brim_h/2]){
      cylinder(d=brim_d, h=brim_h, center=true);
    }
    difference(){
      body();
      translate([body_l/2-shift_1, 0, body_h/2]){
        cube(size=[body_l, body_w-body_wall_2+half_tolerance, body_h*2], center=true);
      }
      translate([body_l/2+shift_1, 0, body_h/2]){
        cube(size=[body_l, body_w*2, body_h*2], center=true);
      }
    }

    //Front half
  }
  else{
    difference(){
      body();
      translate([-(body_l/2-shift_1), (body_w+body_wall_2)/2, body_h/2]){
        cube(size=[body_l, body_wall_2*2, body_h*2], center=true);
      }
      translate([-(body_l/2-shift_1), -(body_w+body_wall_2)/2, body_h/2]){
        cube(size=[body_l, body_wall_2*2, body_h*2], center=true);
      }
      translate([-(body_l/2+shift_1), 0, body_h/2]){
        cube(size=[body_l, body_w*2, body_h*2], center=true);
      }
    }
  }
}
  

module body(){    
  window_w = 65;
  window_h = 55;
  window_f = 80;
  
  light_cable_x = 61;
  light_cable_y = 65.5;
  
  rear_sections = 10;
  
  difference(){
    translate([0, 0, body_h/2]){
      union(){
        xp1=0;
        yp1=0;
        xp3=sin(360/10)*body_h/2;
        yp3=(body_h/2 - (body_h/2)*cos(360/10));
        xp2=xp3-yp3;
        yp2=0;
        xp4=0;
        yp4=yp2;

        //Front & rear bottom edges
        translate([body_l/2, body_w/2, -body_h/2]){
          rotate([90, 0, 0]){
            linear_extrude(height=body_w){
              polygon(points=[[xp1, yp1],[xp2, yp2],[xp3, yp3],[xp4, yp4]]);
            }
          }
        }
        mirror([1, 0, 0]){
          translate([body_l/2, body_w/2, -body_h/2]){
            rotate([90, 0, 0]){
              linear_extrude(height=body_w){
                polygon(points=[[xp1, yp1],[xp2, yp2],[xp3, yp3],[xp4, yp4]]);
              }
            }
          }
        }
        
        $fn=rear_sections;
        rotate([90, 0, 0]){
          translate([body_l/2, 0, 0]){
            difference(){
              //rotate([0, 0, 360/(rear_sections*2)]){
                cylinder($fn=200, d=body_h, h=window_f, center=true);
              //}
              //cube(size=[body_h*0.5, body_w*1.1, body_h*1.1], center=true);
            }
          }
          translate([body_l/2, 0, 0]){
            rotate([0, 0, 360/(rear_sections*2)]){
              difference(){
                cylinder(d=body_h, h=body_w, center=true);
                cube(size=[body_h*1.1, body_h*1.1, window_f], center=true);
              }
            }
          }
          translate([-body_l/2, 0, 0]){
            rotate([0, 0, 360/(rear_sections*2)]){
              cylinder(d=body_h, h=body_w, center=true);
            }
          }
          cube(size=[body_l+2*body_wall, body_h, body_w], center=true);
        }
      }
    }
    
    //Cut bumper mounts
    translate([bumper_mount_x1+15, bumper_mount_y, 0]){
      cylinder(d=3, h=20, center=true);
      translate([0, 0, 12]){
        cylinder($fn=6, d=5, h=20, center=true);
      }
    }
    translate([bumper_mount_x1+15, -bumper_mount_y, 0]){
      cylinder(d=3, h=20, center=true);
      translate([0, 0, 12]){
        cylinder($fn=6, d=5, h=20, center=true);
      }
    }
    translate([-(bumper_mount_x1+15), bumper_mount_y, 0]){
      cylinder(d=3, h=20, center=true);
      translate([0, 0, 12]){
        cylinder($fn=6, d=5, h=20, center=true);
      }
    }
    translate([-(bumper_mount_x1+15), -bumper_mount_y, 0]){
      cylinder(d=3, h=20, center=true);
      translate([0, 0, 12]){
        cylinder($fn=6, d=5, h=20, center=true);
      }
    }

    
    //Cut inner part
    difference(){
      union(){
        translate([0, 0, body_h/2]){
          $fn=rear_sections;
          rotate([90, 0, 0]){
            translate([body_l/2, 0, 0]){
              rotate([0, 0, 360/(rear_sections*2)]){
                cylinder(d=body_h-2*body_wall, h=body_w-2*body_wall_2, center=true);
              }
            }
            translate([-body_l/2, 0, 0]){
              rotate([0, 0, 360/(rear_sections*2)]){
                cylinder(d=body_h-2*body_wall, h=body_w-2*body_wall_2, center=true);
              }
            }
            cube(size=[body_l, body_h-2*body_wall, body_w-2*body_wall_2], center=true);
          }
        }
      }
      //Don't cut bumper mounts
      translate([bumper_mount_x1+15, bumper_mount_y, 0]){
        cylinder(d=8, h=8, center=true);
      }
      translate([bumper_mount_x1+15, -bumper_mount_y, 0]){
        cylinder(d=8, h=8, center=true);
      }
      translate([-(bumper_mount_x1+15), bumper_mount_y, 0]){
        cylinder(d=8, h=8, center=true);
      }
      translate([-(bumper_mount_x1+15), -bumper_mount_y, 0]){
        cylinder(d=8, h=8, center=true);
      }

      //Don't cut rear hinge part
      translate([-body_l/2-60, 0, 0]){
        cube(size=[80, body_w, rear_cut_h*2-0.21], center=true);
      }
      //Don't cut center mount
      translate([0, 0, center_mount_h/2+body_wall]){
        cube(size=[center_mount_l, center_mount_w, center_mount_h], center=true);
      }
    }

    //Front window
    translate([body_l/2, 0, body_h/2]){
      rotate([0, 90, 0]){
        linear_extrude(height=body_l){
          edge_h=15;
          edge_w=20;
          y1=window_w/2;
          x1=window_h/2-edge_h;
          y2=window_w/2-edge_w;
          x2=window_h/2;
          y3=-window_w/2+edge_w;
          x3=window_h/2;
          y4=-window_w/2;
          x4=window_h/2-edge_h;
          y5=-window_w/2;
          x5=-window_h/2+edge_h;
          y6=-window_w/2+edge_w;
          x6=-window_h/2;
          y7=window_w/2-edge_w;
          x7=-window_h/2;
          y8=window_w/2;
          x8=-window_h/2+edge_h;
          
          polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4],[x5,y5],[x6,y6],[x7,y7],[x8,y8]]);
        }
      }
    }
    //Screw holes window
    translate([body_l/2, window_w/2+(window_f-window_w)/4, body_h/2]){
      for(j=[-20:20:20]){
        rotate([0, 90+j, 0]){
          translate([0, 0, body_h/2]){
            cylinder(d=2, h=body_h, center=true);
          }
        }
      }
    }
    translate([body_l/2, -window_w/2-(window_f-window_w)/4, body_h/2]){
      for(j=[-20:20:20]){
        rotate([0, 90+j, 0]){
          translate([0, 0, body_h/2]){
            cylinder(d=2, h=body_h, center=true);
          }
        }
      }
    }
    translate([body_l/2, -window_w*0.39-(window_f-window_w)/8, body_h/2]){
      for(j=[-38:76:38]){
        rotate([0, 90+j, 0]){
          translate([0, 0, body_h/2]){
            cylinder(d=2, h=body_h, center=true);
          }
        }
      }
    }
    translate([body_l/2, window_w*0.39+(window_f-window_w)/8, body_h/2]){
      for(j=[-38:76:38]){
        rotate([0, 90+j, 0]){
          translate([0, 0, body_h/2]){
            cylinder(d=2, h=body_h, center=true);
          }
        }
      }
    }
    translate([body_l/2, -window_w*0.23-(window_f-window_w)/8, body_h/2]){
      for(j=[-57:114:57]){
        rotate([0, 90+j, 0]){
          translate([0, 0, body_h/2]){
            cylinder(d=2, h=body_h, center=true);
          }
        }
      }
    }
    translate([body_l/2, window_w*0.23+(window_f-window_w)/8, body_h/2]){
      for(j=[-57:114:57]){
        rotate([0, 90+j, 0]){
          translate([0, 0, body_h/2]){
            cylinder(d=2, h=body_h, center=true);
          }
        }
      }
    }

    translate([body_l/2, 0, body_h/2]){
      for(j=[-63:126:63]){
        rotate([0, 90+j, 0]){
          translate([0, 0, body_h/2]){
            //cylinder(d=2, h=body_h, center=true);
          }
        }
      }
    }


    //top cut
    translate([0, 0, body_h-body_wall/2]){
      cube(size=[body_l, body_w-2*body_wall_2, body_wall*1.1], center=true);
    }
    
    //Servo cuts
    translate([(body_l-servo_l)/2, 0, body_wall+servo_w/2]){
      cube(size=[servo_l, body_w*1.1, servo_w], center=true);
    }
    translate([(body_l)/2-servo_cable_cut_w*0.1, 0, body_wall+servo_w/2]){
      rotate([90, 0, 0]){
        cylinder(d=servo_cable_cut_w*1.3, h=body_w*1.1, center=true);
      }
    }
    
    //Rear axis cuts
    diff=(track_l-track_h)/2;
    translate([-(body_l-servo_l)/2-11-diff/2, 0, body_wall+servo_w/2]){
      rotate([90, 0, 0]){
        cylinder(d=rear_axle_d, h=body_w*1.1, center=true);
      }
    }
    translate([-(body_l-servo_l)/2-11+diff/2, 0, body_wall+servo_w/2]){
      rotate([90, 0, 0]){
        cylinder(d=rear_axle_d, h=body_w*1.1, center=true);
      }
    }
    translate([-(body_l-servo_l)/2-11, 0, body_wall+servo_w/2]){
      cube(size=[diff, body_w*1.1, rear_axle_d], center=true);
    }
    
    //Battery box cut
    translate([battery_cut_x, 0, body_wall/2]){
      cube(size=[battery_cut_l, battery_cut_w, body_wall*1.1], center=true);
    }
        
    //Servo mount holes
    translate([(body_l+servo_m_l)/2, 0, body_wall+servo_w/2+servo_m_d/2]){
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=body_w*1.1, center=true);
      }
    }
    translate([(body_l+servo_m_l)/2, 0, body_wall+servo_w/2-servo_m_d/2]){
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=body_w*1.1, center=true);
      }
    }
    translate([(body_l-servo_m_l)/2-servo_l, 0, body_wall+servo_w/2+servo_m_d/2]){
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=body_w*1.1, center=true);
      }
    }
    translate([(body_l-servo_m_l)/2-servo_l, 0, body_wall+servo_w/2-servo_m_d/2]){
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=body_w*1.1, center=true);
      }
    }

    
    //Clamps cut;
    translate([clamp_cut_x, 0, clamp_cut_z]){
      //cube(size=[clamp_cut_l, body_w * 1.1, clamp_cut_h], center=true);
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=body_w*1.1, center=true);
      }
    }
    translate([-clamp_cut_x, 0, clamp_cut_z]){
      //cube(size=[clamp_cut_l, body_w * 1.1, clamp_cut_h], center=true);
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=body_w*1.1, center=true);
      }      
    }
    translate([0, 0, clamp_cut_z]){
      //cube(size=[clamp_cut_l, body_w * 1.1, clamp_cut_h], center=true);
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=body_w*1.1, center=true);
      }      
    }

    //center mount holes
    translate([0, 0, center_mount_h/2+body_wall]){
      translate([0, center_mount_holes/2, center_mount_h/2]){
        cylinder(d=center_mount_holes_d, h=center_mount_h, center=true);
      }
      translate([0, -center_mount_holes/2, center_mount_h/2]){
        cylinder(d=center_mount_holes_d, h=center_mount_h, center=true);
      }
      translate([0, center_mount_holes_2/2, center_mount_h/2]){
        cylinder(d=center_mount_holes_d, h=center_mount_h, center=true);
      }
      translate([0, -center_mount_holes_2/2, center_mount_h/2]){
        cylinder(d=center_mount_holes_d, h=center_mount_h, center=true);
      }
    }
    //mount holes halfes
    translate([0, 0, center_mount_h/2+body_wall]){
      translate([0, center_mount_holes/2, 0]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=center_mount_h, center=true);
        }
      }
      translate([0, -center_mount_holes/2, 0]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=center_mount_h, center=true);
        }
      }
      translate([0, center_mount_holes_2/2, 0]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=center_mount_h, center=true);
        }
      }
      translate([0, -center_mount_holes_2/2, 0]){
        rotate([0, 90, 0]){
          cylinder(d=M3_hole, h=center_mount_h, center=true);
        }
      }
    }
    translate([0, 0, mount_halfes_h1]){
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=body_w*1.1, center=true);
      }
    }

    //Headlight cable hole
    translate([light_cable_x, -body_w/2, light_cable_y]){
      rotate([90, 0, 0]){
        cylinder(d=5, h=body_w*1.1, center=true);
      }
    }
    


  }

  //front stops
  x1s=0;
  y1s=0;
  x2s=0;
  y2s=rear_cut_h-servo_w-body_wall;
  x3s=rear_cut_h-servo_w-body_wall;
  y3s=rear_cut_h-servo_w-body_wall;
  
  translate([body_l/2-20, body_w/2-body_wall_2-x3s, servo_w+body_wall+y3s]){
    rotate([0, 90, 0]){
      linear_extrude(height=20){
        polygon(points=[[x1s,y1s],[x2s,y2s],[x3s,y3s]], center=true);
      }
    }
  }
  mirror([0, 1, 0]){
    translate([body_l/2-20, body_w/2-body_wall_2-x3s, servo_w+body_wall+y3s]){
      rotate([0, 90, 0]){
        linear_extrude(height=20){
          polygon(points=[[x1s,y1s],[x2s,y2s],[x3s,y3s]], center=true);
        }
      }
    }
  }

  //Bottom cable channel
  ch_w = 12;
  ch_l = body_l * 0.1;
  ch_pos= body_l * 0.25;
  translate([ch_pos, 0, (ch_w+body_wall)/2]){
    difference(){
      rotate([0, 90, 0]){
        cylinder(d=ch_w+4.5, h=ch_l, center=true);
      }
        rotate([0, 90, 0]){
          rotate([0, 0, 22.5]){
            cylinder($fn=8, d=ch_w, h=ch_l*1.1, center=true);
          }
        }
        translate([0, 0, -ch_w]){
          cube(size=[ch_l*1.1, ch_l*1.1, ch_w], center=true);
        }
    }
  }
  
  
  //RoboSpatium.de
  translate([0, -body_w/2, body_h*0.70]){
    difference(){
      rotate([90, 0, 0]){
        linear_extrude(height=0.5, scale=[0.95, 0.9]){
          square(size=[body_l, body_h*0.31], center=true);
        }
      }
      rotate([90, 0, 0]){
        linear_extrude(height=body_wall*1, scale=[1, 1], center = true) {
          text("RoboSpatium.de", size=9, font="Purisa", halign = "center", valign = "center");
        }
      }
    }
  }
  rotate([0, 0, 180]){
    translate([0, -body_w/2, body_h*0.70]){
      difference(){
        rotate([90, 0, 0]){
          linear_extrude(height=0.5, scale=[0.95, 0.9]){
            square(size=[body_l, body_h*0.31], center=true);
          }
        }
        rotate([90, 0, 0]){
          linear_extrude(height=body_wall*1, scale=[1, 1], center = true) {
            text("RoboSpatium.de", size=9, font="Purisa", halign = "center", valign = "center");
          }
        }
      }
    }
  }

    
    
  
  //Support structures bridging
  translate([body_l/2-10, body_w/2 + 3, 0]){
   bridge_post(servo_w + body_wall, 5, 15, 15);
  }
  translate([body_l/2-25, body_w/2 + 3, 0]){
   bridge_post(servo_w + body_wall, 5, 15, 15, 18);
  }

  mirror([0, 1, 0]){
    translate([body_l/2-10, body_w/2 + 3, 0]){
     bridge_post(servo_w + body_wall, 5, 15, 15);
    }
    translate([body_l/2-25, body_w/2 + 3, 0]){
     bridge_post(servo_w + body_wall, 5, 15, 15, 18);
    }
  }
  
    
}


module carriage(){  

  tolerance_l = 1;
  tolerance_d = 1;
  
  servo_m_hole = 2;

  length=servo_l+2*servo_m_l;
  cable_cut_w = 10;
  cable_cut_wall = 0.5;
  cable_pos = 23;
  edge_1 = sqrt((carriage_hinge_d-tolerance_d)*(carriage_hinge_d-tolerance_d)/2);
  
  hinge_l = (rear_cut_l-length)/2+carriage_hinge_l;
  spacer_l = hinge_l-carriage_hinge_l;
  
  //Hinge caps
  for(i=[0:1:1]){
    translate([length/2+20+i*12, 0, body_wall/2]){
      difference(){
        union(){
          cube(size=[7, carriage_hinge_d*2, body_wall], center=true);
          translate([0, carriage_hinge_d, 0]){
            cylinder(d=7, h=body_wall, center=true);
          }
          translate([0, -carriage_hinge_d, 0]){
            cylinder(d=7, h=body_wall, center=true);
          }
          translate([(7-body_wall)/2,
                     0,
                    (carriage_hinge_z-carriage_hinge_d/2-2+body_wall)/2]){
            cube(size=[body_wall,
                       carriage_hinge_d-tolerance_d,
                       carriage_hinge_z-carriage_hinge_d/2-2], center=true);
          }
          
        }
        translate([0, carriage_hinge_d, 0]){
          cylinder(d=M3_hole, h=body_wall*1.1, center=true);
        }
        translate([0, -carriage_hinge_d, 0]){
          cylinder(d=M3_hole, h=body_wall*1.1, center=true);
        }
      }
    }
  }
  
  translate([0, 0, body_wall/2]){
    cube(size=[length, body_w, body_wall], center=true);
  }
  translate([(length-servo_m_l)/2, 0, body_wall+servo_w/2]){
    difference(){
      cube(size=[servo_m_l, body_w, servo_w], center=true);
      translate([0, body_w/2, servo_m_d/2]){
        rotate([90, 0, 0]){
          cylinder(d=servo_m_hole, h=20, center=true);
        }
      }
      translate([0, body_w/2, -servo_m_d/2]){
        rotate([90, 0, 0]){
          cylinder(d=servo_m_hole, h=20, center=true);
        }
      }
      translate([0, -body_w/2, servo_m_d/2]){
        rotate([90, 0, 0]){
          cylinder(d=servo_m_hole, h=20, center=true);
        }
      }
      translate([0, -body_w/2, -servo_m_d/2]){
        rotate([90, 0, 0]){
          cylinder(d=servo_m_hole, h=20, center=true);
        }
      }
    }
  }
  translate([-(length-servo_m_l)/2, 0, body_wall+servo_w/2]){
    difference(){
      cube(size=[servo_m_l, body_w, servo_w], center=true);
      translate([cable_cut_wall, body_w/2-cable_pos-cable_cut_w/2, 5]){
        cube(size=[servo_m_l, cable_cut_w, servo_w], center=true);
      }
      translate([cable_cut_wall, -body_w/2+cable_pos+cable_cut_w/2, 5]){
        cube(size=[servo_m_l, cable_cut_w, servo_w], center=true);
      }

      translate([0, body_w/2, servo_m_d/2]){
        rotate([90, 0, 0]){
          cylinder(d=servo_m_hole, h=20, center=true);
        }
      }
      translate([0, body_w/2, -servo_m_d/2]){
        rotate([90, 0, 0]){
          cylinder(d=servo_m_hole, h=20, center=true);
        }
      }

      translate([0, -body_w/2, servo_m_d/2]){
        rotate([90, 0, 0]){
          cylinder(d=servo_m_hole, h=20, center=true);
        }
      }
      translate([0, -body_w/2, -servo_m_d/2]){
        rotate([90, 0, 0]){
          cylinder(d=servo_m_hole, h=20, center=true);
        }
      }
    }
  }

  //Hinges  
  translate([-tolerance_l, 0, 0]){
    translate([length/2+hinge_l/2, 0, carriage_hinge_z]){
      rotate([0, 90, 0]){
        cylinder($fn=4, d=carriage_hinge_d-tolerance_d, h=hinge_l, center=true);
      }    
      difference(){
        rotate([0, 90, 0]){
          cylinder(d=carriage_hinge_d-tolerance_d, h=hinge_l, center=true);
        }
        translate([0, 0, -carriage_hinge_d/2]){
          cube(size=[hinge_l*1.1, edge_1*2, carriage_hinge_d], center=true);
        }
      }    
    }
    translate([length/2+spacer_l/2, 0, carriage_hinge_z]){
      rotate([0, 90, 0]){
        cylinder(d1=carriage_hinge_d+10, d2=carriage_hinge_d+5, h=spacer_l, center=true);
      }    
    }
    translate([length/2+6, 1.7, 0]){
      rotate([0, 0, 270]){
        bridge_post(carriage_hinge_z-(carriage_hinge_d-tolerance_d)/2, 3.5);
      }    
    }
  }

  mirror([1, 0, 0]){
    translate([-tolerance_l, 0, 0]){
      translate([length/2+hinge_l/2, 0, carriage_hinge_z]){
        rotate([0, 90, 0]){
          cylinder($fn=4, d=carriage_hinge_d-tolerance_d, h=hinge_l, center=true);
        }    
        difference(){
          rotate([0, 90, 0]){
            cylinder(d=carriage_hinge_d-tolerance_d, h=hinge_l, center=true);
          }
          translate([0, 0, -carriage_hinge_d/2]){
            cube(size=[hinge_l*1.1, edge_1*2, carriage_hinge_d], center=true);
          }
        }    
      }
      translate([length/2+spacer_l/2, 0, carriage_hinge_z]){
        rotate([0, 90, 0]){
          cylinder(d1=carriage_hinge_d+10, d2=carriage_hinge_d+5, h=spacer_l, center=true);
        }    
      }
      translate([length/2+6, 1.7, 0]){
        rotate([0, 0, 270]){
          bridge_post(carriage_hinge_z-(carriage_hinge_d-tolerance_d)/2, 3.5);
        }    
      }
    }
  }
    
}


module bridge_post(height, width=6, brim_w=10, brim_l=6, link=0){
  edge=4;
  tip=edge;
  tip_w = 0.2;
  brim_h = 0.3;
  socket_h = body_wall;
  
  x1=edge/2;
  y1=0;
  x2=edge/2;
  y2=height-tip;
  x3=-width;
  y3=height-tip;
  x4=-edge/2;
  y4=socket_h;
  x5=-edge/2;
  y5=0;
  
  translate([edge/2, 0, brim_h/2]){
    cube(size=[brim_w, brim_l, brim_h], center=true);
  }
  
  rotate([90, 0, 90]){
    linear_extrude(height=edge){
      polygon(points=[[x1,y1],[x2,y2],[x3,y3],[x4,y4],[x5,y5]]);
    }
  }
  
  if(link>0){
    translate([link/2, 0, height/2]){
      cube(size=[link, edge/2, 2], center=true);
    }
  }
  
  x1t=edge/2;
  y1t=0;
  x2t=0;
  y2t=edge;
  x3t=-edge/2;
  y3t=0;
  
  translate([edge/2, edge/2, height-tip]){
    rotate([90, 0, 0]){
      linear_extrude(height=edge/2+width){
        polygon(points=[[x1t,y1t],[x2t,y2t],[x3t,y3t]]);
      }
    }    
  }

  translate([edge/2, -(width-edge/2)/2, height-tip/2]){
    cube(size=[tip_w, width+edge/2, tip], center=true);    
  }

}

module mechanum_wheel(mirror = 0){
  rolls = 11;
  roll_d = 20;
  roll_h = 3;
  roll_h_2 = 4.5;
  roll_axis_d = 2;
  roll_axis_hole = 2.2;
  roll_axis_d_2 = roll_axis_d + 2;
  cut_w = roll_h_2 + 0.5;
  cut_d = roll_d + 5;
  knob_h = 1;
  w_d = 50;
  w_d2 = w_d + 5.2;
  w_h = 8;
  w_hole = 3;
  w_hole_2 = 5.5;
  w_hole_3 = 10;
  first_layer = 0.3;

  roll_axis_l = sqrt(2*w_h*w_h);
  
  support_w = 0.2;


  //Center part
  mirror([0, mirror, 0]){
    translate([0, 0, w_h/2]){
      difference(){
        cylinder($fn=300, d=w_d2, h=w_h, center=true);
        cylinder(d=w_hole, h=w_h*1.1, center=true);
        translate([0, 0, w_h-2]){
          cylinder(d=w_hole_2, h=w_h, center=true);
        }
        translate([0, 0, -w_h/2-0.1]){
          linear_extrude(height=w_h-2, scale=w_hole/w_hole_3){
           circle(d=w_hole_3, center=true);
          }
        }
        for(i=[0:1:rolls-1]){
          rotate([45, 0, i*360/rolls]){
            translate([w_d/2, 0, 0]){
              difference(){
                cylinder(d=cut_d, h=cut_w, center=true);
                difference(){
                  union(){
                    translate([0, 0, -cut_w/2+knob_h/2]){
                      cylinder(d1=roll_axis_d+3, d2=roll_axis_hole, h=knob_h, center=true);
                    }
  //                  translate([0, 0, cut_w*(1/4+1/6)]){
  //                    cylinder(d2=roll_axis_d+4, d1=0, h=cut_w/3, center=true);
  //                  }
                  }
                  //cylinder(d=roll_axis_d+4, h=roll_h+1, center=true);
                }
              }
              translate([0, 0, cos(3.1415/4)*roll_axis_hole/2+first_layer]){
                cylinder(d=roll_axis_hole, h=roll_axis_l, center=true);
              }
            }
          }
        }
      }
    }
  }

/*
  //rolls
  for(i=[0:1:rolls-1]){
    rotate([0, 0, i*360/rolls]){
      translate([40, 0, roll_h/2]){
        rotate_extrude(convexity = 10){
          translate([roll_d/2-roll_h/2, 0, 0]){
            rotate([0, 0, 0*180/8]){
              circle(d = roll_h);    
            }
          }
        }
        difference(){
          union(){
            cylinder(d=roll_d-roll_h, h=roll_h, center=true);
            mirror([0,0,1]){            
              translate([0, 0, -roll_h_2/2]){
                linear_extrude(height=roll_h_2/2, scale=2){
                  circle(d=roll_axis_d_2, center=true);
                }
              }
            }
            
//            translate([0, 0, -roll_h_2/2]){
//              linear_extrude(height=roll_h_2/2, scale=2){
//                circle(d=roll_axis_d_2, center=true);
//              }
//            }
            //cylinder(d=roll_axis_d_2, h=roll_h_2, center=true);
          }
          cylinder(d=roll_axis_d, h=roll_h_2*1.1, center=true);
          translate([0, 0, -roll_h/2+first_layer/2]){
            cylinder(d=roll_axis_d+0.3, h=first_layer*1.1, center=true);
          }
        }
        
      }
    }
  }
*/  
}