// Direct granules extruder Project V5.3
// More on: www.HomoFaciens.de

$fn = 100;

M3_hole = 3.5;
M3_nut_e = 6.3;
M4_hole = 4.5;
M5_hole = 5.5;
M6_hole = 6.5;
M5_nut_e = 8.79 + 0.3;
M6_nut_e = 11.05 + 0.3;
M8_nut_e = 14.38+1.5;
M12_nut_e = 21.3 + 1.0;
M12_hole = 12.5;

// Ball bearings
bb8_do = 22 + 0.5;
bb8_h = 7;

bb10_do = 30 + 0.5;
bb10_h = 9;

//linear bearings
lm8uu_do = 15;
lm8uu_l = 24;

lm10luu_do = 19 + 0.5;
lm10luu_l = 55;

// Stepper motor
motor_e = 42;
motor_l = 40;
motor_m = 31;
motor_shaft = 5.5;
motor_shaft_shift = 4.9;

gear_mnt_X = sqrt(28*28/2);
gear_mnt_Y = sqrt(28*28/2);
motor_mnt_X = 25; 
motor_mnt_Y = 12.5*0;


// Mount grid
mg_dis = 15;
mg_d = 5.2;

// hotend mount holes
hot_m_d = 3;
hot_m_dis = 28;

// Copper pipe dimensions
cp_d = 15;

// Heater cartridge dimensions
heater_d = 6;
heater_dis = 15;
heater_z_shift = -4;

// Temperature sensor dimensions
temperature_z_shift = 3;
temperature_x_shift = 8;
temperature_d = 2;  

// Cold end fan
fan_m_dis = 55;

// X rails dimensions
xa_bar_d = 8.2;
xa_bar_dis = 80;


// Force sensor dimensions
//fs_screw_dis1 = 15;
//fs_screw_dis2 = 40;
//fs_l = 80;
//fs_e = 13.5;

// Force sensor Nextruder mount screws
fs_screw_dis_h = 31;
fs_screw_dis_m = 32.5; //Stimmt's ?
fs_shift = 22;

// Feeder tube
ft_do=18.5;


// Hopper dimensions
h_h = 33;
h_h2 = 45;
h_wall = 2;
h_wall_b = 1;
h_wb = 60;
//h_l = 80;
h_lb = 44;
h_inner_cyl = 40;
// Hopper top mount screw distance
mnt_top_X = 40;
mnt_top_Y = 5;

// Hopper bottom mount screws
hbm_Y1 = 65;
hbm_Y2 = 75;
hbm_dis = hbm_Y2 - hbm_Y1;

// Hopper front door
hfd_screw_dis = h_wb + 10;
// Front feeding cone mount point
ffc_Y = 10;
  
// Feeding hole position
fhp_Z = 13;
fhp_angle = 70;
fhp_d1 = 19;
fhp_d2 = 25.5;

// Top cone screws
tc_screw_dis = 40;

// Magnet dimensions
mag_d = 6.5; // with 0.5mm tolerance
mag_h = 5;
mag_X1 = (h_inner_cyl + mag_d)/2 + 1;
mag_Y1 = 0;
mag_X2 = mag_X1;
mag_Y2 = 10;
mag_X3 = mag_X1;
mag_Y3 = -10;


cut = 0;
assembled = 0;

if (assembled){
  difference(){
    union(){
      hopper();

      if(0)
      translate([0, -22, 16.5])
      rotate([90, 0, 0])
      hopper_front_door();

      translate([0, -24, 16.5])
      rotate([90, 0, 0])
      hopper_front_door_cone();
      
      translate([0, 76, -24.0])
      rotate([0, 0, 90])
      hopper_rear_mount();

      
      translate([0, 0, h_h+5])
      rotate([0, 0, 180])
      motor_plate();
      
//      if(0)
      translate([0, 0, -7])
      rotate([0, 0, -90])
      water_cooling(); // cooling
      
      translate([0, 50, 30])
      rotate([90, 0, 0])
      extruder_mount(0);
      
//      if(0)
      translate([0, 30, 30])
      rotate([90, 0, 180])
      extruder_mount(1);
      
      
      translate([0, 7.5, 92])
      rotate([0, 0, 180])
      stepper_clamp();

      translate([59, 6.5, 46])
      rotate([180, 0, -90])
      fan_mount();
      
//      translate([-7, 50, 110])
//      rotate([-90, 0, 180])
//      cable_mount();
      
//      translate([0, 70, -25])
//      force_sensor_mount();
      
//      translate([0, 8, 56])
//      rotate([0, 180, 180])
//      hopper_top_mount();
      
//      translate([-34, 12, 105])
//      rotate([-90, 0, -90])
//      force_sensor_nextruder();
      
    }
    if(cut == 1){
      translate([0,25,0]){
        cube(size=[100,50,200], center=true);
      }
    }
  }
}
else{
  difference(){
    union(){
//      extruder_mount(0);  // Rear part
//      extruder_mount(1);  // Front part
//      hopper(); // Hopper
//      motor_plate();
//      water_cooling();
//      hopper_front_door();
//      hopper_front_door_cone();
//      hopper_rear_mount();
//      stepper_clamp();

//      fan_mount();
//      fan_nozzle();

//      X_Axis(0); // Right
//      X_Axis(1); // Left
//      Z_bar_mount();  // Left
//      mirror([1,0,0])Z_bar_mount();  // Right
//      feeder_cone_mount();
//      top_cone(0);
//      top_cone(1);
//      top_cone(2);
//      top_cone(3);
//      top_cone_mount(); // Right
      mirror([0, 1, 0])top_cone_mount(); // Left


      
//      feeder_cone();
//      feeder_tube_mount();
//      loveboard_mount();
//      hopper_top_mount();
//      force_sensor_nextruder();
//      cable_mount();
//      tray_cone();
//      hopper_mount();
//      stirrer();
//      translate([30, 0, 0])force_sensor_mount();
//      coldend_vice();
//      hotend_vice();

//      translate([-20, -30, 0])cube(size=[10,35,10], center=true);
//    translate([0, 56.5, 40])rotate([0, 0, 90])feeder_tube_mount();
    }
    if(cut == 1){
      translate([0,25,0]){
        cube(size=[100,50,200], center=true);
      }
    }
  }
}

module feeder_tube_mount(){
  feeder_tube_pivot_mount(19.0, 18.0);
  translate([0, 23, 0])feeder_tube_pivot_mount(17.0, 16.0);
}

module top_cone_mount(){
  tcm_h1 = 70;
  tcm_h2 = 20;
  tcm_w = 20;
  tcm_l1 = 80;
  tcm_l2 = 20;
  tcm_wall1 = 2;
  tcm_wall2 = 10;
  
  cut_w = 5;
  cut_l = 15;
  cut_Y = 10-tcm_h1/2;
  cut_X = (cut_l-tcm_l2)/2-0.1;
  
  // Clamp screw pos
  cs_X = -3;
  
  // Cone mount screws pos
  cms_X1 = tcm_l1-tcm_l2/2-15;
  cms_X2 = cms_X1-tc_screw_dis;
  cms_Y = (tcm_h1-tcm_wall1)/2;
  cms_Z = 15;

  difference(){
    union(){
      hull(){
        roundedRect([tcm_l2, tcm_h1, tcm_wall1], 2);
        translate([(tcm_l1-tcm_l2)/2, (tcm_h1-tcm_wall2)/2, 0])
        roundedRect([tcm_l1, tcm_wall2, tcm_wall1], 2);
      }
      roundedRect([tcm_l2, tcm_h1, tcm_w], 2);
      translate([(tcm_l1-tcm_l2)/2, (tcm_h1-tcm_wall2)/2, 0])
      roundedRect([tcm_l1, tcm_wall2, tcm_w], 2);      
    }
    
    // Cone mount screws
    translate([cms_X1, cms_Y, cms_Z])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=20, center=true);
      translate([0, 0, 11])
      cylinder(d=M3_nut_e, h=20, center=true, $fn=6);
    }
    translate([cms_X2, cms_Y, cms_Z])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=20, center=true);
      translate([0, 0, 11])
      cylinder(d=M3_nut_e, h=20, center=true, $fn=6);
    }
    
    // Clamp cut
    translate([cut_X, cut_Y, -0.05])
    roundedRect([cut_l, cut_w, tcm_w+0.1], 2, [0,1,0,1]);
    
    // Clamp screw cut
    translate([cs_X, cut_Y, tcm_w/2])
    rotate([90, 0, 0]){
      translate([0, 0, 10])
      cylinder(d=M3_hole, h=20, center=true);
      translate([0, 0, cut_w/2])
      cylinder(d=M3_nut_e, h=8, center=true, $fn=6 );
    }
    
  }
}


module top_cone(type = 0){
  tc_wall = 2;
  tc_wall2 = 1.4;
  tc_dt = 180;
  tc_db = 20;
  tc_d_out = 10;
  tc_d_out2 = 28;
  tc_d_out3 = 6;
  tc_do_1 = tc_d_out3 + 2*tc_wall2;
  tc_do_2 = tc_d_out2 + 2*tc_wall2;
  tc_h = 120;
  tc_h2 = 55;
  tc_socket_d = 70;
  
  lid_h = 20;
  tc_open_d = 40;
  tc_open_X = 55;
  
  // Bottom part
  if(type == 0)
  difference(){
    union(){
      translate([0, 0, tc_wall/2])
      cylinder(d=tc_socket_d, h=tc_wall, center=true);
      translate([0, 0, tc_h2/2])
      cylinder(d1=tc_do_2, d2=tc_do_1, h=tc_h2, center=true);
    }

    // Center cut
    translate([0, 0, tc_h2/2])
    cylinder(d1=tc_d_out2, d2=tc_d_out3, h=tc_h2+0.1, center=true);

    // Mount screws on frame
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([tc_screw_dis/2, tc_screw_dis/2, tc_wall/2])
    cylinder(d=M3_hole, h=tc_wall+0.1, center=true);
    
  }
  
  // Cone
  if(type == 1)
  difference(){
    union(){
      translate([0, 0, tc_h/2])
      cylinder(d1=tc_db, d2=tc_dt, h=tc_h, center=true);
      // Socket
      translate([0, 0, tc_wall/2])
      cylinder(d=tc_socket_d, h=tc_wall, center=true);
      // Enforcements
      for(i=[0:1:1])rotate([0, 0, i*90])
      translate([0, 0, tc_h/2])
      cubec([tc_socket_d, tc_wall, tc_h]);

      // Mount screws on frame
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0])
      translate([tc_screw_dis/2, tc_screw_dis/2, 2.5])
      cylinder(d1=13, d2=10, h=5, center=true);
    }
    
    // Outlet
    translate([0, 0, tc_wall/2])
    cylinder(d=tc_d_out, h=tc_wall*10.1, center=true);
    
    // Center cut
    translate([0, 0, tc_h/2+4])
    cylinder(d1=tc_db, d2=tc_dt, h=tc_h, center=true);
    
    // Mount screws on frame
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([tc_screw_dis/2, tc_screw_dis/2, 2.5]){
      cylinder(d=M3_hole, h=5.1, center=true);
      translate([0, 0, 2])
      cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
    }
    
  }
  
  // Lid
  if(type == 2)
  difference(){
    translate([0, 0, lid_h/2])
    hull(){
      cylinder(d=tc_dt+2*tc_wall+1, h=lid_h, center=true);
      // Clamp screw mounts
      for(i=[0:120:270])
      rotate([0, 0, i])
      translate([tc_dt/2+10, 0, 0])
      rotate([0, 90, 0])
      roundedRect([lid_h, lid_h, 0.1], 2);
    }
    
    // Center cut
    translate([0, 0, lid_h/2+tc_wall])
    cylinder(d=tc_dt+1, h=lid_h, center=true);

    // Clamp screw cuts
    for(i=[0:120:270])
    rotate([0, 0, i])
    translate([tc_dt/2+10, 0, lid_h/2])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=20, center=true);
      translate([0, 0, -7])
      cylinder(d=M3_nut_e, h=10.2, center=true, $fn=6);
    }

    // Mount holes stepper motor
    translate([0, 0, tc_wall/2])
    cylinder(d=23, h=tc_wall+0.1, center=true);
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_m/2, motor_m/2, tc_wall/2]){
        cylinder(d=M3_hole, h=tc_wall+0.1, center=true);
      }
    }

    // Holes opening
    translate([tc_open_X, 0, 2.5]){
      cylinder(d=tc_open_d, h=5.1, center=true);
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0]){
        translate([tc_open_d/2, tc_open_d/2, 0]){
          cylinder(d=M3_hole, h=5.1, center=true);
        }
      }
    }
  }
  
  // Lid cone
  lc_h = 30;
  lc_d2 = tc_open_d + 40;
  if(type == 3)
  difference(){
    union(){
      roundedRect([tc_open_d+20,tc_open_d+20,tc_wall], 5);
      a = tc_open_d+2*tc_wall;
      b = lc_d2+2*tc_wall;
      translate([0, 0, lc_h/2])
      cylinder(d1=a, d2=b, h=lc_h, center=true);

      // Mount points
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0]){
        translate([tc_open_d/2, tc_open_d/2, 2.5]){
          cylinder(d1=15, d2=10, h=5, center=true);
        }
      }
    }
    
    // Center cut
    translate([0, 0, lc_h/2])
    cylinder(d1=tc_open_d, d2=lc_d2, h=lc_h+0.1, center=true);

    // Mount holes
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([tc_open_d/2, tc_open_d/2, 2.5]){
        cylinder(d=M3_hole, h=5.1, center=true);
        translate([0, 0, 0.5])
        rotate([0, 0, 15])
        cylinder(d=M3_nut_e, h=4.05, center=true, $fn=6);
      }
    }

  }
}

module feeder_tube_pivot_mount(ft_d1 = 18.5, ft_d2 = 17.5){
  
  ftpm_wall = 2;
  ftpm_h = 10;
  ftpm_l = 15;
  
  difference(){
    union(){
      hull(){
        translate([0, 0, ftpm_h/2])
        cylinder(d=ft_d1+2*ftpm_wall, h=ftpm_h, center=true);
        translate([0, 0, ftpm_h/2])
        rotate([0, 90, 0])
        roundedRect([ftpm_h, ftpm_h, ftpm_l], 2);
      }
      translate([-ft_d1/2, 7.5, ftpm_h/2])
      rotate([90, 0, 0])
      roundedRect([14, ftpm_h, 15], 2);
    }

    // Center cut
//    translate([0, 0, ftm_h/2-2])
//    cylinder(d=ft_d1, h=ftm_h+0.1, center=true);
    translate([0, 0, ftpm_h/2])
    cylinder(d=ft_d2, h=ftpm_h+0.1, center=true);
    
    // Slit cut
    translate([-ft_d1/2, 0, ftpm_h/2])
    cubec([25, 5, ftpm_h+0.1]);
    // Slit screw cut
    translate([-ft_d1/2-2, 0, ftpm_h/2])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=25, center=true);
      translate([0, 0, -17])
      rotate([0, 0, 30])
      cylinder(d=M3_nut_e, h=25, center=true, $fn=6);
    }
    
    
    
    // Pivot screw cut
    translate([ftpm_l/2, 0, ftpm_h/2])
    rotate([0, 90, 0])
    rotate([0, 0, 30]){
      cylinder(d=M3_hole, h=ftpm_l+0.1, center=true);
      translate([0, 0, ftpm_l/2])
      cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
      translate([0, 0, 0])
      cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
    }
  }
  
}

module stepper_clamp(){
  sc_l = 75;
  sc_h1 = 10;
  sc_h2 = 30;
  sc_hs = 10;
  sc_w1 = 74;
  sc_w2 = 10;
  sc_e1 = 20;
  sc_e2 = 10;
  sc_e3 = 5;
  sc_e4 = 18;
  sc_wall = 2;
  sc_shift = (sc_e4 - sc_e2)/2;
  
  // Stepper motor clamp screws
  screw_step_shift = 49-sc_l/2;
  screw_step_dis = 25;
  
  
  // Mount screws on socket
  mss_dis = 20;
  
  // Mount grid on X axis
  mg_X1 = 27-0;
  mg_Y1 = 9.5/2;
  
  // love board mount dimensions
  lbm_l = sc_l-5;
  lbm_h = 55+25;
  lbm_s_Y = 26-sc_l/2;
  lbm_s_Z = 16;
  
  // Front bar dimensions /feeder pipe mount)
  fb_h = 10;
  fb_lm = 45;
  fb_l = 10;
  fb_w = sc_w1+20;
  fb_wall = 2;
  
  pivot_Y = fb_lm-5-fb_l/2;
  pivot_X = 5;
  
  
  // Wire clamp
  wc_l = 50;
  wc_h = 10;
  wc_w = 17;
  wc_screw_dis = 40;
  
//  if(0)
  for(i=[0:1:1])
  translate([0, -i*(wc_w+2)-sc_l/2-3+79*0, wc_h/2])
  rotate([90, 0, 0])
  difference(){
    roundedRect([wc_l, wc_h, wc_w], 3);
    translate([0, 0, wc_w/2+2])
    
    // Center cut
    translate([0, 2, 0])
    cubec([wc_l-20, wc_h, wc_w]);
    translate([0, 0, wc_w/2+5])
    cubec([wc_l-20, wc_h+0.1, wc_w]);
    
    // mount screw cuts
    for(i=[0:1:1])mirror([i,0,0])
    translate([wc_screw_dis/2, 0, wc_w/2]){
      cylinder(d=M3_hole, h=wc_w+0.1, center=true);
      translate([0, 0, -2])
      cylinder(d=M3_nut_e, h=wc_w, center=true, $fn=6);
    }
  }
  
  // Front bar
//  if(0)
  translate([0, sc_l/2+8, 0])
  difference(){
    union(){
      roundedRect([fb_w, fb_l, fb_h], 3);
      hull(){
        roundedRect([fb_w, fb_l, fb_wall], 3);
        translate([pivot_X, fb_lm-5-fb_l/2, fb_wall/2])
        cylinder(d=10, h=fb_wall, center=true);
      } 
      translate([pivot_X, pivot_Y, fb_l/4])
      cylinder(d=10, h=fb_l/2, center=true);
    }

    // Pivot point feeder pipe
    translate([pivot_X, pivot_Y, fb_l/2])
    cylinder(d=M3_hole, h=fb_l+0.1, center=true);
    translate([pivot_X, pivot_Y, fb_l/2])
    cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
    

    // Mount holes on hopper
    for(i=[0:1:1])mirror([i,0,0])
    translate([fb_w/2-5, 0, fb_l/2]){
      cylinder(d=M3_hole, h=fb_l+0.1, center=true);
      translate([0, 0, 2])
      cylinder(d=7, h=fb_l, center=true);
    }

    // Stepper adjust screw
    translate([pivot_X, 0, fb_l/2]){
      cylinder(d=M3_hole, h=fb_l+0.1, center=true);
      translate([0, 0, 5])
      cylinder(d=7, h=fb_l, center=true);
      translate([0, 0, 2])
      cylinder(d=M3_nut_e, h=fb_l, center=true, $fn=6);
    }
    
  }

  // Stepper motor clamp
//  if(0)
  difference(){
    union(){
      roundedRect([sc_w1, sc_l, sc_h1], 3, [0,0,0,0]);
      
/*      
      // Force sensor mount plate
      hull(){
        translate([(sc_w1-sc_wall)/2, fs_shift, sc_h2/2])
        cubec([sc_wall, fs_screw_dis_h+10, sc_h2]);
        
        translate([sc_w1/2-sc_wall, 3-sc_l/2, sc_h1-sc_wall])
        cube(size=[sc_wall, sc_wall, sc_wall]);
      }
      // Enforcements fore sensor mount
      translate([sc_w1/2-5, fs_shift, sc_h2/2])
      for(i=[0:1:1])mirror([0,i,0])
      translate([0, fs_screw_dis_h/2, 0])
      cubec([10, 10, sc_h2]);
*/
      
      // Love board mount (right plate)
      translate([(sc_wall-sc_w1)/2, 0, lbm_h/2])
      cubec([sc_wall, sc_l, lbm_h]);
      translate([-5-sc_w1/2, sc_l/2-5, 0])
      roundedRect([10, 10, lbm_h], 2, [1,0,1,0]);

      // Left plate
      translate([(sc_w1-sc_wall)/2, 0, lbm_h/2])
      cubec([sc_wall, sc_l, lbm_h]);
      translate([sc_w1/2+5, sc_l/2-5, 0])
      roundedRect([10, 10, lbm_h], 2, [0,1,0,1]);
      
      // rear plate
      translate([0, (sc_wall-sc_l)/2, lbm_h/2])
      cubec([sc_w1, sc_wall, lbm_h]);
    }
    
    // Love board mount hole
    translate([0, lbm_s_Y, lbm_s_Z])
    rotate([0, 90, 0])
    cylinder(d=M3_hole, h=sc_l*2.1, center=true);
    // Water hose or wires mount holes
    translate([0, sc_l/2-20, lbm_h/2])
    for(i=[0:1:1])mirror([0,0,i])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([0, 5, 10])
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=sc_l*2.1, center=true);
      translate([0, 5, 20])
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=sc_l*2.1, center=true);
    }
    
    // Cable mount holes
    translate([0, sc_l/2-20, lbm_h/2+5])
    for(i=[0:1:1])mirror([0,0,i])
    for(j=[0:1:1])mirror([j,0,0]){
      translate([20, 0, 30])
      rotate([90, 0, 0])
      cylinder(d=M3_hole, h=sc_l*2.1, center=true);
      translate([20, 0, 20])
      rotate([90, 0, 0])
      cylinder(d=M3_hole, h=sc_l*2.1, center=true);
    }
    
    
    // Front bar mount holes
    for(i=[0:1:1])mirror([i,0,0])
    translate([sc_w1/2+5, sc_l/2-10, 5])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=20.1, center=true);
      cylinder(d=M3_nut_e, h=16, center=true, $fn=6);
    }
    

    // Mount holes on X axis
    translate([sc_shift, -(sc_l-sc_e1)/2, 0])
    for(no=[0:1:3])
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([mg_X1-7*no, mg_Y1, sc_h1]){
      if(0)
      hull(){
        for(y=[0:1:1])mirror([0,y,0])
        translate([0, 0.7, 0]){
          cylinder(d=6.5, h=sc_h1*2-8, center=true);
        }
      }
      hull(){
        for(y=[0:1:1])mirror([0,y,0])
        translate([0, 0.7, 0]){
          cylinder(d=M3_hole, h=sc_h1*2.1, center=true);
        }
      }
    }


    // Mount holes on socket
    if(0)
    translate([0, -(sc_l-sc_e1)/2, 0])
    for(i=[0:1:1])mirror([i,0,0])
    translate([mss_dis/2, 0, 0]){
      cylinder(d=M3_hole, h=sc_h1*2.1, center=true);
      hull(){
        cylinder(d=M3_hole, h=sc_h1*2-4, center=true);
        cylinder(d=M3_nut_e, h=sc_h1*2-8, center=true, $fn=6);
      }
    }
    
    
    // Inner cut
    translate([sc_shift, (sc_e1-sc_e3)/2+10, -0.05]){
      a = sc_w1 - sc_e2 - sc_e4;
      b = sc_l - sc_e1 - sc_e3 + 20;
      roundedRect([a, b, sc_h1+0.1], 2);
      hull(){
        roundedRect([a, b, 2], 2);
        roundedRect([a+1, b+1, 0.1], 2);
      }
    }
    
    
    // Stepper clamp screws left/right
    translate([0, screw_step_shift, sc_h1/2])
    for(i=[-1:1:1])
    translate([0, i*screw_step_dis/2, 0])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=sc_w1+0.1, center=true);
      cylinder(d=M3_nut_e, h=sc_w1-6, center=true, $fn=6);
    }
    // Stepper clamp screws front
    translate([0, (sc_l-sc_e3)/2, sc_h1/2])
    for(i=[-1:1:1])
    translate([i*screw_step_dis/2, 0, 0])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=sc_e3+0.1, center=true);
      translate([0, 0, 2])
      cylinder(d=M3_nut_e, h=sc_e3, center=true, $fn=6);
    }
    
/*    
    // Fore sensor mount screws
    translate([10, fs_shift, sc_h2-5])
    for(i=[0:1:1])mirror([0,i,0])
    translate([0, fs_screw_dis_h/2, 0])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=sc_w1-10, center=true);
      cylinder(d=M3_nut_e, h=sc_w1-24, center=true, $fn=6);
    }
*/    
  }
  
}

module stirrer(){
  s_do = 25;
  s_di = 10.5;
  s_di2 = 7;
  s_h1 = 18;
  s_h2 = 8;
  
  difference(){
    union(){
      intersection(){
        cubec([s_do, 15, s_h2*2]);
        translate([0, 0, s_h2/2])
        cylinder(d=s_do, h=s_h2, center=true);
      }
      intersection(){
        translate([0, 0, s_h1/2])
        cylinder(d=s_do, h=s_h1, center=true);
        hull(){
          translate([0, 0, s_h2])
          cubec([s_do, 7, 0.1]);
          translate([0, 0, s_h1])
          cubec([s_do-15, 2, 0.1]);
        }
      }
    }
    
    // Center cut
    hull(){
      translate([0, 0, s_h2/2])
      cylinder(d=s_di, h=s_h2+6, center=true);
      translate([0, 0, s_h1])
      cylinder(d=7, h=0.1, center=true);
    }
    
    // mount screw cut
    translate([0, 0, 4])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=s_do+0.1, center=true);
      cylinder(d=M3_nut_e, h=17, center=true, $fn=6);
      
    }
  }
  
}


module force_sensor_nextruder(){
  fsn_l1 = 75;
  fsn_l2 = 47;
  fsn_l3 = 20;
  fsn_h1 = 18;
  fsn_h2 = 45;
  fsn_w = 12;
  fsn_wall = 2;
  
  // Mount screws force sensor
  screw_dis_X = 31;
  screw_dis_Y = 31;

  sf_X1 = fsn_l1/2 - 5;
  sf_Y1 = 5 - fsn_h2/2;
  
  sf_X2 = sf_X1 - screw_dis_X;
  sf_Y2 = sf_Y1;

  sf_X3 = sf_X2;
  sf_Y3 = sf_Y1 + screw_dis_Y;

  
  // Mount screws on X axis pos
  s_X1 = 5-fsn_l1/2;
  s_X2 = s_X1 + 9;
  s_Z = 8;
  
  difference(){
    roundedRect([fsn_l1, fsn_h2, fsn_w], 5, [1,1,0,1]);
    
    translate([fsn_l1-fsn_l2, 0, fsn_wall])
    roundedRect([fsn_l1, fsn_h2+0.1, fsn_w], 5, [0,0,0,0]);
    
    translate([fsn_l3-fsn_l1, -fsn_h1, -0.05])
    roundedRect([fsn_l1, fsn_h2+0.1, fsn_w+0.1], 5, [0,0,0,0]);
    
    // Mount screws force sensor
    translate([sf_X1, sf_Y1, fsn_w/2])
    cylinder(d=M3_hole, h=fsn_w+0.1, center=true);

    translate([sf_X2, sf_Y2, fsn_w/2])
    cylinder(d=M3_hole, h=fsn_w+0.1, center=true);

    translate([sf_X3, sf_Y3, fsn_w/2])
    cylinder(d=M3_hole, h=fsn_w+0.1, center=true);
    
    // Mount screws on X axis
    translate([s_X1, 0, s_Z])
    rotate([90, 0, 0])
    hull(){
      translate([1, 0, 0])
      cylinder(d=M3_hole, h=fsn_h2+0.1, center=true);
      translate([-1, 0, 0])
      cylinder(d=M3_hole, h=fsn_h2+0.1, center=true);
    }

    translate([s_X2, 0, s_Z])
    rotate([90, 0, 0])
    hull(){
      translate([1, 0, 0])
      cylinder(d=M3_hole, h=fsn_h2+0.1, center=true);
      translate([-1, 0, 0])
      cylinder(d=M3_hole, h=fsn_h2+0.1, center=true);
    }
  }
}

module hopper_top_mount(){
  htm_w1 = mnt_top_Y * 2 + 8;
  htm_w2 = mnt_top_Y * 2 - 8;
  htm_l = 40;
  htm_h = 23;
  
  screw_dis = 50;
  
  // Spring dimensions
  s_Y = -10;
  s_w1 = 10;
  s_w2 = 14;
  
  difference(){
    roundedRect([htm_w1, htm_l, htm_h], 5);
    translate([0, 5, -0.1])
    
    // center cut
    roundedRect([htm_w2, htm_l, htm_h+1], 5);
    
    // Spring cut
    hull(){
      translate([0, s_Y+(s_w2-s_w1)/2, htm_h])
      cubec([htm_w1+0.1, s_w2, 0.1]);
      translate([0, s_Y, 1])
      cubec([htm_w1+0.1, s_w1, 0.1]);
    }
    
    // Cut rear top
    translate([0, -htm_l/2, htm_h-4])
    roundedRect([htm_w1+20, 15, htm_h], 5);
    
    // Mount screws on X axis
    for(i=[0:1:1])mirror([i,0,0]){
      translate([screw_dis/2, 0, 5])
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=htm_l+0.1, center=true);
        cylinder(d=6.5, h=htm_l-4, center=true);
      }
      translate([screw_dis/2, 0, 15])
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=htm_l+0.1, center=true);
        cylinder(d=6.5, h=htm_l-4, center=true);
      }
    }    
    // Hopper mount screws
    for(i=[0:1:1])mirror([i,0,0]){
      translate([mnt_top_Y, htm_l/2-5, htm_h/2])
      cylinder(d=M3_hole, h=htm_h+0.1, center=true);

      translate([mnt_top_Y, htm_l/2-15, htm_h/2])
      cylinder(d=M3_hole, h=htm_h+0.1, center=true);
    }
    
  }
}


module loveboard_mount(){
  lbm_l1 = 70;
  lbm_l2 = 20;
  lbm_h = 50;
  lbm_wall = 2;
  lbm_screw_X = 25.5 - lbm_l1/2;
  lbm_screw_Y = 15 - lbm_h/2;
  
  enforce_h = 5;
  
  //mount dimensions
  m_l = 19;
  m_w = 10;
  m_h = 20;

  difference(){
    union(){
      translate([0, m_w-2, 0]){
        roundedRect([lbm_l1, lbm_h, lbm_wall], 5, [0,0,1,1]);
        translate([0, (lbm_wall-lbm_h)/2, enforce_h/2])
        cubec([lbm_l1, lbm_wall, enforce_h]);
      }

      translate([-(lbm_l1-m_l)/2, (m_w-lbm_h)/2, m_h/2])
      cubec([m_l, m_w, m_h]);

    }
    
    // Mount screws 
    translate([lbm_screw_X, lbm_screw_Y, lbm_wall/2])
    cylinder(d=M3_hole, h=lbm_wall+0.1, center=true);
    
    // Mount screws on X axis
    translate([4-lbm_l1/2, (m_w-lbm_h)/2, m_h-3])
    rotate([90, 0, 0])
    hull(){
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
      translate([1, 0, 0])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
    }

    translate([9.5+4-lbm_l1/2, (m_w-lbm_h)/2, m_h-3-7])
    rotate([90, 0, 0])
    hull(){
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
      translate([1, 0, 0])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
    }
  }
    
  
}

module cable_mount(){
  cm_l = 7*6 - 2;
  cm_w = 8;
  cm_h = 15;
  cm_h2 = 25;
  cm_wall = 2;
  cm_enforce = 4.5;
  screw_dis = 7 * 4;

  // clamps
  c_l = 19;
  c_w = 8;
  c_h = 3;
  translate([0, -15, 0])
  difference(){
    roundedRect([c_l, c_w, c_h], c_w/2);
    
    for(i=[0:1:1])mirror([i,0,0])
    translate([4.5, 0, c_h/2]) 
    cylinder(d=M3_hole, h=c_h+0.1, center=true);
  }

  // Main part
//  if(0)
  difference(){
    union(){
      translate([0, 0, cm_wall/2])
      cubec([cm_l, cm_h, cm_wall]);
      
      translate([0, (cm_h-cm_wall)/2, cm_enforce/2])
      cubec([cm_l, cm_wall, cm_enforce]);
      
      for(i=[0:1:1])mirror([i,0,0])
      translate([cm_l/2, -(cm_h2-cm_h)/2, cm_w/2])
      rotate([90, 0, 0])
      cylinder(d=cm_w, h=cm_h2, center=true);
      
      brim_d = 10;
      brim_h = 0.35;
      for(i=[0:1:1])mirror([i,0,0])
      translate([cm_l/2, -cm_h2+cm_h/2, brim_h/2])
      cylinder(d=brim_d, h=brim_h, center=true);
      
    }

    for(i=[0:1:1])mirror([i,0,0])
    translate([cm_l/2, 0, cm_w/2])
    rotate([90, 0, 0])
    cylinder(d=M3_hole, h=cm_h2*2.1, center=true);
  }
}

module tray_cone(){
  tc_l = 24;
  tc_l2 = 20;
  tc_w = 28;
  tc_w2 = 30;
  tc_h = 40;
  tc_wall = 2;
  tc_shift = -4.8;
  
  fh_X = 3.85;
  holes_shift_X = -2;
  
  pivot_X = -37;
  pivot_Y = 9;
  
  
  difference(){
    union(){
//      roundedRect([tc_l, tc_w, tc_wall], 2, [0,1,0,1]);

      // Cone mount points
//      for(j=[0:1:1])mirror([0,j,0])
//      translate([holes_shift_X-cmp_Z, cmp_X, 6.5])
//      rotate([0, 0, 0]){
//        cylinder(d=7, h=13, center=true);
//      }

      translate([tc_shift, 0, 0])
      hull(){
        translate([-35, 0, tc_h/2])
        cubec([0.1, tc_w2, tc_h]);
        // Feeding hole
        translate([fh_X-holes_shift_X, 0, 0])
        intersection(){
          roundedRect([tc_l*1.1, tc_w*1.1, tc_h-27.5], 2);
          rotate([0, fhp_angle-90, 0])
          translate([0, 0, -25])
          roundedRect([fhp_d1+2,fhp_d2+2,50], 1);
        }
      }
    }

    // Pivot point
    translate([pivot_X, pivot_Y, tc_wall/2])
    cylinder(d=M3_hole, h=tc_wall+10.1, center=true);
    
    // Cone mount points
//    for(j=[0:1:1])mirror([0,j,0])
//    translate([holes_shift_X-cmp_Z, cmp_X, 0])
//    rotate([0, 0, 0]){
//      cylinder(d=3, h=40, center=true);
//    }

    // Inner cut
    translate([tc_shift, 0, 0])
    hull(){
      a = 2* tc_wall;
      translate([-36, 0, tc_h/2])
      cubec([0.1, tc_w2-a, tc_h-a]);
      // Feeding hole
      translate([fh_X-holes_shift_X, 0, 0])
      intersection(){
        translate([0, 0, tc_wall])
        roundedRect([tc_l*1.1, tc_w*1.1, tc_h-29.7], 2);
        rotate([0, fhp_angle-90, 0])
        translate([-1.7, 0, -25])
        roundedRect([fhp_d1,fhp_d2,50], 1);
      }
    }
    // Feeding hole
    translate([tc_shift+fh_X-holes_shift_X, 0, tc_wall/2])
    intersection(){
      translate([0, 0, -tc_wall])
      roundedRect([tc_l*1.1, tc_w*1.1, tc_wall*1.6], 2);
      rotate([0, fhp_angle-90, 0])
      translate([-2, 0, -25])
      roundedRect([fhp_d1,fhp_d2,50], 1);
    }

  }
}


module motor_plate(){
  mp_w = 42;
  mp_w1 = 47;
  mp_l = 2 * motor_mnt_X + 10;
  mp_h = 10;
  mp_h2 = 25;
  mp_wall = 2;
  
  difference(){
    
    
    union(){
      roundedRect([mp_l, mp_w, mp_h], 2.5);
      
      // Front 'flaps'
      for(i=[0:1:1])mirror([i,0,0])
      translate([mp_l/2-2.5, (mp_w1-mp_w)/2, 0])
      roundedRect([5, mp_w1, 5], 2.5);
      
      // enforcements
      difference(){
        intersection(){
          roundedRect([mp_l, mp_w, mp_h2], 2.5);
          translate([0, 0, -15])
          rotate([90, 0, 0])
          cylinder(d=80, h=mp_w, center=true);
        }
        roundedRect([mp_l*2, mp_w-10, mp_h2], 2.5, [0,0,0,0]);
        
      }
      
    }
    
    // xenter cut
    translate([0, 0, mp_h/2])
    cylinder(d=20, h=mp_h+1, center=true);

    translate([0, 0, mp_h/2+2])
    cylinder(d=23, h=mp_h, center=true);

    translate([0, 0, mp_h2/2+5])
    cylinder(d=38, h=mp_h2, center=true);
    
    // Mount holes on hopper
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_X, motor_mnt_Y/2, mp_h/2]){
        cylinder(d=M3_hole, h=mp_h+0.1, center=true);
      }
    }
    
    // Mount holes stepper motor (gearbox)
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([gear_mnt_X/2, gear_mnt_Y/2, mp_h/2]){
        cylinder(d=M3_hole, h=mp_h+0.1, center=true);
//        translate([0, 0, (3-mp_h)/2])
//        cylinder(d2=M3_hole, d1=6, h=3.1, center=true);
      }
    }
    
    
  }
}

module feeder_cone_mount(){
  
  // Clamp screw on frame
  cs_X = 3;
  
  fcm_h = 20;
  fcm_w = 20;
  fcm_l = 25;
  fcm_h2 = 40;

  fcm_cut_X = 10;
  fcm_cut_Y = 3.2;
  fcm_cut_w = 5;
  
  pivot_Y = -4;
  
  ring_do = 25;
  ring_di = ft_do;
  ring_h = 15;
  ring_shift = 18;
  
  // Tube guide ring
  if(0)
  translate([0, 25, 0])
  difference(){
    hull(){
      translate([0, 0, ring_h/2])
      cylinder(d=ring_do, h=ring_h, center=true);
      translate([ring_shift, 0, ring_h/2])
      rotate([0, 90, 0])
      roundedRect([ring_h, ring_h, 0.1], 2);
    }

    // Center cut
    translate([0, 0, ring_h/2])
    cylinder(d=ring_di, h=ring_h+0.1, center=true);
    
    // Mount screw hole
    translate([0, 0, ring_h/2])
    rotate([0, 90, 0]){
      cylinder(d=6.5, h=ring_di+8, center=true);
      cylinder(d=M3_hole, h=ring_do*2.1, center=true);
      translate([0, 0, ring_shift])
      cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
    }
    
  }
  
  // Clamp
  difference(){
    union(){
      roundedRect([fcm_l, fcm_h, fcm_w], 2.5);
    }
    
    // Slit cut
    translate([fcm_cut_X, fcm_cut_Y, -0.05])
    roundedRect([fcm_l, fcm_cut_w, fcm_w+0.1], 2);
    
    // clamp screw
    translate([cs_X, fcm_h/2, fcm_w/2])
    rotate([90,0,0]){
      cylinder(d=M3_hole, h=10, center=true);
      translate([0, 0, 4])
      cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
    }
    
    // Pivot screw
    translate([0, pivot_Y, fcm_w/2])
    rotate([0,90,0]){
      cylinder(d=M3_hole, h=fcm_l+0.1, center=true);
      translate([0, 0, -fcm_l/2])
      cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
      translate([0, 0, 15])
      cylinder(d=M3_nut_e, h=fcm_l, center=true, $fn=6);
    }
    
    
  }
  
}


module feeder_cone(){  
  fc_di = 16.5;
  fc_wall = 2;
  fc_db = ft_do+2*fc_wall;
  fc_dt = 70;
  fc_h = 50;
  fc_shaft = 20;
  
  
  
  difference(){
    union(){
      translate([0, 0, fc_h/2])
      cylinder(d1=fc_dt, d2=fc_db, h=fc_h, center=true);
      translate([0, 0, fc_h+fc_shaft/2])
      cylinder(d=fc_db, h=fc_shaft, center=true);
    }
      a = 2*fc_wall;
      translate([0, 0, fc_h/2-0.05])
      cylinder(d1=fc_dt-a, d2=fc_db-a-2, h=fc_h, center=true);
      translate([0, 0, fc_h+fc_shaft/2])
      cylinder(d=fc_di, h=fc_shaft*1.5, center=true);
      translate([0, 0, fc_h+fc_shaft/2+10])
      cylinder(d=ft_do, h=fc_shaft*1.5, center=true);
  }
}


module feeder_tube_mount(){
  ftm_l1 = 22;
  ftm_l2 = 27;
  ftm_l3 = 30;
  ftm_h = 10;
  ftm_w1 = 14;
  ftm_w2 = 8;
  ftm_wi = 10;
  ftm_wall = 2;
  
  screw_X = 14;
  
  difference(){
    union(){
      roundedRect([ftm_l1, ftm_w1, ftm_h], 1);
      translate([(ftm_l1-ftm_l2)/2, 0, 0])
      roundedRect([ftm_l2, ftm_w2, ftm_wall], 1);
      translate([(ftm_l3-ftm_l1)/2, 0, 0])
      roundedRect([ftm_l3, ftm_w1, ftm_wall], 1);
    }
    // Center cut
    a = 2 * ftm_wall;
    translate([0, 0, -0.05])
    difference(){
      roundedRect([ftm_l1-a, ftm_wi, ftm_h+0.1], 1);
      // Center grid
      for(i=[0:1:1])mirror([i, 0, 0])
      translate([4, 0, 0])
      cubec([2, ftm_w1, 8]);
    }
    
    // Mount screw hole
    translate([screw_X, 0, ftm_wall/2])
    cylinder(d=M3_hole, h=ftm_wall+0.1, center=true);
    
  }
  
}


module fan_mount(){

  fm_w = 30;
  fm_l = 54;
  fm_alpha = -50;
  fm_beta = 0;
  fm_wall = 4;  
    
  
  fm_screw_dis = 44;
  
  // Fan mount flap on hopper
  fmh_l = 65;
  fmh_w = 15;
  
  shift_X = 29;
  shift_Y = 16;
  
  // Magnet screw pos
  msp_X = -6;
  msp_Y = 3;
  msp_Z = 26;
  
  // Hinge screw dimensions and pos
  hs_X = 5-fmh_l/2 + shift_X;
  hs_Y = 2.5 + shift_Y;
  hs_h = 15;
  hs_d = 10;
  
  difference(){
    union(){
      // Lever
      translate([shift_X, shift_Y, 0])
      roundedRect([fmh_l, fmh_w, fm_wall],2);
      
      // Magnet screw mount
      hull(){
        translate([msp_X+shift_X, msp_Y+shift_Y, msp_Z])
        rotate([90, 0, 0])
        cylinder(d=15, h=fm_wall*2, center=true);
        translate([msp_X+shift_X, msp_Y+shift_Y, fm_wall/2])
        cubec([25, fm_wall*2, 0.1]);
      }

      // Hinge screw socket
      translate([hs_X, hs_Y, hs_h/2])
      cylinder(d=hs_d, h=hs_h, center=true);

      
      
      // Mount plate fan
      translate([fmh_l/2, 0, 0])
      rotate([0, fm_beta, fm_alpha])
      translate([0, 16, fm_w/2])
      rotate([0, 90, 0])
      difference(){
        roundedRect([fm_w, fm_l, fm_wall], 5);
        for(i=[0:1:1])mirror([0,i,0])
        translate([-9.5, fm_screw_dis/2, fm_wall/2])
        hull(){
          cylinder(d=M3_hole, h=fm_wall+0.1, center=true);
          translate([14, 0, 0])
          cylinder(d=M3_hole, h=fm_wall+0.1, center=true);
        }
      }

    }
    
    // Magnet screw hole
    translate([msp_X+shift_X, msp_Y+shift_Y, msp_Z])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=fm_wall*2+0.1, center=true);
      translate([0, 0, 5.0])
      cylinder(d=M3_nut_e, h=fm_wall*2, center=true, $fn=6);
    }
    
    
    // make bottom flat
    translate([0, 0, -5])
    cube(size=[200, 200, 10], center=true);
    
    // cut tip
    translate([62.06, 0, 0])
    rotate([0, fm_beta, fm_alpha])
    rotate([0, -90, 0])
    roundedRect([fm_w, fm_l*2, 15], 5);
    
    // Mount screws on hopper
    
      translate([hs_X, hs_Y, hs_h/2]){
        cylinder(d=M3_hole, h=hs_h+0.1, center=true);
        translate([0, 0, hs_h/2])
        cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
        translate([0, 0, -hs_h/2])
        hull(){
          cylinder(d=M3_hole, h=8, center=true);
          cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
        }
      }
//      translate([20-fmh_l/2, 3.5, fm_wall/2])
//      cylinder(d=M3_hole, h=fm_wall+0.1, center=true);
    
  }
}

module fan_nozzle(){
  fn_li = 50+0.2;
  fn_wi = 10+0.5;
  fn_wall1 = 2;
  fn_wall2 = 1;
  fn_l1 = fn_li + 2 * fn_wall1;
  fn_w1 = fn_wi + 2 * fn_wall1;
  fn_l2 = 35;
  fn_w2 = 30;
  fn_h1 = 15;
  fn_h2 = 7;
  fn_h3 = fn_h2 - 2 * fn_wall2;
  fn_h4 = fn_h2 - 3.5;
  fn_h5 = fn_h4 - 2 * fn_wall2;
  fn_shift_X = 0;
  fn_shift_Y = 65;
  fn_angle = 10;
  
  translate([0, 0, fn_h1/2])
  difference(){
    union(){
      // Top box
      translate([0, -sin(fn_angle)*fn_h1/2, 2.4])
      rotate([fn_angle, 0, 0])
      cube(size=[fn_l1, fn_w1, fn_h1], center=true);
      hull(){
        translate([0, 0, (fn_h2-fn_h1)/2])
        cube(size=[fn_l1, fn_w1, fn_h2], center=true);
        translate([fn_shift_X, fn_shift_Y, (fn_h4-fn_h1)/2])
        cube(size=[fn_l2, 0.1, fn_h4], center=true);
      }
    }
    
    difference(){
      union(){
        translate([0, -sin(fn_angle)*fn_h1/2, 2.4])
        translate([0, 0, fn_wall2])
        rotate([fn_angle, 0, 0])
        cube(size=[fn_li, fn_wi, fn_h1], center=true);
        hull(){
          translate([0, 0, (fn_h2-fn_h1)/2])
          cube(size=[fn_l1-4, fn_w1-2, fn_h3], center=true);
          translate([fn_shift_X, fn_shift_Y, (fn_h4-fn_h1)/2])
          cube(size=[fn_l2-4, 0.15, fn_h5], center=true);
        }
      }
      for(i=[-2:1:2])
      hull(){
        translate([i*10, fn_wi/2, (fn_h2-fn_h1)/2])
        cube(size=[1,1,fn_h2], center=true);
        translate([i*6, fn_shift_Y, (fn_h2-fn_h1)/2])
        cube(size=[1,1,fn_h2], center=true);
      }
    }
    
    // Nozzle tip
//    translate([0, fn_shift_Y, fn_h2-fn_h1/2])
//    cube(size=[fn_li, 6.1, 20.1], center=true);
    
    hull(){
      translate([0, fn_shift_Y, fn_h2-fn_h1/2])
      cube(size=[fn_li, 0.1, 0.1], center=true);
      translate([0, fn_shift_Y, -fn_h1/2])
      cube(size=[fn_li, 15, 0.1], center=true);
    }
    
    // Mount screw on fan
    rotate([fn_angle, 0, 0])
    for(i=[0:1:1])mirror([i,0,0])
    translate([4.3-fn_li/2, 0, fn_h1/2 - 4])
    rotate([90, 0, 0])
    cylinder(d=4, h=fn_wi*2.2, center=true);
  }
  
  
}



module Z_bar_mount(){
  zbm_l = 57;
  zbm_l2 = 19;
  zbm_w = 60;
  zbm_w2 = 35;
  zbm_h = 15;
  zbm_wall = 2;
  zbm_wall2 = 10;
  
  frame_d = 10.5;


  zbm_shift_X = 16;
  zbm_shift_Y = 28 + 10;

  Z_bar_X = 10 - zbm_w/2;
  Z_bar_Y = zbm_wall2 + zbm_shift_Y -zbm_l/2;
  
  screw_dis = 20;
  screw_Z = 5;
  screw_X1 = Z_bar_X + 16;
  screw_X2 = screw_X1 + screw_dis;
  screw_Y = -zbm_l/2;
  
  
  
  translate([0, 0, zbm_h/2])
  difference(){
    union(){
      roundedCube([zbm_w, zbm_l, zbm_h], 2);

      translate([screw_X1, screw_Y+zbm_wall2/2, screw_Z])
      rotate([90, 0, 0])
      cylinder(d=12, h=zbm_wall2, center=true);
      
      translate([screw_X2, screw_Y+zbm_wall2/2, screw_Z])
      rotate([90, 0, 0])
      cylinder(d=12, h=zbm_wall2, center=true);
    }
    // Main cut
    translate([zbm_w2, zbm_l2, 0])
    cube(size=[zbm_w, zbm_l, zbm_h+0.1], center=true);
    translate([15,50,0])
    rotate([0, 0, 45])
    cube(size=[60,60,zbm_h+0.1], center=true);
    
    // Frame cut
    translate([15, zbm_wall2 + (frame_d-zbm_l)/2, zbm_wall])
    cube(size=[zbm_w, frame_d, zbm_h], center=true);
    
    // Z Bar cut
    translate([Z_bar_X, Z_bar_Y, zbm_wall]){
      cylinder(d=10.2, h=zbm_h, center=true);
      cylinder(d=M3_hole, h=zbm_h*2, center=true);
    }
    // Drive Bar cut
    translate([Z_bar_X+17.5*1.5, Z_bar_Y, zbm_wall]){
      cylinder(d=40, h=zbm_h, center=true);
    }
    
    // Mount screws cut
    translate([screw_X1, screw_Y, screw_Z])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=100, center=true);
      translate([0, 0, 5-zbm_wall2/2])
      cylinder(d=7, h=zbm_wall2, center=true);
    }

    translate([screw_X2, screw_Y, screw_Z])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=60, center=true);
      translate([0, 0, 5-zbm_wall2/2])
      cylinder(d=7, h=zbm_wall2, center=true);
    }
  }
}


module X_Axis(type = 1){
  xa_bar_z = 10;
  xa_bar_y = -6;
  xa_bar_shift = -1;
  xa_bar_l = 370;
  xa_l = 95;
  xa_w = 48;
  xa_h = 38;

  bar_shift_Y = 2.0;
  
  Z_bar_X = 0;  
  Z_bar_Y =  bar_shift_Y-10;
  Z_bar_Z = xa_bar_z + 15;
  
  D_bar_X = 0;  
  D_bar_Y = Z_bar_Y + 17.5 + bar_shift_Y;
  D_bar_Z = Z_bar_Z;
  
  xa_bar_dx = 20;
  xa_bar_dy = 15;
  
  // Stepper mount position
  sm_X = -25.5;
  sm_Y = -46;
  sm_Z = xa_bar_z;
  sm_h = 14;
  sm_l = 42;
  sm_w = 55;
  sm_shift_Y = 3;
  
  // Lead nut dimensions
  ln_d = 13.5;
  ln_m_d = 19.5;
  ln_m_a = sqrt((ln_m_d/2)*(ln_m_d/2)/2);
  
  // Belt cut dimensions
  bc_d = 20;
  bc_w = 12;
  
  // Pulley position
  p_Y = 10;
  
  
  // Distance screws 10mm bearing fixture
  s_dis = 31;
  
//  if(0)
  difference(){
    union(){
      translate([0, 0, xa_h/2])
      roundedCube([xa_l, xa_w, xa_h],3);
      if(type == 1)
      translate([sm_X, sm_Y+sm_shift_Y, sm_h/2])
      roundedCube([sm_l, sm_w, sm_h],2);
    }
    
    // belt cut
    translate([sm_X, sm_Y, sm_Z])
    hull(){
      cylinder(d=bc_d, h=bc_w, center=true);
      translate([0, 200, 0])
      cylinder(d=bc_d, h=bc_w, center=true);
    }
    
    // Pulley cut
    difference(){
      translate([sm_X, p_Y, sm_Z])
      cylinder(d=M3_hole, h=bc_w+20, center=true);
      translate([sm_X, p_Y, sm_Z+bc_w/2])
      cylinder(d=6, h=.40, center=true);
    }
    translate([sm_X, p_Y, sm_Z-bc_w/2])
    cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
    
    // Stepper motor cuts
    translate([sm_X, sm_Y, sm_h/2]){
      hull(){
        translate([0, -5, 0])
        cylinder(d=bc_d, h=sm_h+0.1, center=true);
        translate([0, +5, 0])
        cylinder(d=bc_d, h=sm_h+0.1, center=true);
      }
      hull(){
        translate([0, -5, -sm_h/2])
        cylinder(d=23, h=3, center=true);
        translate([0, +5, -sm_h/2])
        cylinder(d=23, h=3, center=true);
        translate([0, -5, 3-sm_h/2])
        cylinder(d=bc_d, h=1, center=true);
        translate([0, +5, 3-sm_h/2])
        cylinder(d=bc_d, h=1, center=true);
      }
      
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0])
      translate([motor_m/2, motor_m/2, 0])
      hull(){
        translate([0, -5, 0])
        cylinder(d=M3_hole, h=sm_h+0.1, center=true);
        translate([0, 5, 0])
        cylinder(d=M3_hole, h=sm_h+0.1, center=true);
      }
    }

    // Drive rod cut
    difference(){
      union(){
        translate([D_bar_X, D_bar_Y, D_bar_Z])
        rotate([0, 90, 0]){
          cylinder(d=ln_d, h=xa_l+0.1, center=true);
          translate([-8.5, 15, 12])
          cube(size=[30, 27.75, xa_l], center=true);
        }
      }
      translate([Z_bar_X, Z_bar_Y, Z_bar_Z])
      for(i=[-s_dis:s_dis:s_dis])
      translate([i+1, 2+lm10luu_do/2, 0]){
        difference(){
          cylinder(d=8, h=xa_h*2, center=true);
//          translate([0, 0, 0.11])
//          cylinder(d=M3_hole+2, h=4.2, center=true);
        }
      }
    }      
    
    
    // Z axis cut
    translate([Z_bar_X, Z_bar_Y, Z_bar_Z]){
        translate([0, -10, 20])
        cube(size=[xa_l+0.1,40,40], center=true);
        translate([12, 0, 20])
        cube(size=[xa_l,60,40], center=true);
      difference(){
        rotate([0, 90, 0])
        cylinder(d=lm10luu_do, h=xa_l+0.1, center=true);
//        for(i=[-(lm10luu_l+5):lm10luu_l+5:lm10luu_l+5])
//        translate([i, 0, -lm10luu_do/2])
//        cube(size=[2, lm10luu_do, 5], center=true);
      }

      // Flex hinge cut
//      hull(){
//        translate([0, lm10luu_do/2+2, xa_h/2])
//        cube(size=[xa_l+0.1, 0.2, xa_h], center=true);
//        translate([0, lm10luu_do/2+2, xa_h-Z_bar_Z])
//        cube(size=[xa_l+0.1, 3, 0.1], center=true);
//      }
      // large gap
//      difference(){
//        translate([0, 0.7-10, -2])
//        union(){
//          roundedRect([xa_l-3.0, 12, 4], 3);
//          translate([0, 0, 2])
//          cube(size=[xa_l-10, 20, 4], center=true);
//        }
//
//        translate([0, -lm10luu_do/2, 0])
//          for(i=[-xa_l/2:10:xa_l/2])
//          translate([i, 0, 0])
//          cube(size=[0.9, lm10luu_do, 4], center=true);
//      }
      
      // Screw holes
      for(i=[0:1:1])mirror([0,i,0])
      for(i=[-s_dis:s_dis:s_dis])
      translate([i+1, -2-lm10luu_do/2, 0]){
        difference(){
          union(){
            cylinder(d=M3_hole, h=xa_h*2, center=true);
            translate([0, 0, -Z_bar_Z])
            hull(){
              cylinder(d=M3_nut_e, h=41, center=true, $fn=6);
              cylinder(d=M3_hole, h=45, center=true);
            }
            translate([0, 0, xa_h-Z_bar_Z])
            cylinder(d=M3_nut_e, h=18, center=true);
          }
          if(i<0)
          translate([0, 0, sm_Z+bc_w/2-Z_bar_Z])
          cylinder(d=20, h=0.4, center=true);
        }
      }

      

    }
    
    if(1==2)
    for(i=[-40:20:40])translate([i, 0, 0])
    if(i!=-20){    
      translate([Z_bar_X, Z_bar_Y, Z_bar_Z/2])
      cylinder(d=M3_hole, h=Z_bar_Z+0.1, center=true);
      translate([Z_bar_X, Z_bar_Y, Z_bar_Z-4])
      cylinder(d=M3_nut_e, h=lm10luu_do, center=true, $fn=6);
    }

    // Weight cut
    c_h = 18.1;
    translate([10, 12.25, c_h/2])
    hull(){
      cube(size=[30, 1, c_h+10], center=true);
      translate([0, 21, 0])
      cube(size=[45, 1, c_h+10], center=true);
      translate([0, 0, -c_h/2])
      cube(size=[30, 40, 0.1], center=true);
    }
    
    // Lead nut cuts
    translate([-xa_l/2, D_bar_Y, D_bar_Z]){
      translate([0, ln_m_a, ln_m_a])
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=70, center=true);

      translate([0, -ln_m_a, -ln_m_a])
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=70, center=true);
      
      hull(){
        translate([4, ln_m_a, ln_m_a])
        rotate([0, 90, 0])
        rotate([0, 0, 45+30])
        cylinder(d=M3_nut_e, h=3, center=true, $fn=6);

        translate([4, -ln_m_a, -ln_m_a])
        rotate([0, 90, 0])
        rotate([0, 0, 45+30])
        cylinder(d=M3_nut_e, h=3, center=true, $fn=6);
      }
    }

    
    // X axis rail cuts
    translate([xa_bar_shift, 0, 0])
    for(i=[0:1:1])mirror([i,0,0]){
      // X axis rails
      translate([xa_bar_dis/2, xa_w/2+xa_bar_y, xa_bar_z])
      rotate([90, 0, 0]){
        cylinder(d=xa_bar_d, h=xa_w, center=true);
        cylinder(d=M3_nut_e, h=xa_w+16, center=true, $fn=6);
      }

      // Adjust rod position screws
      translate([xa_bar_dis/2, 0, xa_bar_z])
      rotate([90, 0, 0])
      cylinder(d=M3_hole, h=xa_w, center=true);

      // Rail pos control holes
      translate([xa_bar_dis/2, xa_bar_y, xa_bar_z/2])
      cylinder(d=3, h=xa_bar_z+0.1, center=true);

      // Fix rail screws
      translate([xa_bar_dis/2, xa_w/2-5, xa_bar_z/2])
      cylinder(d=3, h=xa_bar_z+0.1, center=true);
      translate([xa_bar_dis/2, xa_w/2-5, 5])
      rotate([0, 0, 30])
      cylinder(d=M3_nut_e, h=6, center=true, $fn=6);

    }
  }
  
  // 10mm bearing fixture
  f_l = xa_l-15;
  f_w = 30;
  f_h = lm10luu_do/2+4;
  
  translate([5, 42, f_h/2])
  difference(){
    union(){
      roundedCube([f_l, f_w, f_h],3.5);
      // Screw holes
      for(i=[0:1:1])mirror([0,i,0])
      for(i=[-s_dis:s_dis:s_dis])
      translate([i-5.5, -2-lm10luu_do/2, 0]){
        cylinder(d=7, h=f_h, center=true);
      }
    }
    translate([0, 0, f_h/2+4])
    rotate([0, 90, 0])
    cylinder(d=lm10luu_do, h=f_l+0.1, center=true);

    // Screw holes
    for(i=[0:1:1])mirror([0,i,0])
    for(i=[-s_dis:s_dis:s_dis])
    translate([i-5.5, -2-lm10luu_do/2, 0]){
      cylinder(d=M3_hole, h=xa_h*2, center=true);
    }
  }
  
  
}



module coldend_vice(){
  cv_h = 14;
  cv_h2 = 19;
  cv_w = 40;
  cv_l = 40;
  cv_wall = 2;
  screw_dis = 30;
  
  // Bottom part
  difference(){
    union(){
      roundedRect([cv_l, cv_w, cv_h], 5);
      // Lid screws
      for(j=[0:1:1])mirror([0,j,0])
      for(i=[0:1:1])mirror([i,0,0])
      translate([screw_dis/2, screw_dis/2, cv_h2/2]){
        cylinder(d=10, h=cv_h2, center=true);
      }
    }
    
    // Center hole
    translate([0, 0, cv_h/2+8])
    cylinder(d=10+2.5, h=cv_h, center=true);
    translate([0, 0, 3.8])
    cylinder(d=M12_nut_e, h=8, center=true, $fn=6);
    
    
    
    // Lid screws
    for(j=[0:1:1])mirror([0,j,0])
    for(i=[0:1:1])mirror([i,0,0])
    translate([screw_dis/2, screw_dis/2, cv_h2/2]){
      cylinder(d=M3_hole, h=cv_h2+0.1, center=true);
      hull(){
        translate([0, 0, -cv_h2/2]){
          cylinder(d=M3_nut_e, h=12, center=true);
          cylinder(d=M3_hole, h=16, center=true);
        }
      }
    }
  }
  
  // Lid
  translate([cv_l+1, 0, 0])
  difference(){
    union(){
      roundedRect([cv_l, cv_w, cv_wall], 5);
      roundedRect([15, 15, 10], 2);
    }
    cylinder(d=3, h=50, center=true);
    
    for(j=[0:1:1])mirror([0,j,0])
    for(i=[0:1:1])mirror([i,0,0])
    translate([screw_dis/2, screw_dis/2, cv_h/2]){
      cylinder(d=M3_hole, h=cv_h+0.1, center=true);
    }
  }
  
}

module hotend_vice(){
  cv_h = 16;
  cv_w = 40;
  cv_l = 40;
  cv_wall = 2;
  screw_dis = 30;
  
  // Bottom part
  difference(){
    roundedRect([cv_l, cv_w, cv_h], 5);
    
    // Center hole
    translate([0, 0, cv_h/2+cv_wall])
    cylinder(d=10, h=cv_h, center=true);
    cylinder(d=M3_hole, h=cv_h+0.1, center=true);
    
    // clamping screws
    for(i=[0:90:90])rotate([0, 0, i])
    translate([0, 0, cv_h/2])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=cv_w+0.1, center=true);
      translate([0, 0, (10)/2+3])
      hull(){
        cylinder(d=M3_nut_e, h=3, center=true, $fn=6);
        translate([0, 50, 0])
        cylinder(d=M3_nut_e, h=3, center=true, $fn=6);
      }
      translate([0, 0, -(10)/2-3])
      hull(){
        cylinder(d=M3_nut_e, h=3, center=true, $fn=6);
        translate([0, 50, 0])
        cylinder(d=M3_nut_e, h=3, center=true, $fn=6);
      }
    }
    
    
    // Lid screws
    for(j=[0:1:1])mirror([0,j,0])
    for(i=[0:1:1])mirror([i,0,0])
    translate([screw_dis/2, screw_dis/2, cv_h/2]){
      cylinder(d=M3_hole, h=cv_h+0.1, center=true);
      hull(){
        translate([0, 0, -cv_h/2]){
          cylinder(d=M3_nut_e, h=24, center=true);
          cylinder(d=M3_hole, h=28, center=true);
        }
      }
    }
  }
  
  
}


module end_stop_mount(){
  esm_s_d = 38;
  esm_s_Z = 7;
  esm_lt = 90;
  esm_l1 = 20;
  esm_wt = 50+37;
  esm_w1 = 25;
  esm_wall = 2;
  esm_h = 12;
  esm_shift_X = 18.5;
  
  nozzle_Y = esm_lt/2-73;
  nozzle_X = esm_shift_X - esm_s_d/2 - 35;
  
  // screw tip
  st_h = 15;
  st_do = 20;
  translate([45, 0, st_h/2])
  difference(){
    cylinder(d=st_do, h=st_h, center=true);
    translate([0, 0, 1])
    cylinder(d=3, h=st_h, center=true);
  }
  
//  if(1==2)
  difference(){
    intersection(){
      union(){
        translate([0, 0, esm_h/2])
        difference(){
          cube(size=[esm_wt, esm_lt, esm_h], center=true);
          translate([-98, 90, esm_wall])
          cylinder(d=300, h=esm_h, center=true);
        }
        
        translate([(esm_wt-esm_wall)/2, 0, esm_h/2])
        cube(size=[esm8_wall, esm_lt, esm_h], center=true);

        translate([19.6, 0, esm_h/2])
        cube(size=[esm_wall, esm_lt, esm_h], center=true);

        translate([0, 4, esm_h/2])
        cube(size=[esm_wt, esm_wall, esm_h], center=true);

        for(i=[0:1:1])mirror([0,i,0]){
          translate([0, (esm_lt-esm_wall)/2+.5, esm_h/2])
          rotate([-5, 0, 0])
          cube(size=[esm_wt, esm_wall, esm_h], center=true);
        }
        // Nozzle tip
        translate([nozzle_X, nozzle_Y, 2])
        cylinder(d=15, h=4, center=true);
      }
      translate([-98, 90, esm_wall])
      cylinder(d=310, h=esm_h*2, center=true);
    }
    
    // Nozzle tip
    translate([nozzle_X, nozzle_Y, esm_wall/2])
    cylinder(d=M3_hole, h=esm_wall*10.1, center=true);
    translate([nozzle_X, nozzle_Y, 3])
    cylinder(d=M3_nut_e, h=4, center=true, $fn=6);
    
    // Cut rear edge
    translate([-esm_wt/2-10, esm_lt/2, esm_wall/2])
    cube(size=[esm_wt, 80, esm_h*2.1], center=true);
    // Cut center
    translate([-25, esm_lt/2-30, esm_wall/2])
    cube(size=[esm_wt, 20, esm_h*2.1], center=true);
    
    // Mount holes frame
    translate([esm_s_d/2+esm_shift_X, esm_lt/2, esm_s_Z])
    rotate([90, 0, 0])
    hull(){
      translate([0,1,0])
      cylinder(d=M3_hole, h=10, center=true);
      translate([0,-1,0])
      cylinder(d=M3_hole, h=10, center=true);
    }

    translate([-esm_s_d/2+esm_shift_X, esm_lt/2, esm_s_Z])
    rotate([90, 0, 0])
    hull(){
      translate([0,1,0])
      cylinder(d=M3_hole, h=10, center=true);
      translate([0,-1,0])
      cylinder(d=M3_hole, h=10, center=true);
    }
      

  }
}

module force_sensor_mount(){
  fsm_l = 27;
  fsm_l2 = 25;
  fsm_w = 16;
  fsm_w2 = 14;
  fsm_h = 6;
  fsm_h2 = 4;
  fsm_shift_Y = 6;
  s_dis_X = 10;
  
  
  // Spacer to hopper
  translate([20, 0, 0])
  difference(){
    translate([0, 0, 0])
    roundedRect([fsm_w2, fsm_l2, fsm_h2], 5);

    // Force sensor screws
    translate([0, hbm_dis/2, fsm_h2/2])
    cylinder(d=M5_hole, h=fsm_h2+0.1, center=true);
    translate([0, -hbm_dis/2, fsm_h2/2])
    cylinder(d=M5_hole, h=fsm_h2+0.1, center=true);
  }
  
  // Mount on X-Axis
  translate([0, 0, fsm_h/2])
  difference(){
    cube(size=[fsm_w, fsm_l, fsm_h], center=true);
    
    
    // Force sensor screws
    translate([0, hbm_dis/2, 0])
    cylinder(d=M4_hole, h=fsm_l*2.1, center=true);
    translate([0, -hbm_dis/2, 0])
    cylinder(d=M4_hole, h=fsm_l*2.1, center=true);
    
    // Screw cuts
    for(j=[0:1:1])mirror([j, 0, 0])
    translate([s_dis_X/2, 0, 0])
    rotate([90, 0, 0])
    cylinder(d=M3_hole, h=fsm_l+0.2, center=true);
  }
  
}


module extruder_mount(type = 0){
  em_wall = 2;
  em_w1 = 64;
  em_w2 = 30;
  em_h = xa_bar_dis + 2 * em_wall + lm8uu_do;
  em_thick = em_wall + lm8uu_do/2 - 0.2 * type;
  em_cut_w = 20;
  em_cut_h = 63;
  em_cut_shift = -.0;
  

  // Belt mount
  bm_X1 = -18;
  bm_Y1 = xa_bar_dis/2 - 11 + type * 1.25;

  bm_X2 = 18;
  bm_Y2 = xa_bar_dis/2 - 9.75 - type * 1.25;

  // Cable mount
  cm_X1 = 27;
  cm_X2 = 20;
  cm_Y1 = em_h/2+10;
  cm_Z1 = em_thick/2;
  cm_h = 17;
  cm_do = 15;
  
  // Mount screws grid
  m_grid_dX = 10;
  m_grid_dY = 10;

  // Ball bearing mounts
  a = lm8uu_do + 2 * em_wall;
  bb_screw_X1 = -27;
  bb_screw_X2 = -5;
  bb_screw_X3 = 5;
  bb_screw_X4 = 27;
  bb_screw_Y1 = xa_bar_dis/2 - 10;
  bb_screw_Y2 = xa_bar_dis/2 + 10;
  
  difference(){
    union(){
//      if(type == 0)
      roundedRect([em_w1, em_h, em_wall*2], 2);
      
      // Cable mount
      translate([0, cm_Y1-7, 0])
      roundedRect([em_w1, cm_h, em_thick], 2, [0, 0, 1, 1]);
      
      
      // Ball bearing mounts
      translate([0, -xa_bar_dis/2, 0])
      roundedRect([em_w1, a, em_thick], 2);
      translate([0, xa_bar_dis/2, 0]){
        roundedRect([em_w2, a, em_thick], 2);
        roundedRect([em_w1, 14, em_thick], 2);
      }
      
      // Ball bearing screws
      for(i=[0:1:1])mirror([0, i, 0]){        
        if(i==1)
        hull(){
          translate([bb_screw_X1, bb_screw_Y1, em_thick/2])
          cylinder(d=10, h=em_thick, center=true);
          translate([bb_screw_X1, bb_screw_Y2, em_thick/2])
          cylinder(d=10, h=em_thick, center=true);
        }

        translate([0, 0, em_thick/2])
        hull(){
          translate([bb_screw_X2, bb_screw_Y1+i*5, 0])
          cylinder(d=10, h=em_thick, center=true);
          translate([bb_screw_X2, bb_screw_Y2, 0])
          cylinder(d=10, h=em_thick, center=true);
        }

        translate([0, 0, em_thick/2])
        hull(){
          translate([bb_screw_X3, bb_screw_Y1+i*5, 0])
          cylinder(d=10, h=em_thick, center=true);
          translate([bb_screw_X3, bb_screw_Y2, 0])
          cylinder(d=10, h=em_thick, center=true);
        }

        if(i==1)
        hull(){
          translate([bb_screw_X4, bb_screw_Y1, em_thick/2])
          cylinder(d=10, h=em_thick, center=true);
          translate([bb_screw_X4, bb_screw_Y2, em_thick/2])
          cylinder(d=10, h=em_thick, center=true);
        }
      }
    }
    
    // Top mount points
    for(j=[0:7:21])
    for(i=[0:1:1])mirror([i,0,0]){
      translate([cm_X1-j, cm_Y1, cm_Z1])
      rotate([90, 0, 0])
      cylinder(d=M3_hole, h=cm_h + 0.1, center=true);
      translate([cm_X1-j, cm_Y1-3, 0]){
        hull(){
          cube(size=[5.65, 3.2, cm_Z1*2], center=true);
          translate([0, 0, cm_Z1+0.2])
          rotate([90, 0, 0])
          rotate([0, 0, 30])
          cylinder(d=M3_nut_e, h=3.2, center=true, $fn=6);
        }
      }
    }
    
    // Belt mounts
    translate([bm_X1, bm_Y1, 2])
    cylinder(d=M3_hole, h=em_thick, center=true);
    if(type == 0)
    translate([bm_X1, bm_Y1, 0])
    hull(){
      cylinder(d=M3_hole, h=4, center=true);
      cylinder(d=M3_nut_e, h=2, center=true, $fn=6);
    }

    translate([bm_X2, bm_Y2, 2])
    cylinder(d=M3_hole, h=em_thick, center=true);
    if(type == 0)
    translate([bm_X2, bm_Y2, 0])
    hull(){
      cylinder(d=M3_hole, h=4, center=true);
      cylinder(d=M3_nut_e, h=2, center=true, $fn=6);
    }

    // Mount screws grid
    for(i=[-2:1:3])
    for(j=[-2:1:2])
    translate([i*m_grid_dX-5, j*m_grid_dY, em_thick/2]){
      cylinder(d=M3_hole, h=em_thick+1, center=true);
      translate([0, 0, 4-em_thick/2])
      cylinder(d=M3_nut_e, h=4, center=true, $fn=6);
    }

    // Hopper cut
    translate([0, em_cut_shift, em_thick/2])
    cube([em_cut_w, em_cut_h, em_thick+1], center=true);

    // Ball bearing mount screws
    for(i=[0:1:1])mirror([0, i, 0]){
      if(i==1)
      translate([bb_screw_X1, bb_screw_Y1, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      translate([bb_screw_X1, bb_screw_Y2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }

      translate([bb_screw_X2, bb_screw_Y1, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      translate([bb_screw_X2, bb_screw_Y2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }

      translate([bb_screw_X3, bb_screw_Y1, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      translate([bb_screw_X3, bb_screw_Y2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      // Extra hole on bottom for force sensor mount
      if(i && type == 0)
      translate([0, xa_bar_dis/2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        rotate([0, 0, 30])
        cylinder(d=M3_nut_e, h=em_thick-2, center=true, $fn=6);
      }


      if(i==1)
      translate([bb_screw_X4, bb_screw_Y1, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      translate([bb_screw_X4, bb_screw_Y2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
    }

    // X axis bars
    for(i=[0:1:1])mirror([0, i, 0])
    translate([0, xa_bar_dis/2, em_thick])
    rotate([0, 90, 0])
    cylinder(d=xa_bar_d+1, h=em_w1+0.1, center=true);
    // X axis ball bearings
    b = (em_w1-lm8uu_l)/2-2*em_wall;
    for(j=[0:1:1])mirror([j, 0, 0])
    translate([b, -xa_bar_dis/2, em_thick])
    rotate([0, 90, 0])
    cylinder(d=lm8uu_do, h=lm8uu_l+1, center=true);

    translate([0, xa_bar_dis/2, em_thick])
    rotate([0, 90, 0])
    cylinder(d=lm8uu_do, h=lm8uu_l+1, center=true);

  }
}

module hopper_mount(){
  hm_l1 = 35;
  hm_l2 = 35;
  hm_w = 15;
  hm_wall1 = 1;
  hm_wall2 = 4;
  hm_l3 = 22;
  hm_wall3 = 4;
  
  top_s_X1 = 19-hm_l1/2;
  top_s_X2 = top_s_X1 + 10;
  top_s_Z = 2;
  
  rear_s_Y1 = 18;
  rear_s_Y2 = rear_s_Y1 + 10;
  rear_s_Z = 2;
  
  translate([0, 0, hm_w/2])
  difference(){
    union(){
      cube(size=[hm_l1, hm_wall1, hm_w], center=true);
      translate([(hm_l1-hm_l3)/2, -1.5, 0])
      cube(size=[hm_l3, hm_wall3, hm_w], center=true);
      translate([(hm_wall2-hm_l1)/2, hm_l2/2, 0])
      cube(size=[hm_wall2, hm_l2, hm_w], center=true);
    }
    // Top screw holes
    translate([top_s_X1, 0, top_s_Z])
    rotate([90, 0, 0])
    hull(){
      for(i=[0:1:1])mirror([i, 0, 0])
      translate([1.5, 0, 0])
      cylinder(d=M3_hole, h=hm_wall3 * 3, center=true);
    }
    translate([top_s_X2, 0, top_s_Z])
    rotate([90, 0, 0])
    hull(){
      for(i=[0:1:1])mirror([i, 0, 0])
      translate([1.5, 0, 0])
      cylinder(d=M3_hole, h=hm_wall3 * 3, center=true);
    }
     
    // rear screw holes
    translate([-hm_l1/2, rear_s_Y1, rear_s_Z])
    rotate([0, 90, 0])
    hull(){
      for(i=[0:1:1])mirror([0, i, 0])
      translate([0, 1.5, 0])
      cylinder(d=M3_hole, h=hm_wall2 * 3, center=true);
    }
    translate([-hm_l1/2, rear_s_Y2, rear_s_Z])
    rotate([0, 90, 0])
    hull(){
      for(i=[0:1:1])mirror([0, i, 0])
      translate([0, 1.5, 0])
      cylinder(d=M3_hole, h=hm_wall2 * 3, center=true);
    }
  }
}

module water_cooling(){

  // water cooling dimensions
  wc_l = 77;
  wc_l2 = 30;
  wc_h = 8;
  
  // thermal sensor
  ts_X = h_lb/2-1;
  ts_Y = 0;
  ts_d = 3.1;
  ts_l = 10;
  ts_Z = wc_h/2;
  
  hose_X = -1.5;
  hose_Y = wc_l/2-4.25;
  hose_h = 6;
  hose_angle = 30;

  rotate([180, 0, 0])
  difference(){
    union(){
//      roundedRect([h_lb, wc_l, wc_h], 5);

      // Center
//      roundedRect([h_lb, wc_l2, wc_h], 5);
      translate([0, 0, wc_h/2])
      cylinder(d=26, h=wc_h, center=true);
      roundedRect([15, wc_l, wc_h], 5);

      // Mount points motor
//      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0]){
        translate([motor_mnt_Y ,motor_mnt_X, wc_h/2])
        cylinder(d=20, h=wc_h, center=true);
      }
      
/*      
      // Linkage points motor
      difference(){
        translate([0, 0, wc_h/2])
        roundedRect([motor_mnt_X+4, motor_mnt_Y*2+4, wc_h/2], 5);
        translate([0, 0, -0.05])
        roundedRect([motor_mnt_X, motor_mnt_Y*2, wc_h+0.1], 5);
      }
*/
      
      // hose connectors to front
      for(i=[0:1:1])mirror([0,i,0]){
        translate([hose_X, hose_Y, wc_h/2])
        rotate([0, 90, 0])
        roundedRect([wc_h, wc_h, 15], 1);
      }
            
      // Thermal sensor
      translate([ts_X-ts_l/2-ts_l/2, ts_Y, ts_Z])
      rotate([0, 90, 0])
      roundedRect([wc_h, wc_h, ts_l], 1);
    }
    
    
    // Center cut
    translate([0, 0, wc_h/2])
    cylinder(d=10.0, h=wc_h+0.1, center=true);
    translate([0, 0, wc_h/2 - 2])
    cylinder(d=20.0, h=wc_h, center=true);
    
    
    // hose connectors to front
    for(i=[0:1:1])mirror([0,i,0]){
      translate([hose_X+23, hose_Y, wc_h/2])
      rotate([0, 90, 0])
      cylinder(d=4.1, h=40, center=true);
    }
    
    // horizontal connection hole
    difference(){
      translate([0, 0, wc_h/2-0.2]){
        rotate([90, 0, 0])
        cylinder(d=4.0, h=wc_l-4, center=true);
      }
      for(j=[0:1:1])mirror([0,j,0]){
        translate([motor_mnt_Y, motor_mnt_X, wc_h/2]){
          cylinder(d=8, h=wc_h+0.1, center=true);
        }
      }
    }
    
    // Mount holes motor
//    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_Y, motor_mnt_X, wc_h/2]){
        cylinder(d=M3_hole, h=wc_h+0.1, center=true);
        difference(){
          cylinder(d=14, h=4.4, center=true);
          cylinder(d=8, h=4+0.5, center=true);
        }
      }
    }
    
    // Thermal sensor
    translate([ts_X-ts_l/2+1.1, ts_Y, ts_Z])
    rotate([0, 90, 0])
    cylinder(d=ts_d, h=ts_l, center=true);
    
  }
  

}




module water_cooling_angled(){

  // water cooling dimensions
  wc_l = 77;
  wc_l2 = 30;
  wc_h = 6;
  
  // thermal sensor
  ts_X = h_lb/2+1;
  ts_Y = 0;
  ts_d = 3.1;
  ts_l = 8;
  ts_Z = wc_h/2;
  
  hose_X = -1.5;
  hose_Y = wc_l/2-4.5;
  hose_h = 6;
  hose_angle = 30;

  difference(){
    union(){
//      roundedRect([h_lb, wc_l, wc_h], 5);

      // Center
//      roundedRect([h_lb, wc_l2, wc_h], 5);
      translate([0, 0, wc_h/2])
      cylinder(d=26, h=wc_h, center=true);
      roundedRect([10, wc_l, wc_h], 5);

      // Mount points motor
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0]){
        translate([motor_mnt_X/2 ,motor_mnt_Y, wc_h/2])
        cylinder(d=10, h=wc_h, center=true);
      }
      // Linkage points motor
      difference(){
        roundedRect([motor_mnt_X+4, motor_mnt_Y*2+4, wc_h], 5);
        translate([0, 0, -0.05])
        roundedRect([motor_mnt_X, motor_mnt_Y*2, wc_h+0.1], 5);
      }

      // hose connectors
//      if(0)
      for(i=[0:1:1])mirror([0,i,0]){
        rotate([0, hose_angle, 0])
        translate([hose_X, hose_Y, (hose_h-wc_h)/2+wc_h]){
          cylinder(d=9, h=hose_h-wc_h+10, center=true);
        }
      }
      
      // Thermal sensor
      translate([ts_X-ts_l/2-ts_l/2, ts_Y, ts_Z])
      rotate([0, 90, 0])
      roundedRect([wc_h, wc_h, ts_l], 1);
    }
    
    // Bottom flat cut
    translate([0, 0, -10])
    roundedRect([h_lb+1, wc_l+1, 10], 5);
    
    // Center cut
    translate([0, 0, wc_h/2])
    cylinder(d=10.0, h=wc_h+0.1, center=true);
    translate([0, 0, wc_h/2 - 2.5])
    hull(){
      cylinder(d=18.0, h=wc_h-5, center=true);
      cylinder(d=10.0, h=wc_h+3, center=true);
    }
    
    // hose connectors
    for(i=[0:1:1])mirror([0,i,0]){
      rotate([0, hose_angle, 0])
      translate([hose_X, hose_Y, (hose_h-wc_h)/2+wc_h+2]){
        cylinder(d=4.1, h=hose_h-wc_h+10, center=true);
      }
    }

    // horizontal connection hole
    translate([0, 0, wc_h/2-0.2]){
      rotate([90, 0, 0])
      cylinder(d=4.0, h=wc_l-6, center=true);
    }
    
    // Mount holes motor
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_X/2, ,motor_mnt_Y, wc_h/2])
      cylinder(d=M3_hole, h=wc_h+0.1, center=true);
    }
    
    // Thermal sensor
    translate([ts_X-ts_l/2+0.1, ts_Y, ts_Z])
    rotate([0, 90, 0])
    cylinder(d=ts_d, h=ts_l, center=true);
    
  }
  
}

module hopper_front_door_cone(){
  hfdc_wall = 2;
  hfdc_wall_2 = 10;
  hfdc_w = h_wb - 2.5;
  hfdc_flap = 50;
  hfdc_h = 55;
  hfdc_l = 50;
  hfdc_angle = 45;
  
  // Feeder tube hole
  fth_X = 10;
  fth_Y = 37;
  
  l = h_inner_cyl + 2 * hfdc_wall;
  
  translate([0, -170*0, 0])
  difference(){
    union(){
      difference(){
        union(){
          roundedRect([hfdc_w, h_h, hfdc_wall_2], 2, [0,0,1,1]);
//          translate([0, (hfdc_h-h_h)/2, 0])
//          roundedRect([hfdc_w, hfdc_h, hfdc_wall], 2, [0,0,1,1]);
          translate([0, (hfdc_h-h_h)/2+4, hfdc_wall/2])
          cubec([l, hfdc_h, hfdc_wall]);
        }
        // Door cut
        translate([0, 1.55, hfdc_wall_2/2])
        cubec([h_inner_cyl, h_h-7, hfdc_wall_2+0.1]);
        translate([0, 2.55, hfdc_wall_2/2+hfdc_wall])
        cubec([h_inner_cyl, h_h-5, hfdc_wall_2+0.1]);
      }
      
      // cone
      a = hfdc_h / cos(hfdc_angle);
      translate([0, 4, hfdc_wall/2]){
        translate([0, -(h_h)/2, 0])
        rotate([hfdc_angle, 0, 0])
        translate([0, a/2, 0])
        cubec([l, a, hfdc_wall]);
        for(i=[0:1:1])mirror([i,0,0])
        hull(){
          translate([(h_inner_cyl+hfdc_wall)/2, -(h_h)/2, 0])
          rotate([hfdc_angle, 0, 0])
          translate([0, a/2, 0])
          cubec([hfdc_wall, a, hfdc_wall]);

          x = (h_inner_cyl + hfdc_wall)/2;
          translate([x, (hfdc_h-h_h)/2, 0])
          cubec([hfdc_wall, hfdc_h, hfdc_wall]);
        }
      }      
    }

    // Magnet cuts
    for(i=[0:1:1])mirror([i,0,0]){
//      translate([mag_X1, mag_Y1, hfdc_wall_2/2])
//      cylinder(d=mag_d, h=hfdc_wall_2+0.1, center=true);
      translate([mag_X2, mag_Y2, hfdc_wall_2/2])
      cylinder(d=mag_d, h=hfdc_wall_2+0.1, center=true);
      translate([mag_X3, mag_Y3, hfdc_wall_2/2])
      cylinder(d=mag_d, h=hfdc_wall_2+0.1, center=true);
    }
    
    // lower tip cut
    translate([0, -h_h/2-3.0, 0])
    rotate([14, 0, 0])
    cubec([h_wb*1.1, 10, 40]);
    
    // mount hole feeder tube
    translate([fth_X, fth_Y, hfdc_wall/2])
    cylinder(d=M3_hole, h=hfdc_wall*2.1, center=true);

/*    
    // mount hole on front door
    translate([0, 0, ffc_Y-2])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=h_wb*1.5, center=true);
      difference(){
        cylinder(d=M3_nut_e, h=h_inner_cyl+6, center=true, $fn=6);
      cylinder(d=M3_nut_e+1, h=h_inner_cyl-0.1, center=true);
      }
    }
*/

  }
}


module hopper_front_door(){
  hfd_wall = 2;
  hfd_flap = 50;
  hfd_angle = 15;
  
  
  translate([0, -50*0, 0])
  difference(){
    
    union(){
      roundedRect([h_wb, h_h, hfd_wall], 2, [0,0,0,0]);
      
/*
      // Old mount points on hopper
      hull(){
        roundedRect([hfd_screw_dis + 10, 10, hfd_wall], 5);
        translate([0, 5-h_h/2, 0])
        roundedRect([h_wb, 10, hfd_wall], 5);
      }
*/
      
      a=cos(hfd_angle)*hfd_flap+0.9;
      b=1-h_h/2-sin(hfd_angle)*hfd_flap;

      // flap
      hull(){
          translate([0, b-(5-hfd_wall/2)-0.05, a])
          cubec([h_wb, hfd_wall, 0.1]);
          translate([0, (hfd_wall-h_h)/2-0.05, 0.05])
          cubec([h_wb, hfd_wall, 0.1]);
      }
//      translate([0, (hfd_wall-h_h)/2, hfd_wall/2])
//      rotate([hfd_angle, 0, 0])
//      translate([0, 0, hfd_flap/2])
//      cubec([h_wb, hfd_wall, hfd_flap]);
      
      // flap walls
      for(i=[0:1:1])mirror([i,0,0])
      hull(){
        translate([(h_wb-hfd_wall)/2+1.51, 0, 0]){
          translate([0, h_h/2-5, 5])
          cubec([hfd_wall, 10, 10]);
          translate([0, b, a])
          cubec([hfd_wall, 10.1, 0.1]);
          translate([0, -h_h/2, 0.05])
          cubec([hfd_wall, 0.1, 0.1]);
        }
      }
    }
    
    // Magnet cuts
    for(i=[0:1:1])mirror([i,0,0]){
//      translate([mag_X1, mag_Y1, hfd_wall/2])
//      cylinder(d=M3_hole, h=hfd_wall+0.1, center=true);
      translate([mag_X2, mag_Y2, hfd_wall/2])
      cylinder(d=M3_hole, h=hfd_wall+0.1, center=true);
      translate([mag_X3, mag_Y3, hfd_wall/2])
      cylinder(d=M3_hole, h=hfd_wall+0.1, center=true);
    }
    
    // Door cut
    translate([0, 5, hfd_wall/2])
    cubec([h_inner_cyl, h_h, hfd_wall + 0.1]);

    
    // mount hole for front feeding cone
//    translate([0, 0, ffc_Y])
//    rotate([0, 90, 0])
//    cylinder(d=M3_hole, h=h_wb*1.5, center=true);
    
    // Mount screws cut
    for(i=[0:1:1])mirror([i,0,0])
    translate([hfd_screw_dis/2, 0, hfd_wall/2])
    cylinder(d=M3_hole, h=hfd_wall+0.1, center=true);
  }
}

module hopper_rear_mount(type = 0){
  
  hrm_w = 19;
  hrm_h1 = 25;
  hrm_h2 = hrm_h1 + 15;
  hrm_l = 75;
  hrm_wall = 3.75;
  hrm_cut_l = 15;
  
  screw_h = hrm_h1 + 10;
  screw_shift = 36-(hrm_l-fs_screw_dis_m)/2;
  
  
  difference(){
    union(){
      translate([0, 0, hrm_h1/2])
      cubec([hrm_l, hrm_w, hrm_h1]);
      
      for(i=[0:1:1])mirror([0,i,0])
      translate([hrm_cut_l/2, hrm_w/2, hrm_h2/2])
      rotate([90, 0, 0])
      roundedRect([hrm_l-hrm_cut_l, hrm_h2, hrm_wall], 5);
    }
    
    // Mount holes force sensor
    translate([screw_shift, 0, 0])
    for(i=[0:1:1])mirror([i,0,0]){
      
      translate([fs_screw_dis_m/2, (hrm_w-hrm_wall)/2, screw_h])
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=hrm_wall+0.1, center=true);
        translate([0, 0, -0.75])
        cylinder(d1=6, d2=M3_hole, h=3+0.1, center=true);
      }

      translate([fs_screw_dis_m/2, -(hrm_w-hrm_wall)/2, screw_h])
      rotate([90, 0, 0])
      cylinder(d=M3_nut_e, h=hrm_wall+0.1, center=true, $fn=6);
    }
    
    // Mount holes on X axis
    for(i=[0:1:1])mirror([0,i,0])
    translate([0, 5, 4])
    rotate([0, 90, 0])
    cylinder(d=M3_hole, h=hrm_l+0.1, center=true);
    
    translate([0, 0, 14])
    rotate([0, 90, 0])
    cylinder(d=M3_hole, h=hrm_l+0.1, center=true);
    
    // Cut some space for hopper
    translate([(hrm_cut_l-hrm_l)/2-0.1, 0, hrm_h1-2])
    roundedRect([hrm_cut_l, hrm_w*2, hrm_h2], 2, [0,0,0,0]);
  }
  
}


module hopper_rear_mount_old(type = 0){
  
  // rest point front side

  rp_w = 65;
  rp_h = 12;
  rp_wall = 2;
  rp_cut_w = 18;
  rp_cut_depth = 11;
  
  if(type == 0+999 || type == 1)
  translate([0, 20, 0])
  difference(){
    roundedRect([rp_w, rp_h, rp_wall], 5);
    
    // Rest point cut
    translate([0, rp_h/2, rp_wall/2])
    cubec([rp_cut_w, rp_cut_depth, rp_wall+0.1]);
    
    // mount holes
    for(i=[0:1:1])mirror([i,0,0])
    translate([27, 2, rp_wall/2])
    hull(){
      cylinder(d=M3_hole, h=40, center=true);
      translate([0, -3, 0])
      cylinder(d=M3_hole, h=40, center=true);
    }
  }
  
  hrm_l1 = 8;
  hrm_l2 = 37;
  hrm_w = 17;
  hrm_h1 = 5;
  hrm_ht = 24;
  shift_b = -8;
  screw_shift = 20;
  hinge_h = 3;
  
  // Rear hinge
  if(type == 0 || type == 2)
  translate([0, 0, hrm_w/2])
  rotate([90, 0, 0])
  difference(){
    union(){
      cubec([hrm_l1, hrm_w, hrm_ht]);
      translate([(hrm_l2-hrm_l1)/2, 0, (hrm_ht-hrm_h1)/2])
      cubec([hrm_l2, hrm_w, hrm_h1]);
    }
    
    // Hinge cut
    hull(){
      translate([hrm_l1/2+0.05, 0, hrm_ht/2-hinge_h])
      cubec([0.1, hrm_w+0.1, 0.1]);
      translate([hrm_l1/2+0.05+4, 0, hrm_ht/2-hinge_h-hrm_h1])
      cubec([8.1, hrm_w+0.1, 0.1]);
    }
    
    // Top cut
    hull(){
      translate([0, 0, hrm_ht/2+0.1])
      cubec([hrm_l1, hrm_w, 0.1]);
      translate([-hrm_l1/2, 0, hrm_ht/2-2.5])
      cubec([0.1, hrm_w+0.1, 0.1]);
    }
    
    
    // Mount holes hopper
    translate([screw_shift+hbm_dis/2, 0, 0]){
      cylinder(d=M3_hole, h=hrm_ht+0.1, center=true);
      cylinder(d=M3_nut_e, h=hrm_ht-4, center=true, $fn=6);
    }
    translate([screw_shift-hbm_dis/2, 0, 0]){
      cylinder(d=M3_hole, h=40, center=true);
      cylinder(d=M3_nut_e, h=hrm_ht-4, center=true, $fn=6);
    }
    
    // Mount holes on X axis
    translate([0, 0, shift_b])
    for(i=[0:1:1])mirror([0,i,0])
    translate([0, 5, 0])
    rotate([0, 90, 0])
    cylinder(d=4, h=hrm_l1+0.1, center=true);
  }
  
}

module hopper(){
  auger_cut = 12;
  
  // Tray dimensions
  tray_tol = 1;
  tray_s_Y1 = -h_wb/2+2;
  tray_s_Y2 = tray_s_Y1;
  tray_s_Z1 = h_h/2-7.5;
  tray_s_Z2 = h_h-7.5;
  tray_shift_Z = 5;
  tray_w = h_inner_cyl;
  tray_l = h_lb/2-3;
  
  // Force sensor mount  
  lever_h = 2;
  lever_l = 27;
  lever_w = 18.5;
  
//  translate([0, 40, 29])cubec([10,10,10]);
  
  difference(){
    union(){

      // Mount points part cooling fan
      difference(){
        translate([0, 0, -5])
        hull(){
          translate([0, mnt_top_Y, (h_h-5)])
          roundedRect([mnt_top_X*2+10, 10, 5], 2);
          translate([0, mnt_top_Y, h_h-20])
          roundedRect([h_wb, 10, 0.1], 2);
        }
//        translate([0, 0, h_h])
//        roundedRect([h_wb+20, 25, 20], 2);
      }
      
      // Hopper body
      roundedRect([h_wb, h_lb, h_h], 5, [0,0,1,1]);

/*      
      // Front door mount points
      hull(){
        translate([0, -h_lb/2, h_h/2])
        rotate([-90, 0, 0])
        roundedRect([hfd_screw_dis + 10, 10, 5], 5);
        translate([0, -h_lb/2, 5])
        rotate([-90, 0, 0])
        roundedRect([h_wb, 10, 5], 5);
      }
*/
      
//      // Tray
//      a = tray_w+2*h_wall+tray_tol;
//      translate([0, -tray_l/2, h_h/2])
//      cubec([a, tray_l, h_h]);


      // Lever for rear mount
//      translate([0, (h_lb+lever_l)/2, 0])
//      roundedRect([lever_w, lever_l, h_wall], 5, [0,0,0,0]);
//      translate([0, (h_lb+lever_l)/2, h_h2-h_wall])
//      roundedRect([lever_w, lever_l, h_wall], 5, [0,0,0,0]);
      translate([0, (h_lb+h_wall)/2, h_h2/2])
      cubec([14, h_wall, h_h2]);
      for(i=[0:1:1])mirror([i,0,0])
      translate([lever_w/2-h_wall, (lever_l+h_lb)/2, h_h2/2])
      cubec([h_wall*2, lever_l, h_h2]);
    }

    // Screw holes magnets front door
    translate([0, -h_lb/2, h_h/2])
    rotate([90, 0, 0])
    for(i=[0:1:1])mirror([i,0,0]){
//      translate([mag_X1, mag_Y1,0]){
//        cylinder(d=2.9, h=38, center=true);
//        cylinder(d=6, h=8, center=true);
//      }
      translate([mag_X2, mag_Y2, 0]){
        cylinder(d=2.9, h=38, center=true);
//        cylinder(d=6, h=8, center=true);
      }


      translate([mag_X3, mag_Y3,0]){
        cylinder(d=2.9, h=38, center=true);
//        cylinder(d=6, h=8, center=true);
      }

    }

    // Front opening
    translate([0, -tray_l, h_h/2+tray_shift_Z])
    cubec([tray_w, tray_l*2, h_h]);

/*
    // Front door mount points
    for(i=[0:1:1])mirror([i,0,0])
    translate([hfd_screw_dis/2, -h_lb/2, h_h/2])
    rotate([-90, 0, 0]){
      cylinder(d=M3_hole, h=12, center=true);
      translate([0, 0, 6])
      cylinder(d=M3_nut_e, h=8, center=true, $fn=6);
    }
*/    

    // Mount points part cooling fan
    for(j=[0:1:1])mirror([j,0,0])
//    for(i=[0:1:1])mirror([0,i,0])
    translate([mnt_top_X, mnt_top_Y, h_h-10-5]){
      cylinder(d=M3_hole, h=h_h*2, center=true);
      hull(){
        cylinder(d=M3_hole, h=14, center=true);
        cylinder(d=M3_nut_e, h=10, center=true, $fn=6);
      }
    }
    
    // Magnet cuts part cooling fan
    for(i=[0:1:1])mirror([i,0,0])
    translate([h_wb/2, 5-h_lb/2, h_h/2+4])
    rotate([0, 90, 0])
    cylinder(d=6.5, h=10, center=true);

    // Center cut
    hull(){
      translate([0, 0, h_h/2+5])
      cylinder(d=h_inner_cyl , h=h_h, center=true);
      translate([0, 0, h_wall_b])
      cylinder(d=auger_cut, h=0.1, center=true);
    }
    translate([0, 0, h_h])
    cylinder(d=21, h=4, center=true);

    // auger cut
    cylinder(d=auger_cut, h=h_h+0.1, center=true);
      
    // Mount holes motor
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_X, motor_mnt_Y, h_h/2]){
        cylinder(d=M3_hole, h=h_h+0.1, center=true);
        translate([0, 0, h_h/2])
        rotate([0, 0, 30])
        cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
      }
    }
  
    // Mount holes force sensor Nextruder
    translate([0, 0, 6+2+M3_hole/2+fs_screw_dis_h/2])
    for(i=[0:1:1])mirror([0,0,i])
    translate([0, h_lb/2+20, fs_screw_dis_h/2])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=lever_w+0.1, center=true);
      rotate([0, 0, 30])
      translate([0, 0, 8])
      cylinder(d=M3_nut_e, h=lever_w, center=true, $fn=6);
      translate([0, 0, (3-(lever_w+0.1))/2])
      cylinder(d2=M3_hole, d1=6, h=3, center=true);
    }
    
    // Cable hole
    translate([5, h_lb/2+7.6, 22])
    rotate([90, 0, 90])
    hull(){
      roundedRect([15,7,10], 2);
      translate([0, 0, -3])
      roundedRect([11,7,10], 2);
    }
    
//    translate([lever_w/2, h_lb/2-0.7, h_h+2])
//    rotate([0, 90, 0])
//    cylinder(d=4, h=lever_w, center=true);
    
    
/*
    // Mount holes bottom mount
    translate([0, hbm_Y1, 0]){
      cylinder(d=M3_hole, h=40, center=true);
    }
    translate([0, hbm_Y2, 0]){
      cylinder(d=M3_hole, h=40, center=true);
    }
*/
  }
  
}



module gear(teeth=10,h=5, shaft=M3_hole, mod=3.5, s=1.0){
  alpha = 180/teeth;
  r=(mod/2.0)/tan(alpha);
  
  x = cos(alpha) * r;
  t_r = mod/sqrt(3);
  t_h = mod*sqrt(3)/2.0;
  
  difference(){
    linear_extrude(height = h, scale=s){
      union(){
        for(i=[0:1:teeth-1]){
          rotate([0, 0, i*360/teeth]){  
            translate([x+(t_h-t_r),0,0]){
              circle(r=t_r, $fn=3);
            }
          }
        }
        rotate([0, 0, alpha])
        circle(r=r, $fn=teeth);
      }
    }
    translate([0, 0, h/2]){
      cylinder(d=shaft, h=h*1.1, center=true);
    }
    if(shaft==-1){
      translate([0, 0, h/2]){
        difference(){
          cylinder(d=motor_shaft, h=h*1.1, center=true);
          translate([0, motor_shaft_shift, 0]){
            cubec([motor_shaft, motor_shaft, 16]);
          }
        }
      }
    }
  }
  
}

module roundedCube(size, radius, f=50){
  x = size[0];
  y = size[1];
  z = size[2];

  hull(){
    translate([x/2-radius, y/2-radius, z/2-radius])
    sphere(r=radius, $fn=f);
    translate([-(x/2-radius), y/2-radius, z/2-radius])
    sphere(r=radius, $fn=f);
    translate([-(x/2-radius), -(y/2-radius), z/2-radius])
    sphere(r=radius, $fn=f);
    translate([x/2-radius, -(y/2-radius), z/2-radius])
    sphere(r=radius, $fn=f);

    translate([x/2-radius, y/2-radius, -(z/2-radius)])
    sphere(r=radius, $fn=f);
    translate([-(x/2-radius), y/2-radius, -(z/2-radius)])
    sphere(r=radius, $fn=f);
    translate([-(x/2-radius), -(y/2-radius), -(z/2-radius)])
    sphere(r=radius, $fn=f);
    translate([(x/2-radius), -(y/2-radius), -(z/2-radius)])
    sphere(r=radius, $fn=f);
  }
}

module cubec(size=[1,1,1]){
  cube(size, center=true);
}


module roundedRect(size, radius, edges=[1, 1, 1, 1], vscale=[1,1], shift=0){
  x = size[0];
  y = size[1];
  z = size[2];

  translate([0, -shift*2, 0]){
    linear_extrude(height=z, scale=[vscale[0], vscale[1]]){
      translate([0, shift*2, 0]){
        hull(){
            // place 4 circles in the corners, with the given radius
            if(edges[0]){
              translate([(-x/2)+(radius), (-y/2)+(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(-x/2)+(radius/2), (-y/2)+(radius/2), 0])
              square(size=[radius, radius], center=true);
            }
            if(edges[1]){
              translate([(x/2)-(radius), (-y/2)+(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(x/2)-(radius/2), (-y/2)+(radius/2), 0])
              square(size=[radius, radius], center=true);
            }

            if(edges[2]){
              translate([(-x/2)+(radius), (y/2)-(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(-x/2)+(radius/2), (y/2)-(radius/2), 0])
              square(size=[radius, radius], center=true);
            }

            if(edges[3]){
              translate([(x/2)-(radius), (y/2)-(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(x/2)-(radius/2), (y/2)-(radius/2), 0])
              square(size=[radius, radius], center=true);
            }
          }
       }
    }
  }
}