// Control an 'Active Hammer' to engrave metals
// More on: https://homofaciens.de/s/027.htm

#define NOT_ENABLE  4
#define M1          5
#define M2          6
#define M3          7
#define NOT_RESET   8
#define NOT_SLEEP   9
#define STEP       10
#define DIR        11
#define TEST_LED   13

#define CURRENT_SENSOR     A0
#define SPINDLE_SENSOR     A1

#define STEP_PAUSE_UP     200
#define STEP_PAUSE_DOWN   400
#define PULSE_PAUSE         5
#define NO_CURRENT        512
#define IS_CURRENT         15
#define MAX_STEP_NO        15
#define RETRACT            10

char text_buffer[200];
int step_no = 0;
int do_EDM = 0;

int inByte = 0;         // incoming serial byte
int currentSensor = 0;
byte current_dir = 0;

int i;
int retract = 1;
int step_pause = 0;


void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('A');   // send a capital A
    delay(300);
  }
}

void read_current(){
  currentSensor = analogRead(CURRENT_SENSOR);
  if(abs(NO_CURRENT - currentSensor) > IS_CURRENT){
    //Serial.print('C');
    step_pause = STEP_PAUSE_UP;
    current_dir = 1; // Go UP
  }
  else{
    //Serial.print('N');
    step_pause = STEP_PAUSE_DOWN;
    current_dir = 0; // Go DOWN
  }
}


void setup() {

  step_no = 0;
  current_dir = 0;
  do_EDM = 0;
  retract = 1;
  
  pinMode(NOT_ENABLE, OUTPUT);

  pinMode(M1, OUTPUT);
  pinMode(M2, OUTPUT);
  pinMode(M3, OUTPUT);
  // Step settings M1-M3:
  // L L L = Full step
  // H L L = 1/2 step
  // L H L = 1/4 step
  // H H L = 1/8 step
  // H H H = 1/16 step
  digitalWrite(M1, HIGH);
  digitalWrite(M2, HIGH);
  digitalWrite(M3, HIGH);

  
  pinMode(NOT_RESET, OUTPUT);
  digitalWrite(NOT_RESET, HIGH);
  pinMode(NOT_SLEEP, OUTPUT);
  digitalWrite(NOT_SLEEP, HIGH);
  pinMode(STEP, OUTPUT);
  pinMode(DIR, OUTPUT);

  pinMode(TEST_LED, OUTPUT);
  pinMode(CURRENT_SENSOR, INPUT);
  pinMode(SPINDLE_SENSOR, INPUT);

  Serial.begin(115200);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  //establishContact();  // send a byte to establish contact until receiver responds
}

void loop() {

  if (Serial.available() > 0) {
    inByte = Serial.read();
    if(inByte == 'E'){
      do_EDM = 1;
      Serial.println("EDM ACTIVATED");
    }
    if(inByte == 'e'){
      do_EDM = 0;
      Serial.println("EDM deactivated");
    }
    
    currentSensor = analogRead(CURRENT_SENSOR);
    sprintf(text_buffer, "Current=%d, Spindle=%d", currentSensor, digitalRead(SPINDLE_SENSOR));
    Serial.println(text_buffer);
  }

  read_current();

  if(!digitalRead(SPINDLE_SENSOR) || do_EDM || current_dir){
  
    digitalWrite(DIR, current_dir);
    digitalWrite(STEP, HIGH);
    delayMicroseconds(PULSE_PAUSE);
    digitalWrite(STEP, LOW);
    delayMicroseconds(step_pause);
  }

}
