// Parts for my experiments with EDM (Active Hammer)
// Details on:
// www.HomoFaciens.de

$fn=100;

M3_hole = 3.5;
M3_nut_e = 6.3;
M4_hole = 4.5;
M5_hole = 5.5;
M6_hole = 6.5;
M4_nut_e = 7.66 + 0.3;
M5_nut_e = 8.79 + 0.3;
M6_nut_e = 11.05 + 0.3;
M8_nut_e = 14.38+1.5;

// Ball bearings
bb3_di = 3;
bb3_do = 10.05;
bb3_h = 4;

bb5_di = 5.5;
bb5_do = 16.5;
bb5_h = 5;

// Stepper motor dimensions
stepper_e = 42;
stepper_l = 40;
stepper_m = 31;
stepper_d_cut = 26;
stepper_h_cut = 2;
stepper_shaft = 5.5;
stepper_shaft_shift = 4.9;

// Mount screws CNC machine
m_screw_dis = 24;


//coin_holder();



//V1_mount(); // Direct stepper drive and brass tube

difference(){
  V2_mount(); // With wire straightener
//  translate([0, 64-15*0, 0])
//  cube(size=[150,190,100], center=true);
//  translate([97.5, 0, 0])
//  cube(size=[150,150,100], center=true);
}

//rubber_ring();

module V2_mount(){
  m_l = 100;
  m_w = 80;
  m_h = 5;
  m_bb_h = 8;
  m_bb_h2 = m_bb_h + 0*bb5_h/2;
  bbl_h = 7;
  m_wall = 2;
  
  // CNC mount position
  cnc_m_X = 40;
  
  // Wire position
  wire_Y = -bb5_do/2-m_w / 2;
  wire_Z = m_bb_h + bb5_h/2;
  
//  echo(wire_Z);
  
  // TOP fixed ball bearings wire straightener
  bb_p1_X = -3;
  bb_p1_shift_X = 17;
  bb_p1_Y = wire_Y-10;

  // TOP adjustable ball bearing
  bb_p2_Y = -88;
  bb_p2_Y_shift = 3;

  // BOTTOM adjustable ball bearing
  bb_p3_X = -28-24;
  bb_p3_Y = bb_p2_Y;
  bb_p3_Y_shift = 7;

  // Driven fixed ball bearings
  bb_f_bot_X = -28    -13.0;
  bb_f_bot_Y = -m_w / 2;

  bb_f_top_X = -28+8.0;
  bb_f_top_Y = bb_f_bot_Y;
  
  bb_link_l1 = 38;
  bb_link_h1 = 18;
  bb_link_l2 = 49;
  
  
  // Center wire guide
  wg_l = 3;
  wg_h = wire_Z + bb5_h/2;
  wg_w = -wire_Y-m_w/2+3;
  wg_1_X = bb_f_bot_X-(bb_f_bot_X-bb_f_top_X)/2;
  
  // Adjust screw distance
  as_dis = 52;
  as_2_dis = 33*0+as_dis;
  as_Z = 30;
  
  // Stepper motor position
  sp_X = -25.5;
  sp_Y = 11;
  hole_l = 10;
  step_cut_w = stepper_e + 3;
  
  // Pulley dimensions
  p_X = wg_1_X;
  p_Y = sp_Y-(stepper_d_cut+hole_l)/2-6.5;
  p_d = 39;
  p_h = 5;
  p_shaft_h = 15;
  p_shaft_d = 10;
  
  // spool holder
  sh_X = 52;
  sh_Y = -25;
  
  brim_d = 8;
  brim_h = 0.35;

  // Mount tower dimensions
  mt_X1 = -32+as_dis/2;
  mt_X2 = mt_X1-as_dis;
  mt_X3 = mt_X1 + 20;  
  
  // Electrode mount plate
  em_wall1 = 2;
  em_l = 30;
  em_shift = -1.0;
  em_shift_Y = 2.0;
  em_w = 11;
  em_w_z = 8.5;
  em_w_d1 = 2;
  em_w_d2 = 4.2;
  em_ovhg = 3.5;
  em_h1 = 4;
  em_h2 = 12;
  em_h3 = 22;
  em_gap = 2;
  em_gap_shift = em_gap/2-em_w/2+1.5;

  em_Wire_Y = -5;
  
  // Electrode mount flap
  emf_X = 1 - m_l/2 - em_w/2;
  emf_Y = 5-m_w/2;
  emf_l = 30;
  emf_w = em_w+2;
  emf_wall = 2;
  emf_hole_X = -1;
  emf_hole_Y = 7;
  
  
  // Electrode mounts / guides
  if(1)
//  for(j=[0:1:1])
  translate([-55.6, -48-40, 0])
  difference(){
    union(){
      a=m_bb_h-em_h1 + (bb5_h-bb3_h);
      translate([0, 10, 0])
      roundedRect([em_w, em_l, em_h1],3, [0,0,1,1]);
      //Wire guide
      translate([-(em_w+em_wall1)/2, 0, em_h2/2])
      cube(size=[em_wall1, 10, em_h2], center=true);
      translate([(em_w+em_wall1)/2-2, 0, em_h2/2])
      cube(size=[em_wall1, 10, em_h2], center=true);
    }
    // Electrode wire mount
    translate([0, 20, em_h1/2])
    cylinder(d=M3_hole, h=m_bb_h, center=true);
    translate([0, 10, em_h1/2])
    cylinder(d=M3_hole, h=m_bb_h, center=true);

    // Wire hole
    translate([0, 0, wire_Z-2])
    rotate([0, 90, 0])
    cylinder(d=2, h=em_w*2, center=true);

  }
  
  // Pulley
  if(1)
  translate([35, -80, p_h/2])
  difference(){
    union(){
      cylinder(d=p_d, h=p_h, center=true);
      translate([0, 0, (p_shaft_h-p_h)/2])
      cylinder(d1=p_shaft_d*1.7, d2=p_shaft_d, h=p_shaft_h, center=true);
    }
    cylinder(d=M3_hole, h=p_shaft_h*2.1, center=true);
    rotate_extrude(convexity = 10)
    translate([p_d/2, 0, 0])
    rotate([0, 0, 30])
    circle(d = 4, $fn=6);
  }
  
  // Mount
  if(1)
  difference(){
    union(){
      
      roundedRect([m_l, m_w, m_h], 5, [0,0,1,0]);
      // Electrode mount flap
      translate([emf_X, emf_Y, 0])
      roundedRect([emf_w, emf_l, emf_wall], 2, [1,1,1,0]);
      
      // CNC mount
      translate([cnc_m_X-m_screw_dis/2, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }
      translate([cnc_m_X+m_screw_dis/2, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }


      // Driven ball bearings
      translate([bb_f_bot_X, bb_f_bot_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);

      translate([bb_f_top_X, bb_f_top_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);
      
      if(1)
      translate([0, bb_p3_Y+6, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        // TOP adjustable ball bearing
        translate([bb_f_top_X, bb_p3_Y_shift, m_bb_h2/2]){
          hull(){
            cylinder(d1=10, d2=8, h=m_bb_h2, center=true);
          }
        }

        // BOTTOM adjustable ball bearing
        translate([bb_f_bot_X, bb_p3_Y_shift, m_bb_h2/2]){
          hull(){
            cylinder(d1=10, d2=8, h=m_bb_h2, center=true);
          }
        }
        // Adjustable ball bearing linkage
        l = bb_f_top_X-bb_f_bot_X;
        translate([bb_f_bot_X+l/2, 7, bbl_h/2])
        cube(size=[l, m_wall, bbl_h], center=true);

        // Adjustable ball bearing arm
        translate([bb_f_bot_X+l/2+bb_link_l2/2, bb_link_h1+2, bbl_h/2])
        cube(size=[bb_link_l2, m_wall*2, bbl_h], center=true);

        // Adjustable ball bearing arm link
        hull(){
          translate([bb_f_bot_X+l/2, bb_link_h1+2, bbl_h/2])
          cube(size=[6, 4, bbl_h], center=true);
          translate([bb_f_bot_X+l/2, 7, bbl_h/2])
          cube(size=[1, 2, bbl_h], center=true);
        }        
      }


      // Adjust screw towers
      translate([mt_X1, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }
/*      
      translate([mt_X2, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([-4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }
*/
      translate([mt_X3, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([-4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 18, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }

      // Center wire guide      
      translate([wg_1_X, -m_w/2, 0]){
        hull(){
          translate([0, 1.5, 0.5])
          cube(size=[wg_l, 3, 1], center=true);
          translate([0, 0, wg_h-0.5])
          cube(size=[wg_l, 6, 1], center=true);
        }
      }
      translate([wg_1_X, (-m_w-wg_w)/2, wire_Z]){
        cube(size=[wg_l, wg_w, bb5_h], center=true);
      }
      // support structure wire guide
      translate([wg_1_X, -wg_w-m_w/2, wg_h/2]){
        cube(size=[wg_l, 1.4, wg_h], center=true);
      }
      translate([wg_1_X, -wg_w-m_w/2, brim_h/2]){
        cylinder(d=9, h=brim_h, center=true);
      }
      

      
      // Ball bearings
      if(0){
        translate([bb_f_bot_X, bb_f_bot_Y, m_h+7])
        cylinder(d=bb5_do, h=bb5_h*2, center=true);
        translate([bb_f_top_X, bb_f_top_Y, m_h+7])
        cylinder(d=bb5_do, h=bb5_h*2, center=true);
        translate([p_X, p_Y, m_h+5])
        cylinder(d=p_d, h=5, center=true);
      }
      
    }
    // opening
    translate([28, 4, m_h/2])
    scale([1,1.1])
    cylinder(d=52, h=m_h+0.1, center=true);
        
    // CNC mount cut
    translate([cnc_m_X-m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([cnc_m_X-m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([cnc_m_X+m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([cnc_m_X+m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);

    // Electrode mount flap cuts
    translate([emf_X+emf_hole_X, emf_Y+emf_hole_Y, emf_wall/2]){
      cylinder(d=M3_hole, h=emf_wall+0.1, center=true);
      translate([0, -10, 0])
      cylinder(d=M3_hole, h=emf_wall+0.1, center=true);
    }

    // Pulley cut
    hull(){
      translate([p_X, p_Y+2.5, m_h/2])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
      translate([p_X, p_Y-2.5, m_h/2])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
    }
    // Stepper motor cuts
    translate([sp_X, 3, m_wall])
    roundedRect([step_cut_w, m_w-10, m_h], 5);
    translate([sp_X, sp_Y, m_h/2]){
      hull(){
        translate([0, hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_h+0.1, center=true);
        translate([0, -hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_h+0.1, center=true);
      }
      for(i=[0:1:1])mirror([0,i,0])
      for(j=[0:1:1])mirror([j,0,0])
      translate([stepper_m/2, stepper_m/2, 0])
      hull(){
        translate([0, -hole_l/2, 0])
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
        translate([0, hole_l/2, 0])
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
      }
    }

    // Spool holder
    translate([sh_X, sh_Y, m_h/2])
    cylinder(d=M3_hole, h=m_h * 1.5, center=true);


      translate([0, bb_p3_Y+6, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        // BOTTOM adjustable ball bearing
        translate([bb_f_bot_X, bb_p3_Y_shift, m_bb_h2/2])
        cylinder(d=M5_hole, h=m_bb_h2+0.1, center=true);

        // TOP adjustable ball bearing
        translate([bb_f_top_X, bb_p3_Y_shift, m_bb_h2/2])
        cylinder(d=M5_hole, h=m_bb_h2+0.1, center=true);
      }
    // Driven fixed ball bearings
    translate([bb_f_bot_X, bb_f_bot_Y, m_h/2])
    cylinder(d=M5_hole, h=m_h * 2.5, center=true);

    translate([bb_f_top_X, bb_f_top_Y, m_h/2])
    cylinder(d=M5_hole, h=m_h * 2.5, center=true);


    // Adjust screw tower holes
    // Tower 1+2
    translate([mt_X1, -m_w/2-40, m_h/2+1]){
//      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:7:28])
      translate([0, 0, j]){
        if(j==0){
          translate([0, 44, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=100, center=true);
      }
    }

    // Tower 3
    translate([mt_X3, -m_w/2-40, m_h/2+1]){
      for(j=[0:7:28])
      translate([0, 0, j]){
        if(j==0){
          translate([0, 44, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=100, center=true);
      }
    }




    // Wire guide
    translate([wg_1_X, wire_Y, wire_Z])
    rotate([0, 90, 0])
    cylinder(d=2, h=wg_l*1.1, center=true);
  }
}

module rubber_ring(){
  rr_d = 35;
  rr_h = 4;
  translate([0, 0, rr_h/2])
  rotate_extrude(convexity = 10)
  translate([rr_d/2, 0, 0])
  rotate([0, 0, 30])
  circle(d = rr_h);
}



module V1_mount(){
  m_l = m_screw_dis + 74;
  m_w = 39;
  m_h = 6;
  
  // Wire tube
  wt_shift_Y = 5;
  wt_d = 2.0;
  wt_m_dis = 15;
  wt_m_l1 = 56;
  wt_m_l2 = 41;
  wt_m_X1 = -15;
  wt_m_X2 = -25;

  wt_m_X3 = 15;
  wt_m_X4 = 40;
  
  // Ball bearing
  bb_X = -30;
  bb_Y = wt_shift_Y-bb3_do/2;

  // Stepper motor position
  pulley_do = 10;
  pulley_h = 10;  
  sp_X = -30;
  sp_Y = wt_shift_Y-pulley_do/2;
  
  // DC motor
  mot_cut_d = 20;


  // Insert pulley on motor shaft 
  translate([40, -30, 7.5])
  difference(){
    union(){
      cylinder(d=7, h=15, center=true);
      translate([0, 0, 0.35/2-7.5])
      cylinder(d=15, h=0.35, center=true);
    }
    cylinder(d=5.2, h=15.1, center=true);
  }
 
  // Wire tube clamp short
  translate([20, -25, 0])
  difference(){
    roundedRect([wt_m_dis+7, 7, 2], 3);
    translate([wt_m_dis/2, 0, 1])
    cylinder(d=M3_hole, h=3, center=true);
    translate([-wt_m_dis/2, 0, 1])
    cylinder(d=M3_hole, h=3, center=true);
  }
  // Wire tube clamp medium
  translate([-15, -25, 0])
  difference(){
    roundedRect([wt_m_l2, 7, 2], 3);
    translate([5-wt_m_l2/2, 0, 1])
    cylinder(d=M3_hole, h=3, center=true);
    translate([stepper_m+5-wt_m_l2/2, 0, 1])
    cylinder(d=M3_hole, h=3, center=true);
  }
  // Wire tube clamps with pivot point
  translate([0, -45, 0])
  for(i=[0:1:1])
  translate([0, i*10, 0])
  difference(){
    roundedRect([wt_m_l1, 7, 2], 3);
    translate([5-wt_m_l1/2, 0, 1])
    cylinder(d=M3_hole, h=3, center=true);
    translate([stepper_m+5-wt_m_l1/2, 0, 1])
    cylinder(d=M3_hole, h=3, center=true);
    translate([15+stepper_m+5-wt_m_l1/2, 0, 1])
    cylinder(d=M3_hole, h=3, center=true);
  }
  
  // pulley
  translate([sp_X, sp_Y, pulley_h/2]){
    difference(){
      cylinder(d=pulley_do, h=pulley_h, center=true);
      cylinder(d=stepper_shaft, h=pulley_h+0.1, center=true);
    }
  }
  
  
  // Main plate
  difference(){
    union(){
      roundedRect([m_l, m_w, m_h], 3);
      
    }
    // Mount holes CNC
    translate([m_l/2-7, 7-m_w/2, m_h/2]){
      cylinder(d=M6_hole, h=m_h+0.1, center=true);
      translate([-m_screw_dis, 0, 0])
      cylinder(d=M6_hole, h=m_h+0.1, center=true);
    }
    
    // Ball bearing arm spring mount hole
    translate([19, 15, m_h/2])
    cylinder(d=M3_hole, h=m_h+0.1, center=true);
    
    
    // Wire tube
    translate([0, wt_shift_Y, m_h])
    rotate([0, 90, 0])
    cylinder(d=wt_d, h=m_l+0.1, center=true);
    
    // Wire clamp short mount holes
    translate([bb_X, wt_shift_Y, m_h/2])
    for(m=[0:1:1])mirror([0,m,0]){
      translate([wt_m_X4, wt_m_dis/2, 0]){
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
        hull(){
          translate([0, 0, -m_h/2])
          cylinder(d=M3_nut_e, h=4, center=true, $fn=6);
          cylinder(d=M3_hole, h=5, center=true);
        }
      }
    }
    
    // Stepper motor
    translate([sp_X, sp_Y, m_h/2]){
      cylinder(d=pulley_do+2, h=m_h+0.1, center=true);
//      translate([0, 0, (stepper_h_cut-m_h)/2-0.1])
//      cylinder(d=stepper_d_cut, h=stepper_h_cut, center=true);
      for(i=[0:1:1])mirror([0,i,0])
      for(j=[0:1:1])mirror([j,0,0])
      translate([stepper_m/2, stepper_m/2, 0])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
    }
    
    // Ball bearing
//    translate([bb_X, bb_Y, m_h/2])
//    cylinder(d=M3_hole, h=m_h+0.1, center=true);
//    translate([bb_X, bb_Y, m_h])
//    cylinder(d=M3_nut_e, h=bb3_h+4, center=true, $fn=6);
//    translate([bb_X, bb_Y, m_h])
//    cylinder(d=bb3_do+1, h=bb3_h+0.1, center=true);

    // Motor cut
    translate([bb_X, wt_shift_Y+mot_cut_d/2, m_h/2]){
      hull(){
        cylinder(d=mot_cut_d+1, h=m_h+0.1, center=true);
        translate([0, 20, 0])
        cylinder(d=mot_cut_d+1, h=m_h+0.1, center=true);
      }
    }
    
  }

  
  // Motor spacers
  ms_d = 10;
  ms_h1 = 3;
  ms_h2 = 4.5;
  
  translate([-43, -30, ms_h1/2])
  difference(){
    cylinder(d=ms_d, h=ms_h1, center=true);
    cylinder(d=M3_hole, h=ms_h1+0.1, center=true);
  }
  translate([-43, -41, ms_h1/2])
  difference(){
    cylinder(d=ms_d, h=ms_h1, center=true);
    cylinder(d=M3_hole, h=ms_h1+0.1, center=true);
  }
  translate([-43, -52, ms_h2/2])
  difference(){
    cylinder(d=ms_d, h=ms_h2, center=true);
    cylinder(d=M3_hole, h=ms_h2+0.1, center=true);
  }
  translate([-32, -52, ms_h2/2])
  difference(){
    cylinder(d=ms_d, h=ms_h2, center=true);
    cylinder(d=M3_hole, h=ms_h2+0.1, center=true);
  }


  // Ball bearing arm
  bba_l = 77;
  bba_w = 8;
  bba_h = 6;
  bba_shift_Y = -21.5;
  pivot_e = 3;
  bba_X = stepper_m/2 + pivot_e - bba_l/2;
  
  translate([-10, 15+16.5+1, 0])
  difference(){
    union(){
      roundedRect([bba_l, bba_w, bba_h], 2);
      translate([bba_X, bba_shift_Y, bba_h/2])
      hull(){
        cylinder(d=10, h=bba_h, center=true);
        translate([0, 17, 0])
        cylinder(d=12, h=bba_h, center=true);
      }
    }
    translate([bba_l/2-pivot_e, 0, bba_h/2])
    cylinder(d=M3_hole, h=bba_h+0.1, center=true);
    // Pivot point
    translate([pivot_e-bba_l/2, 0, bba_h/2]){
      cylinder(d=M3_hole, h=bba_h+0.1, center=true);
      // Ball bearing
      translate([stepper_m/2, bba_shift_Y, 0]){
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
        translate([0, 0, 2])
        cylinder(d=M3_nut_e, h=m_h, center=true, $fn=6);
        translate([0, 0, bba_h/2])
        cylinder(d=bb3_do+1, h=bb3_h+0.1, center=true);
      }
    }
  }
  
  // Spring holder
  sh_l = 60;
  sh_w = 20;
  sh_h = 10;
  sh_wall = 4;
  
  translate([20, 50-5*0, sh_h/2])
//  rotate([90, 0, 90])
  difference(){
    hull(){
      cube(size=[sh_l, sh_w, sh_h], center=true);
      translate([-sh_l/2, 0, 0])
      rotate([90, 0, 0])
      cylinder(d=sh_h, h=sh_w, center=true);
    }
    // Inner cut
    translate([-sh_wall-5, 0, 0])
    cube(size=[sh_l+10, sh_w-2*sh_wall, sh_h+0.1], center=true);
    
    // Pivot point
    translate([-sh_l/2, 0, 0])
    rotate([90, 0, 0])
    cylinder(d=M3_hole, h=sh_w+0.1, center=true);
    
    // Adjusting dcrew
    translate([(sh_l-sh_wall)/2, 0, 0]){
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=sh_wall+0.1, center=true);
      translate([-1.5, 0, 0])
      rotate([0, 90, 0])
      cylinder(d=M3_nut_e, h=sh_wall, center=true, $fn=6);
    }    
  }
  
  // pivot spacers
  s_h = (sh_w - 2 * sh_wall - m_h) / 2;
  translate([0, 50, s_h/2])
  difference(){
    cylinder(d=10, h=s_h, center=true);
    cylinder(d=M3_hole, h=s_h+0.1, center=true);
  }
  translate([11, 50, s_h/2])
  difference(){
    cylinder(d=10, h=s_h, center=true);
    cylinder(d=M3_hole, h=s_h+0.1, center=true);
  }
}

module V2_mount_004(){
  m_l = 110;
  m_w = 70;
  m_h = 5;
  m_bb_h = 8;
  m_bb_h2 = m_bb_h + 0*bb5_h/2;
  bbl_h = 7;
  m_wall = 2;
  
  // CNC mount position
  CNC_pos = 37;
  
  // Wire position
  wire_d = 2;
  wire_Y = -bb3_do/2-m_w/2-wire_d/2+0.5;
  wire_Z = m_bb_h + bb3_h/2+1;
  
//  echo(wire_Z);
  
  // Center wire guide
  wg_l = 5;
  wg_h = wire_Z + bb5_h/2;
  wg_w = -wire_Y-m_w/2+3;
  

  // Top fixed ball bearing (driven)
  bb_top_f_X = -30;
  bb_top_f_Y = -m_w / 2;

  // Bottom fixed ball bearing
  bb_bot_f_X = -50;
  bb_bot_f_Y = bb_top_f_Y;


  // TOP adjustable ball bearing
  bb_top_a_X = -28;
  bb_top_a_Y = -88;

  // BOTTOM adjustable ball bearing
  bb_bot_a_X = bb_top_a_X-24;
  bb_bot_a_Y = bb_top_a_Y;
  bb_bot_a_Y_shift = 1;

  
  bb_link_l1 = 38;
  bb_link_h1 = 18;
  bb_link_l2 = 58.5+9;
  
  // Adjust screw distance
  as_dis = 52;
  as_2_dis = 33*0+as_dis;
  as_Z = 30;
  
  // Stepper motor position
  s_cut = stepper_e + 3;
  s_bow_w = stepper_e + 7;
  sp_Z = 12;
  sp_X = -28.5;
  sp_Y = 8;
  hole_l = 10;
  
  // Large pulley dimensions
  p_X = sp_X-2;
  p_Y = sp_Y-(stepper_d_cut+hole_l)/2-9;
  p_d = 39;
  p_h = 5;
  p_shaft_h = 15;
  p_shaft_d = 10;
  
  // Small pulley dimensions on top of ball bearing
  ps_X = sp_X;
  ps_Y = sp_Y-(stepper_d_cut+hole_l)/2-6.5;
  ps_d = bb3_do + 5;
  ps_h = 10;
  ps_shaft_h = 15;
  ps_shaft_d = bb3_do + 1;
  
  
  // spool holder
  sh_X = 45;
  sh_Y = -15;
  
  brim_d = 8;
  brim_h = 0.35;

  // Mount tower dimensions
  mt_X1 = 14;
  mt_X3 = mt_X1 - 17;  
  
  // Electrode mount plate
  em_wall1 = 2;
  em_wall2 = 4;
  em_l = 75;
  em_shift = -1.0;
  em_shift_Y = 2.0;
  em_w = sp_Z+1;
  em_w_z = 8.5;
  em_w_d1 = 2;
  em_w_d2 = 4.2;
  em_ovhg = 3.5;
  em_h1 = 6;
  em_h2 = 15;
  em_h3 = 22;
  em_gap = 2;
  em_gap_shift = em_gap/2-em_w/2+1.5;

  bb_X1 = 0;
  bb_Y1 = -bb3_do/2;
  bb_Y2 = -bb_Y1;
  
  
  
  // Electrode mounts / guides
  if(1)
  translate([-63, -7, 0])
  difference(){
    roundedRect([em_w, em_l, em_wall1], 2);    

    // Mount holes
    for(i=[-30:10:20])
    translate([-1, i+14, em_wall1/2])
    cylinder(d1=M3_hole, d2=6, h=em_wall1+0.1, center=true);
    
    // Wire pos
    translate([wire_Z-em_w/2-1, wire_Y+6, em_wall1/2])
    cylinder(d=wire_d, h=em_wall1+0.1, center=true);
  }
  
  // Large pulley
  if(0)
  translate([-30, 64, p_h/2])
  difference(){
    union(){
      cylinder(d=p_d, h=p_h, center=true);
      translate([0, 0, (p_shaft_h-p_h)/2])
      cylinder(d1=p_shaft_d*1.7, d2=p_shaft_d, h=p_shaft_h, center=true);
    }
    cylinder(d=M3_hole, h=p_shaft_h*2.1, center=true);
    rotate_extrude(convexity = 10)
    translate([p_d/2, 0, 0])
    rotate([0, 0, 30])
    circle(d = 4, $fn=6);
  }

  // Small pulley on top of ball bearing
  if(0)
  translate([-1, -80, ps_h/2])
  difference(){
    union(){
      cylinder(d=ps_d, h=ps_h, center=true);
      translate([0, 0, (ps_shaft_h-ps_h)/2])
      cylinder(d=ps_shaft_d, h=ps_shaft_h, center=true);
    }
    cylinder(d=M3_hole, h=ps_shaft_h*2.1, center=true);
    translate([0, 0, ps_shaft_h-ps_h/2])
    cylinder(d=8, h=8, center=true);

    translate([0, 0, -ps_h/2])
    hull(){
      cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
      cylinder(d=M3_hole, h=12, center=true, $fn=6);
    }
  }
  
  // Stepper motor mount plate
  
  
  // Mount
  if(1)
  difference(){
    union(){
      
      if(1){
        roundedRect([m_l, m_w, m_h], 5, [0,0,1,0]);
        // CNC mount
        translate([CNC_pos-m_screw_dis/2, 0, m_h/2])
        hull(){
          translate([0, m_w/2+10, 0])
          cylinder(d=12, h=m_h, center=true);
          translate([0, -(m_w/2+10), 0])
          cylinder(d=12, h=m_h, center=true);
        }
        translate([CNC_pos+m_screw_dis/2, 0, m_h/2])
        hull(){
          translate([0, m_w/2+10, 0])
          cylinder(d=12, h=m_h, center=true);
          translate([0, -(m_w/2+10), 0])
          cylinder(d=12, h=m_h, center=true);
        }


        // Driven ball bearings
        translate([bb_bot_f_X, bb_bot_f_Y, m_h/2])
        hull(){
          cylinder(d1=8, d2=8, h=m_h, center=true);
          translate([2, 0, 0])
          cube(size=[14, 0.1, m_h], center=true);
        }

        translate([bb_top_f_X, bb_top_f_Y, m_bb_h/2])
        cylinder(d1=8, d2=6, h=m_bb_h, center=true);

        // Adjust screw towers
        translate([mt_X1, 4.0-m_w/2, (as_Z+5)/2]){
          cube(size=[10, 8, as_Z+5], center=true);
        }

        translate([mt_X3, 4.0-m_w/2, (as_Z+5)/2]){
          cube(size=[10, 8, as_Z+5], center=true);
          a = mt_X1-mt_X3;
          echo(a);
          translate([(a+5)/2, 0, 0])
          cube(size=[a, m_wall, as_Z+5], center=true);
          translate([4, 0, 0])
          hull(){
            cube(size=[2, 2, as_Z+5], center=true);
            translate([0, 18, 1-(as_Z+5)/2])
            cube(size=[2, 2, 2], center=true);
          }
        }


        // Top wire guide 
        a = bb_top_f_X + 12;
        translate([a, -m_w/2, 0]){
          hull(){
            translate([0, 1.5, 0.5])
            cube(size=[wg_l, 3, 1], center=true);
            translate([0, 0, wg_h-0.5])
            cube(size=[wg_l, 6, 1], center=true);
          }
        }
        translate([a, (-m_w-wg_w)/2, wire_Z]){
          cube(size=[wg_l, wg_w, bb5_h], center=true);
        }
        // support structure wire guide
        translate([a, -wg_w-m_w/2, wg_h/2]){
          cube(size=[wg_l, 1.4, wg_h], center=true);
        }
        translate([a, -wg_w-m_w/2, brim_h/2]){
          cylinder(d=9, h=brim_h, center=true);
        }
        
        // Center wire guide 
        b = bb_bot_f_X - (bb_bot_f_X - bb_top_f_X)/2;
        translate([b, -m_w/2, 0]){
          hull(){
            translate([0, 1.5, 0.5])
            cube(size=[wg_l, 3, 1], center=true);
            translate([0, 0, wg_h-0.5])
            cube(size=[wg_l, 6, 1], center=true);
          }
        }
        translate([b, (-m_w-wg_w)/2, wire_Z]){
          cube(size=[wg_l, wg_w, bb5_h], center=true);
        }
        // support structure wire guide
        translate([b, -wg_w-m_w/2, wg_h/2]){
          cube(size=[wg_l, 1.4, wg_h], center=true);
        }
        translate([b, -wg_w-m_w/2, brim_h/2]){
          cylinder(d=9, h=brim_h, center=true);
        }
        

        // Stepper motor box
        translate([sp_X, 3, 0])
        roundedRect([s_bow_w+2*m_wall, m_w-6, sp_Z], 5);

      }
      
      if(1)
      translate([0, bb_bot_a_Y+6, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        translate([0, 5, 0]){
          if(0){
            // TOP adjustable ball bearing
            translate([bb_top_f_X, 
                       bb_bot_a_Y_shift, 
                       m_bb_h2/2]){
              hull(){
                cylinder(d1=8, d2=6, h=m_bb_h2, center=true);
                translate([0, 
                           4.5-bb_bot_a_Y_shift,
                           -(m_bb_h2-bbl_h)/2])
                cube(size=[8, 1, bbl_h], center=true);
              }
            }
          }

          // BOTTOM adjustable ball bearing
          translate([bb_bot_f_X,
                     bb_bot_a_Y_shift,
                     m_bb_h2/2]){
            hull(){
              cylinder(d1=8, d2=6, h=m_bb_h2, center=true);
              translate([0,
                         4.5-bb_bot_a_Y_shift,
                         -(m_bb_h2-bbl_h)/2])
              cube(size=[8, 1, bbl_h], center=true);
            }
          }
          // Adjustable ball bearing linkage
//          l = bb_top_f_X-bb_bot_f_X;
          l=0;
          translate([bb_bot_f_X+l/2, 4, bbl_h/2])
          cube(size=[l, m_wall, bbl_h], center=true);

          // Adjustable ball bearing arm
          translate([bb_bot_f_X+l/2+bb_link_l2/2,
                     bb_link_h1,
                     bbl_h/2])
          cube(size=[bb_link_l2, m_wall*2, bbl_h], center=true);

          // Adjustable ball bearing arm link
          hull(){
            translate([bb_bot_f_X+l/2,
                       bb_link_h1,
                       bbl_h/2])
            cube(size=[6, 4, bbl_h], center=true);
            translate([bb_bot_f_X+l/2, 4, bbl_h/2])
            cube(size=[1, 2, bbl_h], center=true);
          }        
        }
      }


      
      // Ball bearings
      if(0){
        translate([bb_bot_f_X, bb_bot_f_Y, m_h+7])
        cylinder(d=bb3_do, h=bb3_h*2, center=true);
        translate([bb_top_f_X, bb_top_f_Y, m_h+7])
        cylinder(d=bb3_do, h=bb3_h*2, center=true);
        translate([p_X, p_Y, m_h+12])
        cylinder(d=p_d, h=5, center=true);
      }
      
    }
    // opening
    translate([24, 4, m_h/2])
    scale([1.15,1])
    cylinder(d=45, h=m_h+0.1, center=true);
        
    // CNC mount cut
    translate([CNC_pos-m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([CNC_pos-m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([CNC_pos+m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([CNC_pos+m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);

    // Pulley cut
    hull(){
      translate([p_X, p_Y+4, sp_Z-m_wall/2+0.25])
      cylinder(d=M3_hole, h=m_wall, center=true);
      translate([p_X, p_Y-4, sp_Z-m_wall/2+0.25])
      cylinder(d=M3_hole, h=m_wall, center=true);
    }
    // Stepper motor cuts
    sup_wall = 0.7;
    sup_dis = 8;
    translate([sp_X, 3, -m_wall])
    difference(){
      roundedRect([s_cut, m_w-10, sp_Z], 5);
      for(i=[-2:1:2])translate([sup_dis*i, 0, 0])
      cube(size=[sup_wall, m_w, sp_Z * 2.1], center=true);
    }
    translate([sp_X, sp_Y, sp_Z-m_wall/2+0.25]){
      hull(){
        translate([0, hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_wall, center=true);
        translate([0, -hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_wall, center=true);
      }
      for(i=[0:1:1])mirror([0,i,0])
      for(j=[0:1:1])mirror([j,0,0])
      translate([stepper_m/2, stepper_m/2, 0])
      hull(){
        translate([0, -hole_l/2, 0])
        cylinder(d=M3_hole, h=m_wall, center=true);
        translate([0, hole_l/2, 0])
        cylinder(d=M3_hole, h=m_wall, center=true);
      }
    }

    // Spool holder
    translate([sh_X, sh_Y, m_h/2])
    cylinder(d=M3_hole, h=m_h * 1.5, center=true);


      translate([0, bb_bot_a_Y+6, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        // BOTTOM adjustable ball bearing
        translate([bb_bot_f_X, bb_bot_a_Y_shift+5, m_bb_h2/2])
        cylinder(d=M3_hole, h=m_bb_h2+0.1, center=true);

        // TOP adjustable ball bearing
        translate([bb_top_f_X, bb_bot_a_Y_shift+5, m_bb_h2/2])
        cylinder(d=M3_hole, h=m_bb_h2+0.1, center=true);
      }
    // Driven fixed ball bearings
    translate([bb_bot_f_X, bb_bot_f_Y, m_h/2])
    cylinder(d=M3_hole, h=m_h * 2.5, center=true);

    translate([bb_top_f_X, bb_top_f_Y, m_h/2])
    cylinder(d=M3_hole, h=m_h * 2.5, center=true);


    // Adjust screw tower holes
    // Tower 1
    translate([mt_X1, -m_w/2-20, m_h/2+1]){
      for(j=[0:7:28])
      translate([0, 0, j]){
        if(j==0){
          translate([0, 24, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        translate([0, -40, 0])
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=160, center=true);
      }
    }

    // Tower 3
    translate([mt_X3, -m_w/2-20, m_h/2+1]){
      for(j=[0:7:28])
      translate([0, 0, j]){
        if(j==0){
          translate([0, 24, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        if(j != 7){
          translate([0, -40, 0])
          rotate([90, 0, 0])
          cylinder(d=M3_hole, h=160, center=true);
        }
      }
    }


    // Electrode mount cuts
    for(i=[-20:10:30])
    translate([-m_l/2, i-2, m_h])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=10, center=true);
      translate([0, 0, 4.5])
      cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
    }

    // Wire guide
    a = bb_bot_f_X - (bb_bot_f_X - bb_top_f_X)/2;
    translate([a, wire_Y, wire_Z])
    rotate([0, 90, 0])
    cylinder(d=2, h=m_l*1.1, center=true);
  }
}



module V2_mount_003(){
  m_l = 118;
  m_w = 80;
  m_h = 5;
  m_bb_h = 8;
  m_bb_h2 = m_bb_h + 0*bb5_h/2;
  bbl_h = 7;
  m_wall = 2;
  
  // Wire position
  wire_Y = -bb5_do/2-m_w / 2;
  wire_Z = m_bb_h + bb5_h/2;
  
//  echo(wire_Z);
  
  // Center wire guide
  wg_l = 5;
  wg_h = wire_Z + bb5_h/2;
  wg_w = -wire_Y-m_w/2+3;
  
  // TOP fixed ball bearings wire straightener
  bb_p1_X = -3;
  bb_p1_shift_X = 17;
  bb_p1_Y = wire_Y-10;

  // TOP adjustable ball bearing
  bb_p2_X = -28;
  bb_p2_Y = -88;
  bb_p2_Y_shift = 3;

  // BOTTOM adjustable ball bearing
  bb_p3_X = bb_p2_X-24;
  bb_p3_Y = bb_p2_Y;
  bb_p3_Y_shift = 7;

  // Driven fixed ball bearings
  bb_p4_X = bb_p2_X-12.0;
  bb_p4_Y = -m_w / 2;

  bb_p5_X = bb_p2_X+12.0;
  bb_p5_Y = bb_p4_Y;
  
  bb_link_l1 = 38;
  bb_link_h1 = 18;
  bb_link_l2 = 52;
  
  // Adjust screw distance
  as_dis = 52;
  as_2_dis = 33*0+as_dis;
  as_Z = 30;
  
  // Stepper motor position
  sp_X = bb_p2_X;
  sp_Y = 11;
  hole_l = 10;
  
  // Pulley dimensions
  p_X = sp_X;
  p_Y = sp_Y-(stepper_d_cut+hole_l)/2-6.5;
  p_d = 39;
  p_h = 5;
  p_shaft_h = 15;
  p_shaft_d = 10;
  
  // spool holder
  sh_X = 55;
  sh_Y = -25;
  
  brim_d = 8;
  brim_h = 0.35;

  // Mount tower dimensions
  mt_X1 = bb_p2_X+as_dis/2;
  mt_X2 = mt_X1-as_dis;
  mt_X3 = mt_X1 + 20;  
  
  // Electrode mount plate
  em_wall = 1;
  em_l = 15;
  em_shift = -1.0;
  em_shift_Y = 2.0;
  em_w = 12;
  em_w_z = 8.5;
  em_w_d1 = 2;
  em_w_d2 = 4.2;
  em_ovhg = 3.5;
  em_h = 12;
  em_gap = 2;
  em_gap_shift = em_gap/2-em_w/2+1.5;

  
  // Electrode mounts / guides
  if(1)
  for(j=[1:1:1])
  translate([30-j*24, -80, 0])
  difference(){
    union(){
      roundedRect([em_l, em_w, em_h],1);
      if(j==0 || j == 1)
      translate([em_l/4, 0, em_w_z]){
        hull(){
          cube(size=[em_l/2, em_w, 5+2*j], center=true);
          translate([0, em_ovhg + em_shift_Y * j, 0])
          cube(size=[em_l/2, em_w, em_w_d1], center=true);
        }
      }
    }
    // Cut ball bearing edge
    translate([0, em_w/2, 0])
    rotate([45, 0, 0])
    cube(size=[em_l*1.1, 3, 3], center=true);
    
    
    translate([em_shift*j-2.5, 0, 0]){
      // Mount screw cuts
      translate([0, em_shift_Y*j, em_h/2]){
        cylinder(d=M3_hole, h=em_h+0.1, center=true);
        translate([0, 0, em_h/2])
        rotate([0, 0, 30])
        cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
      }
      // Electrode cuts
      translate([7, 0, em_w_z]){
        if(j==1){
          translate([0, em_gap_shift])
          cube(size=[10, em_gap, em_h], center=true);
        }
        rotate([90, 0, 0]){
          cylinder(d=em_w_d1, h=em_w*2.1, center=true);
        }      
      }
    }
  }
  
  // Pulley
  if(0)
  translate([-30, 64, p_h/2])
  difference(){
    union(){
      cylinder(d=p_d, h=p_h, center=true);
      translate([0, 0, (p_shaft_h-p_h)/2])
      cylinder(d1=p_shaft_d*1.7, d2=p_shaft_d, h=p_shaft_h, center=true);
    }
    cylinder(d=M3_hole, h=p_shaft_h*2.1, center=true);
    rotate_extrude(convexity = 10)
    translate([p_d/2, 0, 0])
    rotate([0, 0, 30])
    circle(d = 4, $fn=6);
  }
  
  // Mount
  if(0)
  difference(){
    union(){
      
      roundedRect([m_l, m_w, m_h], 5);
      // CNC mount
      translate([44-m_screw_dis/2, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }
      translate([44+m_screw_dis/2, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }

      translate([44-m_screw_dis*1.5, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }

      // Driven ball bearings
      translate([bb_p4_X, bb_p4_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);

      translate([bb_p5_X, bb_p5_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);
      
      if(0)
      translate([0, bb_p3_Y+6, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        // TOP adjustable ball bearing
        translate([bb_p5_X, bb_p3_Y_shift, m_bb_h2/2]){
          hull(){
            cylinder(d1=10, d2=8, h=m_bb_h2, center=true);
            translate([0, 3.5-bb_p3_Y_shift, -(m_bb_h2-bbl_h)/2])
            cube(size=[10,1, bbl_h], center=true);
          }
        }

        // BOTTOM adjustable ball bearing
        translate([bb_p4_X, bb_p3_Y_shift, m_bb_h2/2]){
          hull(){
            cylinder(d1=10, d2=8, h=m_bb_h2, center=true);
            translate([0, 3.5-bb_p3_Y_shift, -(m_bb_h2-bbl_h)/2])
            cube(size=[10,1, bbl_h], center=true);
          }
        }
        // Adjustable ball bearing linkage
        l = bb_p5_X-bb_p4_X;
        translate([bb_p4_X+l/2, 4, bbl_h/2])
        cube(size=[l, m_wall, bbl_h], center=true);

        // Adjustable ball bearing arm
        translate([bb_p4_X+l/2+bb_link_l2/2, bb_link_h1, bbl_h/2])
        cube(size=[bb_link_l2, m_wall*2, bbl_h], center=true);

        // Adjustable ball bearing arm link
        hull(){
          translate([bb_p4_X+l/2, bb_link_h1, bbl_h/2])
          cube(size=[6, 4, bbl_h], center=true);
          translate([bb_p4_X+l/2, 4, bbl_h/2])
          cube(size=[1, 2, bbl_h], center=true);
        }        
      }


      // Adjust screw towers
      translate([mt_X1, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }
      
      translate([mt_X2, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([-4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }

      translate([mt_X3, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([-4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 18, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }

      // Center wire guide      
      translate([bb_p2_X, -m_w/2, 0]){
        hull(){
          translate([0, 1.5, 0.5])
          cube(size=[wg_l, 3, 1], center=true);
          translate([0, 0, wg_h-0.5])
          cube(size=[wg_l, 6, 1], center=true);
        }
      }
      translate([bb_p2_X, (-m_w-wg_w)/2, wire_Z]){
        cube(size=[wg_l, wg_w, bb5_h], center=true);
      }
      // support structure wire guide
      translate([bb_p2_X, -wg_w-m_w/2, wg_h/2]){
        cube(size=[wg_l, 1.4, wg_h], center=true);
      }
      translate([bb_p2_X, -wg_w-m_w/2, brim_h/2]){
        cylinder(d=9, h=brim_h, center=true);
      }
      

      
      // Ball bearings
      if(0){
        translate([bb_p4_X, bb_p4_Y, m_h+7])
        cylinder(d=bb5_do, h=bb5_h*2, center=true);
        translate([bb_p5_X, bb_p5_Y, m_h+7])
        cylinder(d=bb5_do, h=bb5_h*2, center=true);
        translate([p_X, p_Y, m_h+5])
        cylinder(d=p_d, h=5, center=true);
      }
      
    }
    // opening
    translate([29, 6, m_h/2])
    scale([1,1.1])
    cylinder(d=52, h=m_h+0.1, center=true);
        
    // CNC mount cut
    translate([44-m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44-m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44+m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44+m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44-m_screw_dis*1.5, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44-m_screw_dis*1.5, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);

    // Pulley cut
    hull(){
      translate([p_X, p_Y+2.5, m_h/2])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
      translate([p_X, p_Y-2.5, m_h/2])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
    }
    // Stepper motor cuts
    translate([sp_X, 3, m_wall])
    roundedRect([57.8, m_w-10, m_h], 5);
    translate([sp_X, sp_Y, m_h/2]){
      hull(){
        translate([0, hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_h+0.1, center=true);
        translate([0, -hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_h+0.1, center=true);
      }
      for(i=[0:1:1])mirror([0,i,0])
      for(j=[0:1:1])mirror([j,0,0])
      translate([stepper_m/2, stepper_m/2, 0])
      hull(){
        translate([0, -hole_l/2, 0])
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
        translate([0, hole_l/2, 0])
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
      }
    }

    // Spool holder
    translate([sh_X, sh_Y, m_h/2])
    cylinder(d=M3_hole, h=m_h * 1.5, center=true);


      translate([0, bb_p3_Y+6, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        // BOTTOM adjustable ball bearing
        translate([bb_p4_X, bb_p3_Y_shift, m_bb_h2/2])
        cylinder(d=M5_hole, h=m_bb_h2+0.1, center=true);

        // TOP adjustable ball bearing
        translate([bb_p5_X, bb_p3_Y_shift, m_bb_h2/2])
        cylinder(d=M5_hole, h=m_bb_h2+0.1, center=true);
      }
    // Driven fixed ball bearings
    translate([bb_p4_X, bb_p4_Y, m_h/2])
    cylinder(d=M5_hole, h=m_h * 2.5, center=true);

    translate([bb_p5_X, bb_p5_Y, m_h/2])
    cylinder(d=M5_hole, h=m_h * 2.5, center=true);


    // Adjust screw tower holes
    // Tower 1+2
    translate([bb_p2_X, -m_w/2-20, m_h/2+1]){
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:7:28])
      translate([as_dis/2, 0, j]){
        if(j==0){
          translate([0, 24, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=100, center=true);
      }
    }

    // Tower 3
    translate([mt_X3, -m_w/2-20, m_h/2+1]){
      for(j=[0:7:28])
      translate([0, 0, j]){
        if(j==0){
          translate([0, 24, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=160, center=true);
      }
    }




    // Wire guide
    translate([bb_p2_X, wire_Y, wire_Z])
    rotate([0, 90, 0])
    cylinder(d=2, h=wg_l*1.1, center=true);
  }
}



module V2_mount_002(){
  m_l = 118;
  m_w = 80;
  m_h = 5;
  m_bb_h = 8;
  m_bb_h2 = m_bb_h + 0*bb5_h/2;
  bbl_h = 7;
  m_wall = 2;
  
  // Wire position
  wire_Y = -bb5_do/2-m_w / 2;
  wire_Z = m_bb_h + bb5_h/2;
  
  // Center wire guide
  wg_l = 5;
  wg_h = wire_Z + bb5_h/2;
  wg_w = -wire_Y-m_w/2+3;
  
  // TOP fixed ball bearings wire straightener
  bb_p1_X = -3;
  bb_p1_shift_X = 17;
  bb_p1_Y = wire_Y-10;

  // TOP adjustable ball bearing
  bb_p2_X = -28;
  bb_p2_Y = -88;
  bb_p2_Y_shift = 3;

  // BOTTOM adjustable ball bearing
  bb_p3_X = bb_p2_X-24;
  bb_p3_Y = bb_p2_Y;
  bb_p3_Y_shift = 7;

  // Driven fixed ball bearings
  bb_p4_X = bb_p2_X-12.0;
  bb_p4_Y = -m_w / 2;

  bb_p5_X = bb_p2_X+12.0;
  bb_p5_Y = bb_p4_Y;
  
  bb_link_l1 = 38;
  bb_link_h1 = 18;
  bb_link_l2 = 52;
  
  // Adjust screw distance
  as_dis = 52;
  as_2_dis = 33*0+as_dis;
  as_Z = 30;
  
  // Stepper motor position
  sp_X = bb_p2_X;
  sp_Y = 11;
  hole_l = 10;
  
  // Pulley dimensions
  p_X = sp_X;
  p_Y = sp_Y-(stepper_d_cut+hole_l)/2-6.5;
  p_d = 39;
  p_h = 5;
  p_shaft_h = 15;
  p_shaft_d = 10;
  
  // spool holder
  sh_X = 55;
  sh_Y = -25;
  
  brim_d = 8;
  brim_h = 0.35;

  // Mount tower dimensions
  mt_X1 = bb_p2_X+as_dis/2;
  mt_X2 = mt_X1-as_dis;
  mt_X3 = mt_X1 + 20;  
  
  // Electrode mount plate
  em_wall = 1;
  em_l = 20;
  em_shift = -2.5;
  em_w = 12;
  em_w_z = 8.5;
  em_w_d1 = 2;
  em_w_d2 = M6_hole;
  em_ovhg = 3.5;
  em_h = 12;

  
  // Electrode mount plate
  if(1)
  for(j=[1:1:1])
  translate([30-j*24, -80, 0])
  difference(){
    union(){
      roundedRect([em_l, em_w, em_h],1);
      translate([em_l/4, 0, em_w_z]){
        hull(){
          cube(size=[em_l/2, em_w, 5], center=true);
          translate([0, em_ovhg, 0])
          cube(size=[em_l/2, em_w, em_w_d1], center=true);
        }
        if(j==1){
          rotate([90, 0, 0]){
            translate([0, 0, em_w/2-0.5])
            hull(){
              cylinder(d=14.5, h=9, center=true);
              translate([0, -2.5, 1])
              cylinder(d=12, h=2.1, center=true);
            }
          }      
        }
      }
    }
    // Cut ball bearing edge
    translate([0, em_w/2, 0])
    rotate([45, 0, 0])
    cube(size=[em_l*1.1, 3, 3], center=true);
    
    // Electrode cuts
    translate([em_shift*j-2.5, 0, 0]){
      translate([0, 0, em_h/2]){
        cylinder(d=M3_hole, h=em_h+0.1, center=true);
        translate([0, 0, em_h/2])
        rotate([0, 0, 30])
        cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
      }
      translate([10, 0, em_w_z]){
        cube(size=[10.1, 2, em_h+0.1], center=true);
        rotate([90, 0, 0]){
          cylinder(d=em_w_d1, h=em_w*2.1, center=true);
          if(j==1){
            translate([0, 0, em_w/2-0.5]){
              cylinder(d=em_w_d2, h=em_w, center=true);
              hull(){
                rotate([0, 0, 30])
                cylinder(d=M6_nut_e, h=5.5, center=true, $fn=6);
                translate([0, 10, 0])
                rotate([0, 0, 30])
                cylinder(d=M6_nut_e, h=5.5, center=true, $fn=6);
              }
            }
          }
        }      
      }
    }
  }
  
  // Pulley
  if(0)
  translate([-30, 64, p_h/2])
  difference(){
    union(){
      cylinder(d=p_d, h=p_h, center=true);
      translate([0, 0, (p_shaft_h-p_h)/2])
      cylinder(d1=p_shaft_d*1.7, d2=p_shaft_d, h=p_shaft_h, center=true);
    }
    cylinder(d=M3_hole, h=p_shaft_h*2.1, center=true);
    rotate_extrude(convexity = 10)
    translate([p_d/2, 0, 0])
    rotate([0, 0, 30])
    circle(d = 4, $fn=6);
  }
  
  // Mount
  if(0)
  difference(){
    union(){
      
      roundedRect([m_l, m_w, m_h], 5);
      // CNC mount
      translate([44-m_screw_dis/2, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }
      translate([44+m_screw_dis/2, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }

      translate([44-m_screw_dis*1.5, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }

      // Driven ball bearings
      translate([bb_p4_X, bb_p4_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);

      translate([bb_p5_X, bb_p5_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);
      
      if(0)
      translate([0, bb_p3_Y+6, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        // TOP adjustable ball bearing
        translate([bb_p5_X, bb_p3_Y_shift, m_bb_h2/2]){
          hull(){
            cylinder(d1=10, d2=8, h=m_bb_h2, center=true);
            translate([0, 3.5-bb_p3_Y_shift, -(m_bb_h2-bbl_h)/2])
            cube(size=[10,1, bbl_h], center=true);
          }
        }

        // BOTTOM adjustable ball bearing
        translate([bb_p4_X, bb_p3_Y_shift, m_bb_h2/2]){
          hull(){
            cylinder(d1=10, d2=8, h=m_bb_h2, center=true);
            translate([0, 3.5-bb_p3_Y_shift, -(m_bb_h2-bbl_h)/2])
            cube(size=[10,1, bbl_h], center=true);
          }
        }
        // Adjustable ball bearing linkage
        l = bb_p5_X-bb_p4_X;
        translate([bb_p4_X+l/2, 4, bbl_h/2])
        cube(size=[l, m_wall, bbl_h], center=true);

        // Adjustable ball bearing arm
        translate([bb_p4_X+l/2+bb_link_l2/2, bb_link_h1, bbl_h/2])
        cube(size=[bb_link_l2, m_wall*2, bbl_h], center=true);

        // Adjustable ball bearing arm link
        hull(){
          translate([bb_p4_X+l/2, bb_link_h1, bbl_h/2])
          cube(size=[6, 4, bbl_h], center=true);
          translate([bb_p4_X+l/2, 4, bbl_h/2])
          cube(size=[1, 2, bbl_h], center=true);
        }        
      }


      // Adjust screw towers
      translate([mt_X1, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }
      
      translate([mt_X2, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([-4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }

      translate([mt_X3, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([-4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 18, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }

      // Center wire guide      
      translate([bb_p2_X, -m_w/2, 0]){
        hull(){
          translate([0, 1.5, 0.5])
          cube(size=[wg_l, 3, 1], center=true);
          translate([0, 0, wg_h-0.5])
          cube(size=[wg_l, 6, 1], center=true);
        }
      }
      translate([bb_p2_X, (-m_w-wg_w)/2, wire_Z]){
        cube(size=[wg_l, wg_w, bb5_h], center=true);
      }
      // support structure wire guide
      translate([bb_p2_X, -wg_w-m_w/2, wg_h/2]){
        cube(size=[wg_l, 1.4, wg_h], center=true);
      }
      translate([bb_p2_X, -wg_w-m_w/2, brim_h/2]){
        cylinder(d=9, h=brim_h, center=true);
      }
      

      
      // Ball bearings
      if(0){
        translate([bb_p4_X, bb_p4_Y, m_h+7])
        cylinder(d=bb5_do, h=bb5_h*2, center=true);
        translate([bb_p5_X, bb_p5_Y, m_h+7])
        cylinder(d=bb5_do, h=bb5_h*2, center=true);
        translate([p_X, p_Y, m_h+5])
        cylinder(d=p_d, h=5, center=true);
      }
      
    }
    // opening
    translate([29, 6, m_h/2])
    scale([1,1.1])
    cylinder(d=52, h=m_h+0.1, center=true);
        
    // CNC mount cut
    translate([44-m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44-m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44+m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44+m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44-m_screw_dis*1.5, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([44-m_screw_dis*1.5, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);

    // Pulley cut
    hull(){
      translate([p_X, p_Y+2.5, m_h/2])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
      translate([p_X, p_Y-2.5, m_h/2])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
    }
    // Stepper motor cuts
    translate([sp_X, 3, m_wall])
    roundedRect([57.8, m_w-10, m_h], 5);
    translate([sp_X, sp_Y, m_h/2]){
      hull(){
        translate([0, hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_h+0.1, center=true);
        translate([0, -hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_h+0.1, center=true);
      }
      for(i=[0:1:1])mirror([0,i,0])
      for(j=[0:1:1])mirror([j,0,0])
      translate([stepper_m/2, stepper_m/2, 0])
      hull(){
        translate([0, -hole_l/2, 0])
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
        translate([0, hole_l/2, 0])
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
      }
    }

    // Spool holder
    translate([sh_X, sh_Y, m_h/2])
    cylinder(d=M3_hole, h=m_h * 1.5, center=true);


      translate([0, bb_p3_Y+6, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        // BOTTOM adjustable ball bearing
        translate([bb_p4_X, bb_p3_Y_shift, m_bb_h2/2])
        cylinder(d=M5_hole, h=m_bb_h2+0.1, center=true);

        // TOP adjustable ball bearing
        translate([bb_p5_X, bb_p3_Y_shift, m_bb_h2/2])
        cylinder(d=M5_hole, h=m_bb_h2+0.1, center=true);
      }
    // Driven fixed ball bearings
    translate([bb_p4_X, bb_p4_Y, m_h/2])
    cylinder(d=M5_hole, h=m_h * 2.5, center=true);

    translate([bb_p5_X, bb_p5_Y, m_h/2])
    cylinder(d=M5_hole, h=m_h * 2.5, center=true);


    // Adjust screw tower holes
    // Tower 1+2
    translate([bb_p2_X, -m_w/2-20, m_h/2+1]){
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:7:28])
      translate([as_dis/2, 0, j]){
        if(j==0){
          translate([0, 24, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=100, center=true);
      }
    }

    // Tower 3
    translate([mt_X3, -m_w/2-20, m_h/2+1]){
      for(j=[0:7:28])
      translate([0, 0, j]){
        if(j==0){
          translate([0, 24, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=160, center=true);
      }
    }




    // Wire guide
    translate([bb_p2_X, wire_Y, wire_Z])
    rotate([0, 90, 0])
    cylinder(d=2, h=wg_l*1.1, center=true);
  }
}

module V2_001(){
  m_l = 130;
  m_w = 85;
  m_h = 5;
  m_bb_h = 8;
  bbl_h = 7;
  m_wall = 2;
  
  // Wire position
  wire_Y = 0-m_w / 2;
  wire_Z = m_h + 2.5;
  
  // Wire guide
  wg_X = 12;
  wg_w = 7;
  wg_h = wire_Z + 5;
  wg_l = 6;
  wg_d = 2;
  
  // TOP fixed ball bearings wire straightener
  bb_p1_X = -3;
  bb_p1_shift_X = 17;
  bb_p1_Y = wire_Y-10;

  // CENTER adjustable ball bearing
  bb_p2_X = -34;
  bb_p2_Y = bb_p1_Y+1;
  bb_p2_Y_shift = 3;

  // BOTTOM adjustable ball bearing
  bb_p3_X = bb_p2_X-24;
  bb_p3_Y = bb_p1_Y-28;
  bb_p3_Y_shift = 11;

  // Driven fixed ball bearings
  bb_p4_X = bb_p2_X-12.0;
  bb_p4_Y = wire_Y+0;

  bb_p5_X = bb_p2_X+12.0;
  bb_p5_Y = bb_p4_Y;
  
  bb_link_l1 = 60;
  bb_link_l2 = 60+24;
  
  // Adjust screw distance
  as_dis = 52;
  as_2_dis = 33*0+as_dis;
  as_Z = 30;
  
  // Stepper motor position
  sp_X = bb_p2_X;
  sp_Y = 12;
  hole_l = 10;
  
  // Pulley dimensions
  p_X = sp_X;
  p_Y = sp_Y-(stepper_d_cut+hole_l)/2-6.5;
  p_d = 39;
  p_h = 5;
  p_shaft_h = 5;
  p_shaft_d = 10;
  
  // spool holder
  sh_X = 40;
  sh_Y = -25;
  
  brim_d = 8;
  brim_h = 0.35;
  
  
  // Electrode mount plate
  em_wall = 1;
  em_l = 20;
  em_w = 12;
  
  // Electrode mount plate
  for(j=[0:22:22])
  translate([-15-j, -110*0, 0])
  difference(){
    roundedRect([em_l, em_w, em_wall],2);
    for(i=[-7:7:7])
    translate([i, 0, em_wall/2]){
      cylinder(d=M3_hole, h=em_wall*2.1, center=true);
    }
  }
  
  // Mount tower dimensions
  mt_X1 = bb_p2_X+as_dis/2;
  mt_X2 = mt_X1-as_dis;
  mt_X3 = mt_X1 + 20;
  
  // Pulley
  translate([0, 64, p_h/2])
  difference(){
    union(){
      cylinder(d=p_d, h=p_h, center=true);
      translate([0, 0, (p_shaft_h-p_h)/2])
      cylinder(d1=p_shaft_d*1.7, d2=p_shaft_d, h=p_shaft_h, center=true);
    }
    cylinder(d=M3_hole, h=p_shaft_h*2.1, center=true);
    rotate_extrude(convexity = 10)
    translate([p_d/2, 0, 0])
    rotate([0, 0, 30])
    circle(d = 4, $fn=100);
  }
  
  // Mount
  difference(){
    union(){
      roundedRect([m_l, m_w, m_h], 5);
      // CNC mount
      translate([50-m_screw_dis/2, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }
      translate([50+m_screw_dis/2, 0, m_h/2])
      hull(){
        translate([0, m_w/2+10, 0])
        cylinder(d=12, h=m_h, center=true);
        translate([0, -(m_w/2+10), 0])
        cylinder(d=12, h=m_h, center=true);
      }
/*
      // TOP fixed ball bearings wire streightener
      translate([bb_p1_X+bb_p1_shift_X, bb_p1_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);
      translate([bb_p1_X+bb_p1_shift_X, bb_p1_Y, m_h/2])
      hull(){
        cylinder(d=10, h=m_h, center=true);
        translate([0, -bb_p1_Y, 0])
        cylinder(d1=10, h=m_h, center=true);
      }
*/

      // Driven fixed ball bearings wire streightener
      translate([bb_p4_X, bb_p4_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);

      translate([bb_p5_X, bb_p5_Y, m_bb_h/2])
      cylinder(d1=10, d2=8, h=m_bb_h, center=true);


      translate([0, bb_p2_Y-12, 0])
      for(j=[0:1:1])mirror([0,j,0])
      translate([0, -j, 0]){

        // CENTER adjustable ball bearing
        translate([bb_p2_X, 8, m_bb_h/2])
        cylinder(d1=10, d2=8, h=m_bb_h, center=true);


        // Adjustable ball bearing linkage CENTER bearing
        a = bb_p4_X + (bb_p5_X-bb_p4_X)/2;
        translate([bb_p2_X+bb_link_l1/2, 5, bbl_h/2])
        cube(size=[bb_link_l1, m_wall*2, bbl_h], center=true);

        translate([bb_p2_X+bb_link_l1, 5, brim_h/2])
        cylinder(d=brim_d, h=brim_h, center=true);
//        translate([bb_p2_X-(as_2_dis/2+4), bb_p2_Y-4, brim_h/2])
//        cylinder(d=brim_d, h=brim_h, center=true);
      }
      

      translate([0, bb_p3_Y-10, 0])
      for(j=[0:1:1])mirror([0,j,0]){
        // BOTTOM adjustable ball bearing
        translate([bb_p3_X, bb_p3_Y_shift, m_bb_h/2]){
          hull(){
            cylinder(d1=10, d2=8, h=m_bb_h, center=true);
            translate([0, 2.5-bb_p3_Y_shift, -(m_bb_h-bbl_h)/2])
            cube(size=[10,1, bbl_h], center=true);
          }
        }
        // Adjustable ball bearing linkage BOTTOM bearing
        translate([bb_p3_X+bb_link_l2/2, 4, bbl_h/2])
        cube(size=[bb_link_l2, m_wall*2, bbl_h], center=true);

        translate([bb_p3_X+bb_link_l2, 4, brim_h/2])
        cylinder(d=brim_d, h=brim_h, center=true);
      }

      
      // Adjust screw towers
      translate([mt_X1, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }
      
      translate([mt_X2, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([-4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }

      translate([mt_X3, 4.0-m_w/2, (as_Z+5)/2]){
        cube(size=[10, 8, as_Z+5], center=true);
        translate([-4, 0, 0])
        hull(){
          cube(size=[2, 2, as_Z+5], center=true);
          translate([0, 40, 1-(as_Z+5)/2])
          cube(size=[2, 2, 2], center=true);
        }
      }

      // Wire guide
//      translate([wg_X, wire_Y, wg_h/2])
//      cube(size=[wg_l, wg_w, wg_h], center=true);
      
      // Ball bearings
      if(0){
        translate([bb_p4_X, bb_p4_Y, m_h+7])
        cylinder(d=bb5_do, h=bb5_h*2, center=true);
        translate([bb_p5_X, bb_p5_Y, m_h+7])
        cylinder(d=bb5_do, h=bb5_h*2, center=true);
        translate([p_X, p_Y, m_h+5])
        cylinder(d=p_d, h=5, center=true);
      }
      
    }
    // opening
    translate([31, 8, m_h/2])
    scale([1,1.2])
    cylinder(d=47, h=m_h+0.1, center=true);
        
    // CNC mount cut
    translate([50-m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([50-m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([50+m_screw_dis/2, m_w/2+10, m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);
    translate([50+m_screw_dis/2, -(m_w/2+10), m_h/2])
    cylinder(d=M5_hole, h=m_h+0.1, center=true);

    // Pulley cut
    hull(){
      translate([p_X, p_Y+2.5, m_h/2])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
      translate([p_X, p_Y-2.5, m_h/2])
      cylinder(d=M3_hole, h=m_h+0.1, center=true);
    }
    // Stepper motor cuts
    translate([sp_X, 3, m_wall])
    roundedRect([50, m_w-10, m_h], 5);
    translate([sp_X, sp_Y, m_h/2]){
      hull(){
        translate([0, hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_h+0.1, center=true);
        translate([0, -hole_l/2, 0])
        cylinder(d=stepper_d_cut, h=m_h+0.1, center=true);
      }
      for(i=[0:1:1])mirror([0,i,0])
      for(j=[0:1:1])mirror([j,0,0])
      translate([stepper_m/2, stepper_m/2, 0])
      hull(){
        translate([0, -hole_l/2, 0])
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
        translate([0, hole_l/2, 0])
        cylinder(d=M3_hole, h=m_h+0.1, center=true);
      }
    }

    // Spool holder
    translate([sh_X, sh_Y, m_h/2])
    cylinder(d=M3_hole, h=m_h * 1.5, center=true);

//    // TOP FIXED ball bearings wire straightener
//    translate([bb_p1_X+bb_p1_shift_X, bb_p1_Y, m_h/2])
//    cylinder(d=M5_hole, h=m_h * 2.5, center=true);

    translate([0, bb_p2_Y-12, 0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([0, -j, 0]){
      // CENTER adjustable ball bearing
      translate([bb_p2_X, 8, m_bb_h/2])
      cylinder(d=M5_hole, h=m_h*2.1, center=true);
    }
      
      
    // BOTTOM adjustable ball bearing
    translate([0, bb_p3_Y-10, 0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([bb_p3_X, bb_p3_Y_shift, m_bb_h/2]){
        cylinder(d=M5_hole, h=m_h*2.5, center=true);
      }
    }

    // Driven fixed ball bearings wire straightener
    translate([bb_p4_X, bb_p4_Y, m_h/2])
    cylinder(d=M5_hole, h=m_h * 2.5, center=true);

    translate([bb_p5_X, bb_p5_Y, m_h/2])
    cylinder(d=M5_hole, h=m_h * 2.5, center=true);


    // Adjust screw tower holes
    // Tower 1+2
    translate([bb_p2_X, -m_w/2, m_h/2+1]){
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:7:28])
      translate([as_dis/2, 0, j]){
        if(j==0){
          translate([0, 4, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=60, center=true);
      }
    }

    // Tower 1 long holes
    translate([mt_X1, -m_w/2, m_h/2+1]){
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=60, center=true);
        translate([0, -50, 0])
        rotate([90, 0, 0])
        hull(){
          translate([7, 0, 0])
          cylinder(d=M3_hole, h=30, center=true);
          translate([-7, 0, 0])
          cylinder(d=M3_hole, h=30, center=true);
        }
    }
    // Tower 3
    translate([mt_X3, -m_w/2, m_h/2+1]){
      for(j=[0:7:28])
      translate([0, 0, j]){
        if(j==0){
          translate([0, 4, -1])
          cube(size=[5.6, 3, m_h+4], center=true);
        }
        rotate([90, 0, 0])
        cylinder(d=M3_hole, h=60, center=true);
        translate([0, -50, 0])
        rotate([90, 0, 0])
        hull(){
          translate([7, 0, 0])
          cylinder(d=M3_hole, h=30, center=true);
          translate([-7, 0, 0])
          cylinder(d=M3_hole, h=30, center=true);
        }
      }
    }




    // Wire guide
//    translate([wg_X, wire_Y, wire_Z])
//    rotate([0, 90, 0])
//    cylinder(d=wg_d, h=wg_l*1.1, center=true);
  }
}


module coin_holder(){
  coin_d = 20.9;
  coin_h = 3.5;
  
  cm_l = 35;
  cm_w = 35;
  cm_h = 20;
  cm_wall = 2;
  cm_h_plus = 1;
  cm_flap = 30;
  screw_dis = 50;
  
  ref_x = coin_d/2+3;
  ref_y = coin_d/2+3;
  ref_z = 5;
  
  difference(){
    union(){
      roundedRect([cm_l+2*cm_flap, cm_w, cm_wall], 5);
      roundedRect([cm_l, cm_w, cm_h+cm_h_plus], 5);
      // reference marking
      intersection(){
        roundedRect([cm_l, cm_w, cm_h+cm_h_plus+ref_z], 5);
        translate([ref_x, ref_x, cm_h-1+ref_z/2])
        cylinder(d1=9, d2=3, h=ref_z, center=true);
      }
    }
    difference(){
      translate([0, 0, cm_h])
      roundedRect([cm_l-2*cm_wall, cm_w-2*cm_wall, cm_h], 4);
      // reference marking
      translate([ref_x, ref_x, cm_h-1+ref_z/2])
      cylinder(d1=9, d2=3, h=ref_z, center=true);
    }
    // Coin mount
    translate([0, 0, cm_h-coin_h/2])
    rotate([90, 0, 0])
    cylinder(d=M3_hole, h=cm_w+0.1, center=true);
    for(i=[0:1:1])
    mirror([0,i,0])
    translate([0, coin_d/2+3.55, cm_h-coin_h/2]){
      cube(size=[5.5, 3, 7], center=true);
      cylinder(d=2, h=15, center=true);
    }
    //cable cuts
    translate([0, 0, cm_h/2-4])
    rotate([90, 0, 0])
    cylinder(d=M3_hole, h=cm_w+0.1, center=true);
    translate([0, 0, cm_h/2+2])
    rotate([90, 0, 0])
    cylinder(d=M3_hole, h=cm_w+0.1, center=true);
    // Coin
    translate([0, 0, cm_h - coin_h/2+0.1])
    cylinder(d=coin_d, h=coin_h, center=true);
    // Inner cylinder
    translate([0, 0, cm_h/2])
    cylinder(d=coin_d-5, h=cm_h+0.1, center=true);
    // reference marking
    translate([ref_x, ref_x, cm_h+ref_z-1])
    cylinder(d=1.0, h=2, center=true);
    // Mount screws
    for(i=[0:1:1])
    mirror([i,0,0])
    translate([screw_dis/2, 0, cm_wall/2])
    hull(){
      cylinder(d=M6_hole, h=cm_wall+0.1, center=true);
      translate([15, 0, 0])
      cylinder(d=M6_hole, h=cm_wall+0.1, center=true);
    }
  }
  
}

module roundedRect(size, radius, edges=[1, 1, 1, 1], vscale=[1,1], shift=0){
  x = size[0];
  y = size[1];
  z = size[2];

  translate([0, -shift*2, 0]){
    linear_extrude(height=z, scale=[vscale[0], vscale[1]]){
      translate([0, shift*2, 0]){
        hull(){
            // place 4 circles in the corners, with the given radius
            if(edges[0]){
              translate([(-x/2)+(radius), (-y/2)+(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(-x/2)+(radius/2), (-y/2)+(radius/2), 0])
              square(size=[radius, radius], center=true);
            }
            if(edges[1]){
              translate([(x/2)-(radius), (-y/2)+(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(x/2)-(radius/2), (-y/2)+(radius/2), 0])
              square(size=[radius, radius], center=true);
            }

            if(edges[2]){
              translate([(-x/2)+(radius), (y/2)-(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(-x/2)+(radius/2), (y/2)-(radius/2), 0])
              square(size=[radius, radius], center=true);
            }

            if(edges[3]){
              translate([(x/2)-(radius), (y/2)-(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(x/2)-(radius/2), (y/2)-(radius/2), 0])
              square(size=[radius, radius], center=true);
            }
          }
       }
    }
  }
}